/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.screens.ConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.LongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.LongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.McoWorldTemplateScreen;
import com.mojang.realmsclient.gui.screens.ScreenWithCallback;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class ResetWorldScreen
extends ScreenWithCallback<WorldTemplate> {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen lastScreen;
    private RealmsScreen onlineScreen;
    private RealmsScreen worldManagementScreen;
    private RealmsServer serverData;
    private RealmsEditBox seedEdit;
    private Boolean generateStructures = true;
    private Integer levelTypeIndex = 0;
    String[] levelTypes;
    private final int RESET_BUTTON_ID = 1;
    private final int CANCEL_BUTTON = 2;
    private static final int WORLD_TEMPLATE_BUTTON = 3;
    private static final int LEVEL_TYPE_BUTTON_ID = 4;
    private static final int GENERATE_STRUCTURES_BUTTON_ID = 5;
    private final int SEED_EDIT_BOX = 6;
    private WorldTemplate selectedWorldTemplate;
    private RealmsButton resetButton;
    private RealmsButton levelTypeButton;
    private RealmsButton generateStructuresButton;

    public ResetWorldScreen(RealmsScreen lastScreen, RealmsScreen onlineScreen, RealmsScreen worldManagementScreen, RealmsServer serverData) {
        this.lastScreen = lastScreen;
        this.onlineScreen = onlineScreen;
        this.worldManagementScreen = worldManagementScreen;
        this.serverData = serverData;
    }

    public void tick() {
        this.seedEdit.tick();
    }

    public void init() {
        this.levelTypes = new String[]{ResetWorldScreen.getLocalizedString((String)"generator.default"), ResetWorldScreen.getLocalizedString((String)"generator.flat"), ResetWorldScreen.getLocalizedString((String)"generator.largeBiomes"), ResetWorldScreen.getLocalizedString((String)"generator.amplified")};
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.resetButton = ResetWorldScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)ResetWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.reset"));
        this.buttonsAdd(this.resetButton);
        this.buttonsAdd(ResetWorldScreen.newButton((int)2, (int)(this.width() / 2 + 5), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)ResetWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.seedEdit = this.newEditBox(6, this.width() / 2 - 100, 99, 200, 20);
        this.seedEdit.setFocus(true);
        this.seedEdit.setMaxLength(32);
        this.seedEdit.setValue("");
        this.levelTypeButton = ResetWorldScreen.newButton((int)4, (int)(this.width() / 2 - 102), (int)145, (int)205, (int)20, (String)this.levelTypeTitle());
        this.buttonsAdd(this.levelTypeButton);
        this.generateStructuresButton = ResetWorldScreen.newButton((int)5, (int)(this.width() / 2 - 102), (int)165, (int)205, (int)20, (String)this.generateStructuresTitle());
        this.buttonsAdd(this.generateStructuresButton);
        if (this.selectedWorldTemplate == null) {
            this.buttonsAdd(ResetWorldScreen.newButton((int)3, (int)(this.width() / 2 - 102), (int)125, (int)205, (int)20, (String)ResetWorldScreen.getLocalizedString((String)"mco.template.default.name")));
        } else {
            this.seedEdit.setValue("");
            this.seedEdit.setIsEditable(false);
            this.seedEdit.setFocus(false);
            this.buttonsAdd(ResetWorldScreen.newButton((int)3, (int)(this.width() / 2 - 102), (int)125, (int)205, (int)20, (String)(ResetWorldScreen.getLocalizedString((String)"mco.template.name") + ": " + this.selectedWorldTemplate.name)));
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void keyPressed(char ch, int eventKey) {
        this.seedEdit.keyPressed(ch, eventKey);
        if (eventKey == 28 || eventKey == 156) {
            this.buttonClicked(this.resetButton);
        }
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.worldManagementScreen);
        }
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 2) {
            Realms.setScreen((RealmsScreen)this.worldManagementScreen);
        } else if (button.id() == 1) {
            String line2 = ResetWorldScreen.getLocalizedString((String)"mco.configure.world.reset.question.line1");
            String line3 = ResetWorldScreen.getLocalizedString((String)"mco.configure.world.reset.question.line2");
            Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Warning, line2, line3, 1));
        } else if (button.id() == 3) {
            Realms.setScreen((RealmsScreen)new McoWorldTemplateScreen(this, this.selectedWorldTemplate, false));
        } else if (button.id() == 4) {
            this.levelTypeIndex = (this.levelTypeIndex + 1) % this.levelTypes.length;
            button.msg(this.levelTypeTitle());
        } else if (button.id() == 5) {
            this.generateStructures = this.generateStructures == false;
            button.msg(this.generateStructuresTitle());
        }
    }

    public void confirmResult(boolean result, int id) {
        if (result && id == 1) {
            this.resetWorld();
        } else {
            Realms.setScreen((RealmsScreen)this);
        }
    }

    private void resetWorld() {
        ResettingWorldTask resettingWorldTask = new ResettingWorldTask(this.serverData.id, this.seedEdit.getValue(), this.selectedWorldTemplate, this.levelTypeIndex, this.generateStructures);
        LongRunningMcoTaskScreen longRunningMcoTaskScreen = new LongRunningMcoTaskScreen(this.lastScreen, resettingWorldTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        this.seedEdit.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(ResetWorldScreen.getLocalizedString((String)"mco.reset.world.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(ResetWorldScreen.getLocalizedString((String)"mco.reset.world.warning"), this.width() / 2, 56, 0xFF0000);
        this.drawString(ResetWorldScreen.getLocalizedString((String)"mco.reset.world.seed"), this.width() / 2 - 100, 86, 0xA0A0A0);
        this.seedEdit.render();
        super.render(xm, ym, a);
    }

    @Override
    void callback(WorldTemplate worldTemplate) {
        this.selectedWorldTemplate = worldTemplate;
    }

    private String levelTypeTitle() {
        String levelType = ResetWorldScreen.getLocalizedString((String)"selectWorld.mapType");
        return levelType + " " + this.levelTypes[this.levelTypeIndex];
    }

    private String generateStructuresTitle() {
        return ResetWorldScreen.getLocalizedString((String)"selectWorld.mapFeatures") + " " + (this.generateStructures != false ? ResetWorldScreen.getLocalizedString((String)"mco.configure.world.on") : ResetWorldScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    private class ResettingWorldTask
    extends LongRunningTask {
        private final long worldId;
        private final String seed;
        private final WorldTemplate worldTemplate;
        private final int levelType;
        private final boolean generateStructures;

        public ResettingWorldTask(long worldId, String seed, WorldTemplate worldTemplate, int levelType, boolean generateStructures) {
            this.worldId = worldId;
            this.seed = seed;
            this.worldTemplate = worldTemplate;
            this.levelType = levelType;
            this.generateStructures = generateStructures;
        }

        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.reset.world.resetting.screen.title");
            this.setTitle(title);
            for (int i = 0; i < 6; ++i) {
                try {
                    if (this.aborted()) {
                        return;
                    }
                    if (this.worldTemplate != null) {
                        client.resetWorldWithTemplate(this.worldId, this.worldTemplate.id);
                        Realms.setScreen((RealmsScreen)new ConfigureWorldScreen(ResetWorldScreen.this.onlineScreen, this.worldId));
                        return;
                    }
                    client.resetWorldWithSeed(this.worldId, this.seed, this.levelType, this.generateStructures);
                    if (this.aborted()) {
                        return;
                    }
                    Realms.setScreen((RealmsScreen)new ConfigureWorldScreen(ResetWorldScreen.this.onlineScreen, this.worldId));
                    return;
                }
                catch (RetryCallException e) {
                    if (this.aborted()) {
                        return;
                    }
                    this.pause(e.delaySeconds);
                    continue;
                }
                catch (RealmsServiceException e) {
                    if (this.aborted()) {
                        return;
                    }
                    LOGGER.error("Couldn't reset world");
                    this.error(e.toString());
                    return;
                }
                catch (Exception e) {
                    if (this.aborted()) {
                        return;
                    }
                    LOGGER.error("Couldn't reset world");
                    this.error(e.toString());
                    return;
                }
            }
        }

        private void pause(int pauseTimeSeconds) {
            try {
                Thread.sleep(pauseTimeSeconds * 1000);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

