/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConfirmResultListener;
import com.mojang.realmsclient.gui.screens.ConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsWorldSettingsSubScreen;
import java.io.UnsupportedEncodingException;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class EditRealmsWorldScreen
extends RealmsScreen
implements RealmsConfirmResultListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen configureWorldScreen;
    private RealmsScreen onlineScreen;
    private RealmsEditBox descEdit;
    private RealmsEditBox nameEdit;
    private RealmsServer serverData;
    private static final int DONE_BUTTON_ID = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int MORE_SETTINGS_BUTTON_ID = 3;
    private static final int NAME_EDIT_BOX = 4;
    private static final int DESC_EDIT_BOX = 5;
    private RealmsButton doneButton;
    private RealmsButton moreSettingsButton;

    public EditRealmsWorldScreen(RealmsScreen configureWorldScreen, RealmsScreen onlineScreen, RealmsServer serverData) {
        this.configureWorldScreen = configureWorldScreen;
        this.onlineScreen = onlineScreen;
        this.serverData = serverData;
    }

    public void tick() {
        this.nameEdit.tick();
        this.descEdit.tick();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.moreSettingsButton = EditRealmsWorldScreen.newButton((int)3, (int)(this.width() / 2 - 106), (int)(this.height() / 4 + 120 - 3), (int)216, (int)20, (String)EditRealmsWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.moreoptions"));
        this.buttonsAdd(this.moreSettingsButton);
        this.doneButton = EditRealmsWorldScreen.newButton((int)0, (int)(this.width() / 2 - 106), (int)(this.height() / 4 + 120 + 22), (int)106, (int)20, (String)EditRealmsWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.done"));
        this.buttonsAdd(this.doneButton);
        this.buttonsAdd(EditRealmsWorldScreen.newButton((int)1, (int)(this.width() / 2 + 4), (int)(this.height() / 4 + 120 + 22), (int)106, (int)20, (String)EditRealmsWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.nameEdit = this.newEditBox(4, this.width() / 2 - 106, 56, 212, 20);
        this.nameEdit.setFocus(true);
        this.nameEdit.setMaxLength(32);
        this.nameEdit.setValue(this.serverData.getName());
        this.descEdit = this.newEditBox(5, this.width() / 2 - 106, 96, 212, 20);
        this.descEdit.setMaxLength(32);
        this.descEdit.setValue(this.serverData.getMotd());
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 1) {
            Realms.setScreen((RealmsScreen)this.configureWorldScreen);
        } else if (button.id() == 0) {
            this.update();
        } else if (button.id() == 3) {
            this.saveServerData();
            Realms.setScreen((RealmsScreen)new RealmsWorldSettingsSubScreen(this, this.serverData));
        }
    }

    private void saveServerData() {
        this.serverData.setName(this.nameEdit.getValue());
        this.serverData.setMotd(this.descEdit.getValue());
    }

    public void keyPressed(char ch, int eventKey) {
        this.nameEdit.keyPressed(ch, eventKey);
        this.descEdit.keyPressed(ch, eventKey);
        if (eventKey == 15) {
            this.nameEdit.setFocus(!this.nameEdit.isFocused());
            this.descEdit.setFocus(!this.descEdit.isFocused());
        }
        if (eventKey == 28 || eventKey == 156) {
            this.update();
        }
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.configureWorldScreen);
        }
        this.doneButton.active(this.nameEdit.getValue() != null && !this.nameEdit.getValue().trim().equals(""));
    }

    private void update() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            String desc = this.descEdit.getValue() == null || this.descEdit.getValue().trim().equals("") ? null : this.descEdit.getValue();
            client.update(this.serverData.id, this.nameEdit.getValue(), desc, this.serverData.difficulty, this.serverData.gameMode, this.serverData.options);
            this.saveServerData();
            Realms.setScreen((RealmsScreen)new ConfigureWorldScreen(this.onlineScreen, this.serverData.id));
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't edit world");
            Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, (RealmsScreen)this));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Couldn't edit world");
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        this.descEdit.mouseClicked(x, y, buttonNum);
        this.nameEdit.mouseClicked(x, y, buttonNum);
    }

    @Override
    public void confirmResult(boolean result, int id) {
        Realms.setScreen((RealmsScreen)this);
    }

    public void saveServerData(int difficuly, int gameMode, boolean pvp, boolean spawnNPCs, boolean spawnAnimals, boolean spawnMonsters, int spawnProtection, boolean commandBlocks) {
        this.serverData.difficulty = difficuly;
        this.serverData.gameMode = gameMode;
        this.serverData.options.pvp = pvp;
        this.serverData.options.spawnNPCs = spawnNPCs;
        this.serverData.options.spawnAnimals = spawnAnimals;
        this.serverData.options.spawnMonsters = spawnMonsters;
        this.serverData.options.spawnProtection = spawnProtection;
        this.serverData.options.commandBlocks = commandBlocks;
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(EditRealmsWorldScreen.getLocalizedString((String)"mco.configure.world.edit.title"), this.width() / 2, 17, 0xFFFFFF);
        String nameString = EditRealmsWorldScreen.getLocalizedString((String)"mco.configure.world.name");
        String descriptionString = EditRealmsWorldScreen.getLocalizedString((String)"mco.configure.world.description");
        this.drawString(nameString, this.width() / 2 - 106, 43, 0xA0A0A0);
        this.drawString(descriptionString, this.width() / 2 - 106, 84, 0xA0A0A0);
        this.nameEdit.render();
        this.descEdit.render();
        super.render(xm, ym, a);
    }
}

