/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.ServerActivity;
import com.mojang.realmsclient.dto.ServerActivityList;
import com.mojang.realmsclient.exception.RealmsServiceException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsScrolledSelectionList;
import net.minecraft.realms.Tezzelator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ActivityScreen
extends RealmsScreen {
    private final RealmsScreen lastScreen;
    private final long serverId;
    private volatile List<ActivityRow> activityMap = new ArrayList<ActivityRow>();
    private DetailsList list;
    private int matrixWidth;
    private int matrixHeight;
    private String toolTip;
    private volatile List<Day> dayList = new ArrayList<Day>();
    private List<Color> colors = Arrays.asList(new Color(79, 243, 29), new Color(243, 175, 29), new Color(243, 29, 190), new Color(29, 165, 243), new Color(29, 243, 130), new Color(243, 29, 64), new Color(29, 74, 243));
    private int colorIndex = 0;
    private long periodInMillis;
    private int fontWidth;
    private int maxKeyWidth = 0;
    private Boolean noActivity = false;
    private static LoadingCache<String, String> activitiesNameCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String uuid) throws Exception {
            return Realms.uuidToName((String)uuid);
        }
    });

    public ActivityScreen(RealmsScreen lastScreen, long serverId) {
        this.lastScreen = lastScreen;
        this.serverId = serverId;
        this.getActivities();
    }

    public void mouseEvent() {
        super.mouseEvent();
        this.list.mouseEvent();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.matrixWidth = this.width();
        this.matrixHeight = this.height() - 40;
        this.fontWidth = this.fontWidth("A");
        this.list = new DetailsList();
        this.buttonsAdd(ActivityScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)(this.height() - 30), (int)200, (int)20, (String)ActivityScreen.getLocalizedString((String)"gui.back")));
    }

    private Color getColor() {
        if (this.colorIndex > this.colors.size() - 1) {
            this.colorIndex = 0;
        }
        Color color = this.colors.get(this.colorIndex);
        ++this.colorIndex;
        return color;
    }

    private void getActivities() {
        new Thread(){

            @Override
            public void run() {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    ServerActivityList activities = client.getActivity(ActivityScreen.this.serverId);
                    ActivityScreen.this.activityMap = ActivityScreen.this.convertToActivityMatrix(activities);
                    ArrayList<Day> tempDayList = new ArrayList<Day>();
                    for (ActivityRow row : ActivityScreen.this.activityMap) {
                        for (Activity activity : row.activities) {
                            String day = new SimpleDateFormat("dd/MM").format(new Date(activity.start));
                            Day the_day = new Day(day, activity.start);
                            if (tempDayList.contains(the_day)) continue;
                            tempDayList.add(the_day);
                        }
                    }
                    Collections.sort(tempDayList, new Comparator<Day>(){

                        @Override
                        public int compare(Day day1, Day day2) {
                            return day1.timestamp.compareTo(day2.timestamp);
                        }
                    });
                    ActivityScreen.this.dayList = tempDayList;
                }
                catch (RealmsServiceException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private List<ActivityRow> convertToActivityMatrix(ServerActivityList serverActivityList) {
        ArrayList activityRows = Lists.newArrayList();
        this.periodInMillis = serverActivityList.periodInMillis;
        long base = System.currentTimeMillis() - serverActivityList.periodInMillis;
        for (ServerActivity sa : serverActivityList.serverActivities) {
            ActivityRow activityRow = this.find(sa.profileUuid, activityRows);
            Calendar joinTime = Calendar.getInstance(TimeZone.getDefault());
            joinTime.setTimeInMillis(sa.joinTime);
            Calendar leaveTime = Calendar.getInstance(TimeZone.getDefault());
            leaveTime.setTimeInMillis(sa.leaveTime);
            Activity e = new Activity(base, joinTime.getTimeInMillis(), leaveTime.getTimeInMillis());
            if (activityRow == null) {
                String name = "";
                try {
                    name = (String)activitiesNameCache.get((Object)sa.profileUuid);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                activityRow = new ActivityRow(sa.profileUuid, new ArrayList<Activity>(), this.getColor(), name);
                activityRow.activities.add(e);
                activityRows.add(activityRow);
                continue;
            }
            activityRow.activities.add(e);
        }
        for (ActivityRow row : activityRows) {
            Collections.sort(row.activities);
        }
        this.noActivity = activityRows.size() == 0;
        return activityRows;
    }

    private ActivityRow find(String key, List<ActivityRow> rows) {
        for (ActivityRow row : rows) {
            if (!row.key.equals(key)) continue;
            return row;
        }
        return null;
    }

    public void tick() {
        super.tick();
    }

    public void buttonClicked(RealmsButton button) {
        if (button.id() == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void render(int xm, int ym, float a) {
        this.toolTip = null;
        this.renderBackground();
        this.list.render(xm, ym, a);
        this.drawCenteredString(ActivityScreen.getLocalizedString((String)"mco.activity.title"), this.width() / 2, 10, 0xFFFFFF);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(this.toolTip, xm, ym);
        }
        if (this.noActivity.booleanValue()) {
            this.drawCenteredString(ActivityScreen.getLocalizedString((String)"mco.activity.noactivity", (Object[])new Object[]{TimeUnit.DAYS.convert(this.periodInMillis, TimeUnit.MILLISECONDS)}), this.width() / 2, this.height() / 2 - 20, 0xFFFFFF);
        }
        super.render(xm, ym, a);
    }

    protected void renderMousehoverTooltip(String msg, int x, int y) {
        if (msg == null) {
            return;
        }
        int rx = x - 80;
        int ry = y - 12;
        int index = 0;
        int width = 0;
        for (String s : msg.split("\n")) {
            int the_width = this.fontWidth(s);
            if (the_width <= width) continue;
            width = the_width;
        }
        for (String s : msg.split("\n")) {
            this.fillGradient(rx - 3, ry - (index == 0 ? 3 : 0) + index, rx + width + 3, ry + 8 + 3 + index, -1073741824, -1073741824);
            this.fontDrawShadow(s, rx, ry + index, -1);
            index += 10;
        }
    }

    class DetailsList
    extends RealmsScrolledSelectionList {
        public DetailsList() {
            super(ActivityScreen.this.width(), ActivityScreen.this.height(), 30, ActivityScreen.this.height() - 40, ActivityScreen.this.fontLineHeight() + 1);
        }

        public int getItemCount() {
            return ActivityScreen.this.activityMap.size();
        }

        public void selectItem(int item, boolean doubleClick, int xMouse, int yMouse) {
        }

        public boolean isSelectedItem(int item) {
            return false;
        }

        public void renderBackground() {
        }

        public int getMaxPosition() {
            return this.getItemCount() * (ActivityScreen.this.fontLineHeight() + 1) + ActivityScreen.this.height() - 110;
        }

        protected void renderItem(int i, int x, int y, int h, Tezzelator t, int mouseX, int mouseY) {
            if (ActivityScreen.this.activityMap != null && ActivityScreen.this.activityMap.size() > 0) {
                ActivityScreen.this.drawString(((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).name, 20, y, 0xFFFFFF);
                int keyWidth = ActivityScreen.this.fontWidth * ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).name.length();
                if (keyWidth > ActivityScreen.this.maxKeyWidth) {
                    ActivityScreen.this.maxKeyWidth = keyWidth + 5;
                }
                int keyRightPadding = 25;
                int activityPoint = ActivityScreen.this.maxKeyWidth + keyRightPadding;
                int spaceLeft = ActivityScreen.this.matrixWidth - activityPoint - 10;
                int days = ActivityScreen.this.dayList.size() < 1 ? 1 : ActivityScreen.this.dayList.size();
                int dayWidth = spaceLeft / days;
                double hourWidth = (double)dayWidth / 24.0;
                double minuteWidth = hourWidth / 60.0;
                GL11.glDisable((int)3553);
                t.begin();
                t.color(((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.r, ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.g, ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.b);
                t.vertex((double)(activityPoint - 8), (double)(y + 7), 0.0);
                t.vertex((double)(activityPoint - 3), (double)(y + 7), 0.0);
                t.vertex((double)(activityPoint - 3), (double)(y + 2), 0.0);
                t.vertex((double)(activityPoint - 8), (double)(y + 2), 0.0);
                t.end();
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3553);
                t.begin();
                t.color(0x808080);
                t.vertex((double)activityPoint, (double)(ActivityScreen.this.height() - 40), 0.0);
                t.vertex((double)(activityPoint + 1), (double)(ActivityScreen.this.height() - 40), 0.0);
                t.vertex((double)(activityPoint + 1), (double)(-ActivityScreen.this.height()), 0.0);
                t.vertex((double)activityPoint, (double)(-ActivityScreen.this.height()), 0.0);
                t.end();
                GL11.glEnable((int)3553);
                int daysIndex = 1;
                for (Day day : ActivityScreen.this.dayList) {
                    ActivityScreen.this.drawString(day.day, activityPoint + (daysIndex - 1) * dayWidth + (dayWidth - ActivityScreen.this.fontWidth(day.day)) / 2 + 2, ActivityScreen.this.height() - 52, 0xFFFFFF);
                    GL11.glDisable((int)3553);
                    t.begin();
                    t.color(0x808080);
                    t.vertex((double)(activityPoint + daysIndex * dayWidth), (double)(ActivityScreen.this.height() - 40), 0.0);
                    t.vertex((double)(activityPoint + daysIndex * dayWidth + 1), (double)(ActivityScreen.this.height() - 40), 0.0);
                    t.vertex((double)(activityPoint + daysIndex * dayWidth + 1), (double)(-ActivityScreen.this.height()), 0.0);
                    t.vertex((double)(activityPoint + daysIndex * dayWidth), (double)(-ActivityScreen.this.height()), 0.0);
                    t.end();
                    GL11.glEnable((int)3553);
                    for (Activity activity : ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).activities) {
                        String the_day = new SimpleDateFormat("dd/MM").format(new Date(activity.start));
                        if (!the_day.equals(day.day)) continue;
                        int minute = activity.minuteIndice();
                        int hour = activity.hourIndice();
                        double itemWidth = minuteWidth * (double)TimeUnit.MINUTES.convert(activity.end - activity.start, TimeUnit.MILLISECONDS);
                        if (itemWidth < 3.0) {
                            itemWidth = 3.0;
                        }
                        GL11.glDisable((int)3553);
                        t.begin();
                        t.color(((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.r, ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.g, ((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).color.b);
                        t.vertex((double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth, (double)(y + 7), 0.0);
                        t.vertex((double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth + itemWidth, (double)(y + 7), 0.0);
                        t.vertex((double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth + itemWidth, (double)(y + 2), 0.0);
                        t.vertex((double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth, (double)(y + 2), 0.0);
                        t.end();
                        GL11.glEnable((int)3553);
                        if (!((double)this.xm() >= (double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth) || !((double)this.xm() <= (double)(activityPoint + (dayWidth * daysIndex - dayWidth)) + (double)hour * hourWidth + (double)minute * minuteWidth + itemWidth) || this.ym() < y || this.ym() > y + 10) continue;
                        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
                        Date startDate = new Date(activity.start);
                        Date endDate = new Date(activity.end);
                        int length = (int)Math.ceil((double)TimeUnit.SECONDS.convert(activity.end - activity.start, TimeUnit.MILLISECONDS) / 60.0);
                        if (length < 1) {
                            length = 1;
                        }
                        ActivityScreen.this.toolTip = "[" + format.format(startDate) + " - " + format.format(endDate) + "]\n" + length + (length > 1 ? " minutes" : " minute");
                    }
                    ++daysIndex;
                }
                RealmsScreen.bindFace((String)((ActivityRow)((ActivityScreen)ActivityScreen.this).activityMap.get((int)i)).name);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RealmsScreen.blit((int)10, (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                RealmsScreen.blit((int)10, (int)y, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
        }

        public int getScrollbarPosition() {
            return this.width() - 10;
        }
    }

    static class Activity
    implements Comparable<Activity> {
        long base;
        long start;
        long end;

        private Activity(long base, long start, long end) {
            this.base = base;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(Activity o) {
            return (int)(this.start - o.start);
        }

        public int hourIndice() {
            String hour = new SimpleDateFormat("HH").format(new Date(this.start));
            return Integer.parseInt(hour);
        }

        public int minuteIndice() {
            String minute = new SimpleDateFormat("mm").format(new Date(this.start));
            return Integer.parseInt(minute);
        }
    }

    static class ActivityRow {
        String key;
        List<Activity> activities;
        Color color;
        String name;

        ActivityRow(String key, List<Activity> activities, Color color, String name) {
            this.key = key;
            this.activities = activities;
            this.color = color;
            this.name = name;
        }
    }

    static class Day {
        String day;
        Long timestamp;

        Day(String day, Long timestamp) {
            this.day = day;
            this.timestamp = timestamp;
        }

        public boolean equals(Object d) {
            if (!(d instanceof Day)) {
                return false;
            }
            Day that = (Day)d;
            return this.day.equals(that.day);
        }
    }

    static class Color {
        int r;
        int g;
        int b;

        Color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

