/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class BlockFluidBase
extends aji
implements IFluidBlock {
    protected static final Map<aji, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<aji, Boolean> displacements = Maps.newHashMap();
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected int renderPass = 1;
    protected int maxScaledLight = 0;
    protected final String fluidName;

    public BlockFluidBase(Fluid fluid, awt material) {
        super(material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.a(true);
        this.H();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.displacements.putAll(defaultDisplacements);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(ahl world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir(world, x, y2, z2)) {
            return true;
        }
        aji block = world.a(x, y2, z2);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        awt material = block.o();
        if (material.c() || material == awt.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, x, y2, z2);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(ahb world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir((ahl)world, x, y2, z2)) {
            return true;
        }
        aji block = world.a(x, y2, z2);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, x, y2, z2, world.e(x, y2, z2), 0);
                return true;
            }
            return false;
        }
        awt material = block.o();
        if (material.c() || material == awt.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((ahl)world, x, y2, z2);
        if (density == Integer.MAX_VALUE) {
            block.b(world, x, y2, z2, world.e(x, y2, z2), 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(ahl var1, int var2, int var3, int var4);

    public abstract boolean a(int var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void b(ahb world, int x, int y2, int z2) {
        world.a(x, y2, z2, (aji)this, this.tickRate);
    }

    public void a(ahb world, int x, int y2, int z2, aji block) {
        world.a(x, y2, z2, (aji)this, this.tickRate);
    }

    public boolean L() {
        return false;
    }

    public boolean b(ahl world, int x, int y2, int z2) {
        return true;
    }

    public azt a(ahb world, int x, int y2, int z2) {
        return null;
    }

    public adb a(int par1, Random par2Random, int par3) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(ahb world) {
        return this.tickRate;
    }

    public void a(ahb world, int x, int y2, int z2, sa entity, azw vec) {
        if (this.densityDir > 0) {
            return;
        }
        azw vec_flow = this.getFlowVector((ahl)world, x, y2, z2);
        vec.a += vec_flow.a * (double)(this.quantaPerBlock * 4);
        vec.b += vec_flow.b * (double)(this.quantaPerBlock * 4);
        vec.c += vec_flow.c * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(ahl world, int x, int y2, int z2) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y2, z2);
        }
        int data = world.e(x, y2, z2);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public int b() {
        return FluidRegistry.renderIdFluid;
    }

    public boolean c() {
        return false;
    }

    public boolean d() {
        return false;
    }

    public int c(ahl world, int x, int y2, int z2) {
        int lightThis = world.c(x, y2, z2, 0);
        int lightUp = world.c(x, y2 + 1, z2, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    public int w() {
        return this.renderPass;
    }

    public boolean a(ahl world, int x, int y2, int z2, int side) {
        aji block = world.a(x, y2, z2);
        if (block != this) {
            return !block.c();
        }
        return block.o() == this.o() ? false : super.a(world, x, y2, z2, side);
    }

    public static final int getDensity(ahl world, int x, int y2, int z2) {
        aji block = world.a(x, y2, z2);
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(ahl world, int x, int y2, int z2) {
        aji block = world.a(x, y2, z2);
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(ahl world, int x, int y2, int z2) {
        aji block = world.a(x, y2, z2);
        if (!block.o().d()) {
            return -1000.0;
        }
        azw vec = ((BlockFluidBase)block).getFlowVector(world, x, y2, z2);
        return vec.a == 0.0 && vec.c == 0.0 ? -1000.0 : Math.atan2(vec.c, vec.a) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(ahl world, int x, int y2, int z2, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(ahl world, int x, int y2, int z2, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(ahl world, int x, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public azw getFlowVector(ahl world, int x, int y2, int z2) {
        azw vec = azw.a((double)0.0, (double)0.0, (double)0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y2, z2);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z22 = z2;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z22;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y2, z22);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.a(x2, y2, z22).o().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y2 - 1, z22)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.c((double)((x2 - x) * power), (double)((y2 - y2) * power), (double)((z22 - z2) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.c((double)((x2 - x) * power), (double)((y2 - y2) * power), (double)((z22 - z2) * power));
        }
        if (world.a(x, y2 + 1, z2) == this) {
            boolean flag;
            boolean bl2 = flag = this.d(world, x, y2, z2 - 1, 2) || this.d(world, x, y2, z2 + 1, 3) || this.d(world, x - 1, y2, z2, 4) || this.d(world, x + 1, y2, z2, 5) || this.d(world, x, y2 + 1, z2 - 1, 2) || this.d(world, x, y2 + 1, z2 + 1, 3) || this.d(world, x - 1, y2 + 1, z2, 4) || this.d(world, x + 1, y2 + 1, z2, 5);
            if (flag) {
                vec = vec.a().c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(ahb world, int x, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue((ahl)world, x, y2, z2) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    static {
        defaultDisplacements.put(ajn.ao, false);
        defaultDisplacements.put(ajn.av, false);
        defaultDisplacements.put(ajn.an, false);
        defaultDisplacements.put(ajn.as, false);
        defaultDisplacements.put(ajn.aH, false);
    }
}

