/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.listeners;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import mcedu.common.EduCommandEnums;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.MessageBox;
import mcedu.server.EduAssignmentHelper;
import mcedu.server.EduServerFunctions;
import mcedu.server.EduServerHooks;
import mcedu.server.EduServerSettings;
import mcedu.server.EduServerStatusHelper;
import mcedu.server.EduServerTemp;
import mcedu.server.gui.servergui.EduServerGui;

public class EduServerGuiActionListener
implements ActionListener {
    private EduServerGui serverGui;
    private lt dedicatedServer;

    private String tr(String StringToBetranslated) {
        return de.a().a(StringToBetranslated);
    }

    public EduServerGuiActionListener(EduServerGui serverGui, lt dedicatedServer) {
        this.serverGui = serverGui;
        this.dedicatedServer = dedicatedServer;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand() == null) {
            return;
        }
        String cmdName = evt.getActionCommand().toString();
        if (EduServerStatusHelper.getStatus() != 2 && !cmdName.equals(this.tr("serverGui.advancedSettings")) && !cmdName.equals(this.tr("serverGui.settingsCommands"))) {
            return;
        }
        if (cmdName.equals(this.tr("serverGui.saveMap"))) {
            this.serverGui.functionality.buttonSaveMapActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.advancedSettings"))) {
            this.serverGui.buttonAdvancedSettingsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.settingsCommands"))) {
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.stopServer"))) {
            int i = 0;
            UIManager UI = new UIManager();
            UIManager.put("OptionPane.background", new ColorUIResource(178, 196, 211));
            UIManager.put("Panel.background", new ColorUIResource(178, 196, 211));
            UIManager.put("Button.background", new ColorUIResource(178, 196, 211));
            UIManager.put("OptionPane.messagebackground", new ColorUIResource(178, 196, 211));
            Object[] options = new Object[]{this.tr("serverGui.quit"), this.tr("serverGui.returnServertool"), this.tr("serverGui.cancel")};
            try {
                i = JOptionPane.showOptionDialog(this.serverGui, this.tr("serverGui.areYouSure"), this.tr("serverGui.stopServer"), 1, 3, null, options, options[2]);
            }
            catch (HeadlessException e) {
                i = 0;
                e.printStackTrace();
            }
            if (i == 0) {
                this.serverGui.executeCommandInServer(EduCommandEnums.ORIG_CMD_SERVERSTOP);
            } else if (i == 1) {
                EduServerTemp.getS().startServerToolAfterShutdown = true;
                this.serverGui.executeCommandInServer(EduCommandEnums.ORIG_CMD_SERVERSTOP);
            }
        } else if (cmdName.equals(this.tr("serverGui.serverInformation"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsInformationPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.worldInformation"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsWorldInformationPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.settings"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsSettingsPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.general"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsGeneralPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.world"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsWorldPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.give"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsGivePanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.assignment"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsAssignmentPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals(this.tr("serverGui.usercontrol"))) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsUserControlPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else if (cmdName.equals("ComputerCraftEdu")) {
            this.serverGui.setCurrentCommandsTab(this.serverGui.panelFactory.createCommandsCCEduPanel());
            this.serverGui.buttonCommandsActionPerformed();
        } else {
            this.actionPerformedCommands(evt);
        }
    }

    public void actionPerformedCommands(ActionEvent evt) {
        String cmdName = evt.getActionCommand().toString();
        if (cmdName.equals(this.tr("serverGui.changePassword"))) {
            EduServerFunctions.setTeacherPassword(false);
        }
        if (cmdName.equals(this.tr("serverGui.storePlayersWithAlias"))) {
            EduServerSettings.getS().settingsServerHandler.setSettingStorePlayersWithAlias(!EduServerSettings.getS().settingsServerHandler.getStorePlayersWithAlias());
        }
        if (cmdName.equals(this.tr("serverGui.saveMOTD"))) {
            EduServerSettings.getS().settingsWorldHandler.setMOTD(this.serverGui.EduCommandsSettingsMOTD.getText());
            EduServerHooks.getS().setServerMOTD(this.dedicatedServer);
        }
        if (cmdName.equals(this.tr("serverGui.openMapFolder"))) {
            try {
                File file = new File(EduServerSettings.getS().pathCurrentDir);
                Datahandler.openFolder(file.getParent() + "/worlds/tmpworld/");
            }
            catch (Exception e) {
                MessageBox.error("Cannot open folder", e.toString());
            }
        }
        if (cmdName.equals(this.tr("serverGui.openWorldDetails"))) {
            String url = Datahandler.iniGet(EduServerSettings.getS().pathMapInfoFile, "worldInfoURL");
            Datahandler.openURL(url);
        }
        if (cmdName.equals(this.tr("serverGui.onlineMode"))) {
            EduServerSettings.getS().settingsServerProperties.setSettingOnlineMode(!EduServerSettings.getS().settingsServerProperties.getSettingOnlineMode());
        }
        if (cmdName.equals(this.tr("serverGui.teleportAllToSpawn"))) {
            String[] playerlist = this.dedicatedServer.aC().eduGetPlayerAliasList();
            if (playerlist[0].equals("")) {
                JOptionPane.showMessageDialog(this.serverGui, this.tr("serverGui.noPlayersOnServer"));
                return;
            }
            if (MessageBox.confirmDialog(this.tr("serverGui.Confirmation"), this.tr("serverGui.confirmTeleportAllBackToSpawn")) == 0) {
                this.serverGui.executeCommandInServer("/eduteleport teleportalltospawn");
            }
        } else if (cmdName.equals(this.tr("serverGui.freezeAllStudents"))) {
            this.serverGui.executeCommandInServer("/educommand freezeallstudentsnogui");
        } else if (cmdName.equals(this.tr("serverGui.muteAllStudents"))) {
            this.serverGui.executeCommandInServer("/educommand muteallstudentsnogui");
        } else if (cmdName.equals(this.tr("serverGui.keepInventory"))) {
            this.serverGui.executeCommandInServer("/educommand keepinventory");
        } else if (cmdName.equals(this.tr("serverGui.enableCreative"))) {
            this.serverGui.executeCommandInServer("/educommand enablecreativemode");
        } else if (cmdName.equals(this.tr("serverGui.allowStudentRespawn"))) {
            this.serverGui.executeCommandInServer("/educommand studentscanteleport");
        } else if (cmdName.equals(this.tr("serverGui.allowStudentUnstick"))) {
            this.serverGui.executeCommandInServer("/educommand studentscanunstuck");
        } else if (cmdName.equals(this.tr("serverGui.nether"))) {
            this.serverGui.executeCommandInServer("/educommand nether");
        } else if (cmdName.equals(this.tr("serverGui.pvp"))) {
            this.serverGui.executeCommandInServer("/educommand pvp");
        } else if (cmdName.equals(this.tr("serverGui.studentsCanFly"))) {
            this.serverGui.executeCommandInServer("/educommand studentscanfly");
        } else if (cmdName.equals(this.tr("serverGui.lockTime"))) {
            this.serverGui.executeCommandInServer("/educommand timespeed");
        } else if (cmdName.equals(this.tr("serverGui.enableWeather"))) {
            this.serverGui.executeCommandInServer("/educommand weathereffects");
        } else if (cmdName.equals(this.tr("serverGui.allowFireTnt"))) {
            this.serverGui.executeCommandInServer("/educommand firetnt");
        } else if (cmdName.equals(this.tr("serverGui.studentsCanBuild"))) {
            this.serverGui.executeCommandInServer("/educommand studentbuild");
        } else if (cmdName.equals(this.tr("serverGui.tropification"))) {
            this.serverGui.executeCommandInServer("/educommand tropification");
        } else if (cmdName.equals(this.tr("serverGui.desertification"))) {
            this.serverGui.executeCommandInServer("/educommand tropification");
        } else if (cmdName.equals(this.tr("serverGui.realism"))) {
            this.serverGui.executeCommandInServer("/educommand realism");
        } else if (cmdName.equals(this.tr("serverGui.monsters"))) {
            this.serverGui.executeCommandInServer("/educommand monsters");
        } else if (cmdName.equals(this.tr("serverGui.animals"))) {
            this.serverGui.executeCommandInServer("/educommand animals");
        } else if (cmdName.equals(this.tr("serverGui.villagers"))) {
            this.serverGui.executeCommandInServer("/educommand villagers");
        } else if (cmdName.equals(this.tr("serverGui.saveWelcomMessage"))) {
            EduServerSettings.getS().settingsWorldHandler.setWelcomeMessage(this.serverGui.EduCommandsWorldWelcomeMessage.getText());
        }
        if (cmdName.equals(this.tr("serverGui.generateStructures"))) {
            EduServerSettings.getS().settingsWorldHandler.setSettingGenerateStructures(!EduServerSettings.getS().settingsWorldHandler.getSettingGenerateStructures());
        } else if (cmdName.equals(this.tr("serverGui.giveUser")) || cmdName.equals(this.tr("serverGui.giveAll"))) {
            this.serverGui.functionality.commandGiveItemToUser(cmdName);
        } else if (cmdName.equals(this.tr("serverGui.addAssignment")) || cmdName.equals(this.tr("serverGui.clearAssignment")) || cmdName.equals(this.tr("serverGui.modifyAssignment"))) {
            if (cmdName.equals(this.tr("serverGui.addAssignment"))) {
                EduAssignmentHelper.handleServerAddAssignment();
            } else if (cmdName.equals(this.tr("serverGui.modifyAssignment")) && EduAssignmentHelper.selectedAssignment != null) {
                EduAssignmentHelper.handleServerModifyAssignment();
            } else {
                int result = MessageBox.confirmDialog("", "serverGui.ConfirmDeleteAssignment");
                if (result == 0) {
                    EduAssignmentHelper.removeAssignment(EduAssignmentHelper.selectedAssignment.id);
                }
            }
        }
        if (cmdName.equals(this.tr("serverGui.enableTurtles"))) {
            this.serverGui.executeCommandInServer("/ccedu enableccedu");
        }
        if (cmdName.equals(this.tr("serverGui.giveRemote"))) {
            this.serverGui.executeCommandInServer("/ccedu giveallremote");
        }
        if (cmdName.equals(this.tr("serverGui.giveTurtle"))) {
            this.serverGui.executeCommandInServer("/ccedu giveallturtle");
        }
        if (cmdName.equals(this.tr("serverGui.freezeTurtles"))) {
            this.serverGui.executeCommandInServer("/ccedu stopallturtles");
        }
        if (cmdName.equals(this.tr("serverGui.enableVisualEditor"))) {
            this.serverGui.executeCommandInServer("/ccedu forcecodeview");
        }
        if (cmdName.equals(this.tr("serverGui.enableSuggestions"))) {
            this.serverGui.executeCommandInServer("/ccedu disableide");
        }
        if (cmdName.equals(this.tr("serverGui.turtlesCanBuild"))) {
            this.serverGui.executeCommandInServer("/ccedu turtlescanbuild");
        }
        this.serverGui.refreshCurrentCommandsPanel();
    }
}

