/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.components.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mcedu.global.icons.IconFactory;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.GetOS;
import mcedu.global.tools.MessageBox;
import mcedu.global.tools.Security;
import mcedu.server.EduServerSettings;
import mcedu.server.gui.servergui.EduServerGui;
import mcedu.server.gui.servergui.components.ComponentFactory;
import mcedu.server.gui.servergui.components.panels.PanelBase;

public class PanelUserControl
extends PanelBase
implements ActionListener,
FocusListener,
ItemListener,
ListSelectionListener {
    public static boolean displayAddUserAliasDefaultText = true;
    public static boolean displayAddUserPasswordDefaultText = true;
    private JButton buttonAliasProtection;
    private JButton buttonAliasProtectionRestrict;
    private JCheckBox checkboxRoleStudent;
    private JCheckBox checkboxRoleTeacher;
    private JTextField textfieldNewRoleUsernameDefault;
    private JTextField textfieldNewRolePasswordDefault;
    private JTextField textfieldNewRoleUsername;
    private JPasswordField textfieldNewRolePassword;
    private JButton buttonAddNewRole;
    private DefaultListModel listUsersModel;
    private JList listUsers;
    private JButton buttonRemoveUser;

    public PanelUserControl(EduServerGui serverGui) {
        super(serverGui);
    }

    @Override
    public void initializeComponents() {
        this.buttonAliasProtection = new JButton();
        this.buttonAliasProtectionRestrict = new JButton();
        this.checkboxRoleStudent = new JCheckBox();
        this.checkboxRoleTeacher = new JCheckBox();
        this.textfieldNewRoleUsernameDefault = new JTextField();
        this.textfieldNewRolePasswordDefault = new JTextField();
        this.textfieldNewRoleUsername = new JTextField();
        this.textfieldNewRolePassword = new JPasswordField();
        this.buttonAddNewRole = new JButton();
        this.listUsersModel = new DefaultListModel();
        this.listUsers = new JList();
        this.buttonRemoveUser = new JButton();
        this.listUsers.setModel(this.listUsersModel);
        this.checkboxRoleStudent.setSelected(true);
        this.textfieldNewRoleUsernameDefault.setText(this.tr("Alias"));
        this.textfieldNewRolePasswordDefault.setText(this.tr("Password"));
    }

    @Override
    public void addListeners() {
        this.buttonAliasProtection.addActionListener(this);
        this.buttonAliasProtectionRestrict.addActionListener(this);
        this.checkboxRoleStudent.addItemListener(this);
        this.checkboxRoleTeacher.addItemListener(this);
        this.textfieldNewRoleUsernameDefault.addFocusListener(this);
        this.textfieldNewRolePasswordDefault.addFocusListener(this);
        this.textfieldNewRoleUsername.addFocusListener(this);
        this.textfieldNewRolePassword.addFocusListener(this);
        this.textfieldNewRoleUsername.addFocusListener(this);
        this.textfieldNewRolePassword.addFocusListener(this);
        this.textfieldNewRoleUsername.addActionListener(this);
        this.textfieldNewRolePassword.addActionListener(this);
        this.buttonAddNewRole.addActionListener(this);
        this.buttonRemoveUser.addActionListener(this);
        this.listUsers.addListSelectionListener(this);
    }

    @Override
    public JPanel createPanel() throws Exception {
        JPanel jpanelcontainer = this.createBasePanel();
        JPanel jpanel = new JPanel();
        jpanel.setBackground(EduServerGui.EduSouthBGColor);
        jpanel.setLayout(new BoxLayout(jpanel, 3));
        jpanelcontainer.add(jpanel);
        JPanel panelLeft = this.createLeftPanel();
        JPanel panelRight = this.createRightPanel();
        JPanel wrapperPanel = this.createWrapperPanel();
        wrapperPanel.add(panelLeft);
        wrapperPanel.add(panelRight);
        panelLeft.add(this.createPanelAliasProtectionTop());
        if (EduServerSettings.getS().settingsServerHandler.getSettingAliasProtection()) {
            panelLeft.add(this.createPanelAliasProtectionCenter());
            panelLeft.add(Box.createVerticalStrut(10));
            panelLeft.add(this.createPanelAliasProtectionBottom());
            panelRight.add(this.createUserPanel());
        }
        jpanel.add(wrapperPanel);
        return jpanelcontainer;
    }

    private JPanel createWrapperPanel() {
        JPanel wrapperPanel = new JPanel();
        wrapperPanel.setBackground(EduServerGui.EduSouthBGColor);
        GridLayout gridLay = new GridLayout(1, 3);
        gridLay.setHgap(30);
        wrapperPanel.setLayout(gridLay);
        wrapperPanel.setMinimumSize(new Dimension(600, 500));
        wrapperPanel.setMaximumSize(new Dimension(600, 500));
        wrapperPanel.setPreferredSize(new Dimension(600, 500));
        return wrapperPanel;
    }

    private JPanel createLeftPanel() {
        JPanel panelLeft = new JPanel();
        panelLeft.setMinimumSize(new Dimension(300, 800));
        panelLeft.setLayout(new BoxLayout(panelLeft, 1));
        panelLeft.setBackground(EduServerGui.EduSouthBGColor);
        return panelLeft;
    }

    private JPanel createRightPanel() {
        JPanel panelRight = new JPanel();
        panelRight.setMaximumSize(new Dimension(300, 800));
        panelRight.setLayout(new BoxLayout(panelRight, 1));
        panelRight.setBackground(EduServerGui.EduSouthBGColor);
        return panelRight;
    }

    private JPanel createPanelAliasProtectionTop() {
        JPanel panel = new JPanel();
        panel.setBackground(EduServerGui.EduSouthBGColor);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentY(0.0f);
        panel.add(Box.createVerticalStrut(12));
        panel.add(ComponentFactory.createCheckButton(this.buttonAliasProtection, this.tr("serverGui.aliasProtection"), EduServerSettings.getS().settingsServerHandler.getSettingAliasProtection(), 300, 25));
        JLabel labelAliasProtInfoText = new JLabel();
        labelAliasProtInfoText.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.tr("serverGui.aliasProtectionInfoText") + "</html>");
        labelAliasProtInfoText.setForeground(Color.darkGray);
        panel.add(Box.createVerticalStrut(5));
        panel.add(labelAliasProtInfoText);
        panel.add(Box.createVerticalStrut(11));
        return panel;
    }

    private JPanel createPanelAliasProtectionCenter() {
        JPanel panel = new JPanel();
        panel.setBackground(EduServerGui.EduSouthBGColor);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentY(0.0f);
        panel.add(ComponentFactory.createCheckButton(this.buttonAliasProtectionRestrict, this.tr("serverGui.aliasProtectionRestrict"), EduServerSettings.getS().settingsServerHandler.getSettingRestrictNewUsersToJoin(), 300, 25));
        JLabel labelRestrictInfoText = new JLabel();
        labelRestrictInfoText.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.tr("serverGui.aliasProtectionRestrictInfoText") + "</html>");
        labelRestrictInfoText.setForeground(Color.darkGray);
        panel.add(Box.createVerticalStrut(5));
        panel.add(labelRestrictInfoText);
        panel.add(Box.createVerticalStrut(11));
        return panel;
    }

    private JPanel createPanelAliasProtectionBottom() {
        JPanel panel = new JPanel();
        panel.setBackground(EduServerGui.EduSouthBGColor);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentY(0.0f);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), this.tr("serverGui.userControlAddNewUser")));
        panel.setPreferredSize(new Dimension(100, 300));
        panel.add(Box.createVerticalStrut(5));
        panel.add(new JLabel("<html>&nbsp;&nbsp;" + this.tr("serverGui.userControlRole") + "</html>"));
        JPanel panelRole = new JPanel();
        panelRole.setBackground(EduServerGui.EduSouthBGColor);
        panelRole.setLayout(new BoxLayout(panelRole, 0));
        panelRole.setAlignmentX(0.0f);
        this.checkboxRoleStudent.setText(this.tr("serverGui.userControlRoleStudent") + "      ");
        this.checkboxRoleTeacher.setText(this.tr("serverGui.userControlRoleTeacher"));
        this.checkboxRoleStudent.setForeground(Color.DARK_GRAY);
        this.checkboxRoleTeacher.setForeground(Color.DARK_GRAY);
        this.checkboxRoleStudent.setBackground(EduServerGui.EduSouthBGColor);
        this.checkboxRoleTeacher.setBackground(EduServerGui.EduSouthBGColor);
        panelRole.add(this.checkboxRoleStudent);
        panelRole.add(this.checkboxRoleTeacher);
        panel.add(panelRole);
        panel.add(Box.createVerticalStrut(5));
        JPanel panelLabels = new JPanel();
        panelLabels.setLayout(new BoxLayout(panelLabels, 0));
        panelLabels.setAlignmentX(0.0f);
        panelLabels.setBackground(EduServerGui.EduSouthBGColor);
        panelLabels.add(Box.createHorizontalStrut(3));
        int height = 20;
        if (GetOS.getOS() == 2) {
            height = 29;
        }
        this.textfieldNewRoleUsername.setForeground(Color.DARK_GRAY);
        this.textfieldNewRoleUsername.setPreferredSize(new Dimension(120, height));
        this.textfieldNewRoleUsername.setMaximumSize(new Dimension(120, height));
        this.textfieldNewRoleUsername.setMinimumSize(new Dimension(120, height));
        this.textfieldNewRoleUsernameDefault.setPreferredSize(new Dimension(120, height));
        this.textfieldNewRoleUsernameDefault.setMaximumSize(new Dimension(120, height));
        this.textfieldNewRoleUsernameDefault.setMinimumSize(new Dimension(120, height));
        this.textfieldNewRoleUsernameDefault.setForeground(Color.gray);
        if (displayAddUserAliasDefaultText) {
            panelLabels.add(this.textfieldNewRoleUsernameDefault);
        } else {
            panelLabels.add(this.textfieldNewRoleUsername);
        }
        panelLabels.add(Box.createHorizontalStrut(10));
        this.textfieldNewRolePassword.setForeground(Color.DARK_GRAY);
        this.textfieldNewRolePassword.setPreferredSize(new Dimension(120, height));
        this.textfieldNewRolePassword.setMinimumSize(new Dimension(120, height));
        this.textfieldNewRolePassword.setMaximumSize(new Dimension(120, height));
        this.textfieldNewRolePasswordDefault.setPreferredSize(new Dimension(120, height));
        this.textfieldNewRolePasswordDefault.setMinimumSize(new Dimension(120, height));
        this.textfieldNewRolePasswordDefault.setMaximumSize(new Dimension(120, height));
        this.textfieldNewRolePasswordDefault.setForeground(Color.gray);
        if (this.checkboxRoleStudent.isSelected()) {
            if (displayAddUserPasswordDefaultText) {
                panelLabels.add(this.textfieldNewRolePasswordDefault);
            } else {
                panelLabels.add(this.textfieldNewRolePassword);
            }
        }
        panelLabels.setMaximumSize(new Dimension(300, 30));
        panelLabels.add(Box.createHorizontalStrut(10));
        panel.add(panelLabels);
        panel.add(Box.createVerticalStrut(10));
        if (this.checkboxRoleStudent.isSelected()) {
            this.buttonAddNewRole.setText(this.tr("serverGui.userControlAddStudent"));
        } else {
            this.buttonAddNewRole.setText(this.tr("serverGui.userControlAddTeacher"));
        }
        this.buttonAddNewRole.setIcon(new ImageIcon(this.getClass().getResource(IconFactory.getSilkIconPath("user.png"))));
        this.buttonAddNewRole.setBackground(EduServerGui.EduSouthBGColor);
        panel.add(this.buttonAddNewRole);
        panel.add(Box.createRigidArea(new Dimension(10, 12)));
        return panel;
    }

    private JPanel createListPanel(ArrayList<UserStruct> data, String headerText) {
        JPanel panel = new JPanel();
        panel.setBackground(EduServerGui.EduSouthBGColor);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setAlignmentY(0.0f);
        JLabel labelHeader = new JLabel(headerText);
        labelHeader.setAlignmentX(0.5f);
        panel.add(labelHeader);
        panel.add(Box.createVerticalStrut(0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAlignmentX(0.5f);
        this.listUsersModel.removeAllElements();
        for (int i = 0; i < data.size(); ++i) {
            this.listUsersModel.add(i, data.get(i));
        }
        this.listUsers.setCellRenderer(new CustomUserListCellRenderer());
        scrollPane.setViewportView(this.listUsers);
        panel.add(scrollPane);
        panel.add(Box.createVerticalStrut(5));
        return panel;
    }

    private JPanel createUserPanel() {
        JPanel userPanel = this.createListPanel(this.getUsersFromFile(), this.tr("serverGui.userControlUsers"));
        userPanel.setAlignmentX(0.5f);
        userPanel.setMaximumSize(new Dimension(200, 299));
        this.buttonRemoveUser.setText(this.tr("serverGui.userControlRemoveUser"));
        this.buttonRemoveUser.setIcon(new ImageIcon(this.getClass().getResource(IconFactory.getSilkIconPath("user_delete.png"))));
        this.buttonRemoveUser.setBackground(EduServerGui.EduSouthBGColor);
        this.buttonRemoveUser.setAlignmentX(0.5f);
        if (this.listUsers.isSelectionEmpty()) {
            this.buttonRemoveUser.setEnabled(false);
        } else {
            this.buttonRemoveUser.setEnabled(true);
        }
        userPanel.add(this.buttonRemoveUser);
        return userPanel;
    }

    public ArrayList<UserStruct> getUsersFromFile() {
        List userLines = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathReservedAliases);
        ArrayList<UserStruct> users = new ArrayList<UserStruct>();
        for (String line : userLines) {
            try {
                String[] user = line.split("=");
                users.add(new UserStruct(user[0], user[1].equals("teacher")));
            }
            catch (Exception e) {}
        }
        ArrayList<UserStruct> teachers = new ArrayList<UserStruct>();
        ArrayList<UserStruct> students = new ArrayList<UserStruct>();
        for (UserStruct user : users) {
            if (user.isTeacher) {
                teachers.add(user);
                continue;
            }
            students.add(user);
        }
        Collections.sort(teachers);
        Collections.sort(students);
        ArrayList<UserStruct> returnUsers = new ArrayList<UserStruct>();
        returnUsers.addAll(teachers);
        returnUsers.addAll(students);
        return returnUsers;
    }

    public void addAlias() {
        String name = this.textfieldNewRoleUsername.getText().toLowerCase();
        String password = this.textfieldNewRolePassword.getText();
        String aliasInFile = Datahandler.iniGet(EduServerSettings.getS().pathReservedAliases, name);
        if (aliasInFile == null) {
            aliasInFile = "";
        }
        if (name == null || name.length() < 3 || name.length() > 16) {
            MessageBox.notice("Error", this.tr("serverGui.userControlMessageAliasLength"));
            return;
        }
        if (this.checkboxRoleStudent.isSelected() && (password == null || password.length() < 5)) {
            MessageBox.notice("Error", this.tr("serverGui.userControlMessagePasswordLength"));
            return;
        }
        if (!aliasInFile.isEmpty()) {
            MessageBox.notice("Error", this.tr("serverGui.userControlMessageAliasExists"));
            return;
        }
        Datahandler.iniSet(EduServerSettings.getS().pathReservedAliases, name.toLowerCase(), this.checkboxRoleStudent.isSelected() ? Security.getMd5(password) : "teacher");
        this.textfieldNewRoleUsername.setText("");
        this.textfieldNewRolePassword.setText("");
        displayAddUserAliasDefaultText = true;
        displayAddUserPasswordDefaultText = true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            if (evt.getSource() == this.buttonAliasProtection) {
                EduServerSettings.getS().settingsServerHandler.setSettingAliasProtection(!EduServerSettings.getS().settingsServerHandler.getSettingAliasProtection());
            } else if (evt.getSource() == this.buttonAliasProtectionRestrict) {
                EduServerSettings.getS().settingsServerHandler.setSettingRestrictNewUsersToJoin(!EduServerSettings.getS().settingsServerHandler.getSettingRestrictNewUsersToJoin());
            } else if (evt.getSource() == this.buttonRemoveUser) {
                Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathReservedAliases, ((UserStruct)this.listUsers.getSelectedValue()).name + "=");
            } else if (evt.getSource() == this.buttonAddNewRole) {
                this.addAlias();
            } else if (evt.getSource() == this.textfieldNewRoleUsername) {
                this.addAlias();
            } else if (evt.getSource() == this.textfieldNewRolePassword) {
                this.addAlias();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.refreshPanel();
    }

    @Override
    public void focusGained(FocusEvent evt) {
        try {
            if (evt.getSource() == this.textfieldNewRoleUsernameDefault) {
                displayAddUserAliasDefaultText = false;
                this.refreshPanel();
                this.textfieldNewRoleUsername.requestFocus();
            } else if (evt.getSource() == this.textfieldNewRolePasswordDefault) {
                displayAddUserPasswordDefaultText = false;
                this.refreshPanel();
                this.textfieldNewRolePassword.requestFocus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        try {
            if (evt.getSource() == this.textfieldNewRoleUsername) {
                if (this.textfieldNewRoleUsername.getText().isEmpty()) {
                    displayAddUserAliasDefaultText = true;
                    this.refreshPanel();
                }
            } else if (evt.getSource() == this.textfieldNewRolePassword && this.textfieldNewRolePassword.getText().isEmpty()) {
                displayAddUserPasswordDefaultText = true;
                this.refreshPanel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        try {
            if (evt.getSource() == this.checkboxRoleStudent) {
                if (this.checkboxRoleStudent.isSelected()) {
                    this.checkboxRoleTeacher.setSelected(false);
                } else {
                    this.checkboxRoleStudent.setSelected(false);
                    this.checkboxRoleTeacher.setSelected(true);
                }
                this.refreshPanel();
            } else if (evt.getSource() == this.checkboxRoleTeacher) {
                if (this.checkboxRoleTeacher.isSelected()) {
                    this.checkboxRoleStudent.setSelected(false);
                } else {
                    this.checkboxRoleTeacher.setSelected(false);
                    this.checkboxRoleStudent.setSelected(true);
                }
                this.refreshPanel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        try {
            if (evt.getSource() == this.listUsers && !evt.getValueIsAdjusting()) {
                this.buttonRemoveUser.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CustomUserListCellRenderer
    extends DefaultListCellRenderer {
        private CustomUserListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            UserStruct user = (UserStruct)value;
            JLabel label = (JLabel)renderer;
            label.setText(user.name);
            if (user.isTeacher) {
                label.setForeground(Color.black);
                label.setIcon(new ImageIcon(this.getClass().getResource(IconFactory.getSilkIconPath("user_gray.png"))));
            } else {
                label.setForeground(Color.DARK_GRAY);
                label.setIcon(new ImageIcon(this.getClass().getResource(IconFactory.getSilkIconPath("user.png"))));
            }
            return renderer;
        }
    }

    private class UserStruct
    implements Comparable<UserStruct> {
        public String name = "";
        public boolean isTeacher = false;

        public UserStruct(String name, boolean isTeacher) {
            this.name = name;
            this.isTeacher = isTeacher;
        }

        @Override
        public int compareTo(UserStruct o) {
            return this.name.compareTo(o.name);
        }
    }
}

