/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.components;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import mcedu.global.localization.Localization;
import mcedu.server.gui.servergui.EduServerGui;

public class EduSlider
extends JSlider {
    private EduServerGui gui;
    private lt server;

    public EduSlider(int i, int j, int k2, int l, EduServerGui gui, lt server) {
        super(i, j, k2, l);
        this.gui = gui;
        this.server = server;
        this.initSlider();
    }

    private void initSlider() {
        this.setValue(this.getWorlTimeForSliderValue());
        this.setupVisuals();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                int sliderValue = EduSlider.this.getValue();
                int currentTime = (int)EduSlider.this.server.d().N().g();
                int finalValue = currentTime - currentTime % 24000 + sliderValue;
                EduSlider.this.server.a("/time set " + finalValue, (ac)EduSlider.this.server);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
    }

    public int getWorlTimeForSliderValue() {
        float currentWorldTime = this.server.d().N().g();
        float curWorldTime = 0.0f;
        curWorldTime = currentWorldTime > 24000.0f ? currentWorldTime % 24000.0f : currentWorldTime;
        return (int)curWorldTime;
    }

    private void setupVisuals() {
        this.setAlignmentX(0.0f);
        this.setMinimumSize(new Dimension(280, 50));
        this.setPreferredSize(new Dimension(280, 50));
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.setMajorTickSpacing(2000);
        this.setMinorTickSpacing(500);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        int add2 = 6;
        for (int i = 0; i < 25; i += 2) {
            if (i > 18) {
                add2 = -18;
            }
            table.put(i * 1000, new JLabel(Integer.toString(i + add2)));
        }
        this.setLabelTable(table);
        this.setToolTipText(Localization.getS().tr("serverGui.TimeSliderToolTip"));
    }
}

