/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.components;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import mcedu.global.icons.IconFactory;
import mcedu.server.gui.servergui.EduServerGui;

public class ComponentFactory {
    public static JComboBox createCombobox(JComboBox combobox, ArrayList<String> items, ItemListener listener, int selectedIndex, int width, int height, String tooltipText) {
        if (combobox.getItemCount() == 0) {
            for (String item : items) {
                combobox.addItem(item);
            }
            combobox.setSelectedIndex(selectedIndex);
            combobox.addItemListener(listener);
        } else {
            combobox.setSelectedIndex(selectedIndex);
        }
        combobox.setToolTipText(tooltipText);
        ComponentFactory.setComponentSize(combobox, width, height);
        return combobox;
    }

    public static JComboBox createCombobox(JComboBox combobox, ArrayList<String> items, ItemListener listener, int selectedIndex, int width, int height) {
        if (combobox.getItemCount() == 0) {
            for (String item : items) {
                combobox.addItem(item);
            }
            combobox.setSelectedIndex(selectedIndex);
            combobox.addItemListener(listener);
        } else {
            combobox.setSelectedIndex(selectedIndex);
        }
        ComponentFactory.setComponentSize(combobox, width, height);
        return combobox;
    }

    private static void setIconForButton(JButton button, String pathToSkin) {
        if (Class.class.getClass().getResource(pathToSkin) == null) {
            System.out.println("Could not find skin to render: " + pathToSkin);
            return;
        }
        button.setIcon(new ImageIcon(Class.class.getClass().getResource(pathToSkin)));
    }

    public static void setCheckBoxIcon(JButton button, boolean state) {
        if (state) {
            button.setIcon(new ImageIcon(Class.class.getClass().getResource(IconFactory.getServerIconPath("checkboxEnabled.png"))));
        } else {
            button.setIcon(new ImageIcon(Class.class.getClass().getResource(IconFactory.getServerIconPath("checkboxDisabled.png"))));
        }
    }

    public static void setCheckBoxLockIcon(JButton button, boolean state) {
        if (state) {
            button.setIcon(new ImageIcon(Class.class.getClass().getResource(IconFactory.getServerIconPath("checkboxEnabled_lock.png"))));
        } else {
            button.setIcon(new ImageIcon(Class.class.getClass().getResource(IconFactory.getServerIconPath("checkboxDisabled_lock.png"))));
        }
    }

    public static JButton createButton(JButton button, String name, String icon, int width, int height) {
        if (!icon.equals("")) {
            ComponentFactory.setIconForButton(button, icon);
        }
        button.setText(name);
        button.setBackground(EduServerGui.EduSouthBGColor);
        ComponentFactory.setComponentSize(button, width, height);
        return button;
    }

    public static JButton createButton(JButton button, String name, String icon, int width, int height, Insets ins) {
        button = ComponentFactory.createButton(button, name, icon, width, height);
        button.setMargin(ins);
        return button;
    }

    public static JButton createButton(JButton button, String name, String icon, int width, int height, Insets ins, String tooltipText) {
        button = ComponentFactory.createButton(button, name, icon, width, height);
        button.setMargin(ins);
        button.setToolTipText(tooltipText);
        return button;
    }

    public static JButton createButton(JButton button, String name, String icon, int width, int height, String tooltipText) {
        button = ComponentFactory.createButton(button, name, icon, width, height);
        button.setToolTipText("<html>" + tooltipText);
        return button;
    }

    public static JButton createCheckButton(JButton button, String name, boolean state, int width, int height) {
        ComponentFactory.setCheckBoxIcon(button, state);
        button.setText(name);
        button.setBackground(EduServerGui.EduSouthBGColor);
        ComponentFactory.setComponentSize(button, width, height);
        return button;
    }

    public static JButton createCheckButton(JButton button, String name, boolean state, int width, int height, String tooltipText) {
        ComponentFactory.setCheckBoxIcon(button, state);
        button.setText(name);
        button.setBackground(EduServerGui.EduSouthBGColor);
        ComponentFactory.setComponentSize(button, width, height);
        button.setToolTipText("<html>" + tooltipText);
        return button;
    }

    public static JButton createCheckLockButton(JButton button, String name, boolean state, int width, int height, String tooltipText) {
        ComponentFactory.setCheckBoxLockIcon(button, state);
        button.setText(name);
        button.setBackground(EduServerGui.EduSouthBGColor);
        ComponentFactory.setComponentSize(button, width, height);
        button.setToolTipText("<html>" + tooltipText);
        return button;
    }

    public static void setComponentSize(JButton comp, int width, int height) {
        comp.setMinimumSize(new Dimension(width, height));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setMaximumSize(new Dimension(width, height));
        comp.setHorizontalAlignment(2);
    }

    public static void setComponentSize(JToggleButton comp, int width, int height) {
        comp.setMinimumSize(new Dimension(width, height));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setMaximumSize(new Dimension(width, height));
        comp.setHorizontalAlignment(2);
    }

    public static void setComponentSize(JTextField comp, int width, int height) {
        comp.setMinimumSize(new Dimension(width, height));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setMaximumSize(new Dimension(width, height));
    }

    public static void setComponentSize(JTextPane comp, int width, int height) {
        comp.setMinimumSize(new Dimension(width, height));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setMaximumSize(new Dimension(width, height));
        comp.setAlignmentX(0.0f);
    }

    public static void setComponentSize(JComboBox comp, int width, int height) {
        comp.setMinimumSize(new Dimension(width, height));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setMaximumSize(new Dimension(width, height));
        comp.setAlignmentX(0.0f);
    }
}

