/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mcedu.global.localization.Localization;
import mcedu.server.EduAssignment;
import mcedu.server.EduAssignmentHelper;

public class AssignmentTableModel
extends AbstractTableModel {
    private List<EduAssignment> assignments = new ArrayList<EduAssignment>();
    private List<String> columns = new ArrayList<String>();
    private String languageShortFormat = "en";

    public void setLanguageShortFormat(String langShortFormat) {
        this.languageShortFormat = langShortFormat;
    }

    public String getLanguageShortFormat() {
        return this.languageShortFormat;
    }

    public void addAssignment(EduAssignment assignment) {
        this.assignments.add(assignment);
        this.rowsInserted(1);
    }

    protected EduAssignment getAssignment(int rowIndex) {
        return this.assignments.get(rowIndex);
    }

    public int getAssignmentCount() {
        return this.assignments.size();
    }

    public List<EduAssignment> getAssignments() {
        return this.assignments;
    }

    public void removeAllAssignments() {
        if (this.assignments.isEmpty()) {
            return;
        }
        int size = this.assignments.size();
        this.assignments.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public void setColumns(ArrayList<String> newColumns) {
        this.clearContent();
        Iterator<String> i$ = newColumns.iterator();
        while (i$.hasNext()) {
            String column;
            String columnName = column = i$.next();
            this.columns.add(columnName);
        }
    }

    private void rowsInserted(int numRows) {
        this.fireTableRowsInserted(0, this.assignments.size() - numRows);
    }

    public void refreshTableStructure() {
        if (this.assignments.isEmpty()) {
            // empty if block
        }
        this.fireTableStructureChanged();
    }

    private void createEmptyTable() {
        if (!this.columns.isEmpty()) {
            this.columns.clear();
        }
        if (!this.assignments.isEmpty()) {
            this.assignments.clear();
        }
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(Localization.getS().tr("NoassignmentsFound"));
        this.setColumns(cols);
    }

    private void clearContent() {
        this.columns.clear();
        this.assignments.clear();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.assignments.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns.get(col);
    }

    private Object getAssignmentTitle(int row, int col) {
        return " " + this.assignments.get((int)row).title;
    }

    private Object getAssignmentCompleters(int row, int col) {
        String completeramount = EduAssignmentHelper.getCompleterAmount(this.assignments.get((int)row).id);
        String studentamount = EduAssignmentHelper.getStudentAmountOnServer();
        completeramount = completeramount + "/" + studentamount;
        return " " + completeramount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col >= this.columns.size()) {
            return "";
        }
        if (row > this.assignments.size()) {
            return "";
        }
        if (this.columns.get(col).equals(Localization.getS().tr("LEFT"))) {
            return this.getAssignmentTitle(row, col);
        }
        if (this.columns.get(col).equals(Localization.getS().tr("RIGHT"))) {
            return this.getAssignmentCompleters(row, col);
        }
        return "";
    }

    public void translateComponents() {
    }

    public Class getColumnClass(int c) {
        Class<?> returnVal = this.getValueAt(0, c).getClass();
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

