/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server.gui.servergui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import mcedu.server.EduAssignment;
import mcedu.server.EduAssignmentHelper;
import mcedu.server.gui.servergui.EduServerGui;
import mcedu.server.gui.servergui.components.AssignmentTableModel;

public class AssignmentJTable
extends JTable {
    public static final String TABLE_CLIENT_NAME = "jxtableLeft";
    public static final String TABLE_SERVER_NAME = "jxtableRight";
    public static final String TABLE_TRAFFIC_NAME = "trafficTable";
    private AssignmentTableModel datamodel = new AssignmentTableModel();
    private String tableName = "test";
    private EduServerGui serverGui;

    public AssignmentJTable(EduServerGui serverGui) {
        this.setModel(this.datamodel);
        this.serverGui = serverGui;
        this.setStylesForTable();
        this.setAdditionalTableFormatting();
        this.addActionListeners();
    }

    private void setAdditionalTableFormatting() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        UIManager.put("ToolTip.background", new Color(210, 230, 247));
    }

    public boolean setAssignmentSelected(String uniqueID) {
        try {
            List<EduAssignment> assignments = this.datamodel.getAssignments();
            for (int i = 0; i < assignments.size(); ++i) {
                if (assignments.get((int)i).id != Integer.valueOf(uniqueID)) continue;
                this.setRowSelectionInterval(i, i);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("Error selecting row: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public EduAssignment getSelectedAssignment() {
        try {
            return this.datamodel.getAssignment(this.convertRowIndexToModel(this.getSelectedRow()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean deleteAssignmentWithUniqueID(String uniqueID) {
        EduAssignment deletableMap = null;
        for (EduAssignment assignment : this.datamodel.getAssignments()) {
            if (assignment.id != Integer.valueOf(uniqueID)) continue;
            deletableMap = assignment;
        }
        if (deletableMap == null) {
            return false;
        }
        this.datamodel.getAssignments().remove(deletableMap);
        return true;
    }

    public EduAssignment getMapInTableRow(int row) {
        return this.datamodel.getAssignment(this.convertRowIndexToModel(row));
    }

    private void addActionListeners() {
    }

    public AssignmentTableModel getDataModel() {
        return this.datamodel;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        JComponent jc = (JComponent)c;
        jc.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(214, 217, 223)));
        jc.setForeground(Color.black);
        if (this.isRowSelected(rowIndex)) {
            c.setBackground(new Color(214, 217, 223));
            if (vColIndex == 0) {
                jc.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.BLACK), BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(214, 217, 223))));
            }
            if (vColIndex == 2) {
                jc.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, new Color(214, 217, 223)), BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(214, 217, 223))));
            }
        } else {
            c.setBackground(new Color(242, 242, 242));
        }
        return c;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return "<html>" + (String)this.getToolTipBasedOnColumn(this.rowAtPoint(event.getPoint()), this.columnAtPoint(event.getPoint()));
    }

    public Object getToolTipBasedOnColumn(int row, int column) {
        Object value = new Object();
        value = column == 1 ? de.a().a("AssignmentJTable.Completers:") + this.datamodel.getAssignment(row).getCompletersAsString() : this.datamodel.getAssignment((int)row).description;
        return value;
    }

    @Override
    public Point getToolTipLocation(MouseEvent arg0) {
        Rectangle r2 = this.getCellRect(this.rowAtPoint(arg0.getPoint()), this.columnAtPoint(arg0.getPoint()), true);
        return new Point(this.getWidth(), r2.y);
    }

    private void setStylesForTable() {
        this.setRowHeight(this.getRowHeight() + 15);
        this.setFont(new Font("Arial", 0, 14));
        this.setFillsViewportHeight(true);
        this.setBackground(Color.white);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        if (e.getSource() == this.getSelectionModel() && this.getRowSelectionAllowed()) {
            try {
                EduAssignmentHelper.selectedAssignment = this.datamodel.getAssignment(this.convertRowIndexToModel(this.getSelectedRow()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (EduAssignmentHelper.selectedAssignment != null) {
            this.serverGui.EduCommandsAssignmentModifyAssignmentButton.setEnabled(true);
            this.serverGui.EduCommandsAssignmentRemoveAssignmentButton.setEnabled(true);
        }
    }
}

