/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import java.util.ArrayList;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.forgemod.network.EduTextureMessage;
import mcedu.global.tools.Datahandler;

public class EduThreadSendTexturesToClient
extends Thread {
    private mw player;
    private File texturesFileLocation;
    private boolean waitBeforeSending;
    private long waitTime = 1500L;

    public EduThreadSendTexturesToClient(mw player, File texturesFileLocation, boolean waitBeforeSending) {
        this.player = player;
        this.texturesFileLocation = texturesFileLocation;
        this.setPriority(1);
        this.waitBeforeSending = waitBeforeSending;
        this.start();
    }

    @Override
    public void run() {
        block8: {
            try {
                nh netserverhandler = this.player.a;
                if (!this.texturesFileLocation.exists() || Datahandler.getBytesFromFile(this.texturesFileLocation) == null) break block8;
                if (this.waitBeforeSending) {
                    try {
                        Thread.sleep(this.waitTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                EduTextureMessage message = new EduTextureMessage("MCEDU|textures start", null);
                EduNetworkUtils.sendToPlayer(message, this.player);
                ArrayList<byte[]> terrainBytes = this.divideByteArray(Datahandler.getBytesFromFile(this.texturesFileLocation), 28000);
                for (int i = 0; i < terrainBytes.size(); ++i) {
                    message = new EduTextureMessage("MCEDU|textures data", terrainBytes.get(i));
                    EduNetworkUtils.sendToPlayer(message, this.player);
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                message = new EduTextureMessage("MCEDU|textures end", null);
                EduNetworkUtils.sendToPlayer(message, this.player);
            }
            catch (Exception e) {
                System.out.println("Error sending texturepack for client: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private ArrayList<byte[]> divideByteArray(byte[] byteArray, int splitSize) {
        ArrayList<byte[]> returnArray = new ArrayList<byte[]>();
        ArrayList<Byte> loopArray = new ArrayList<Byte>();
        for (int i = 0; i < byteArray.length; ++i) {
            if (i % splitSize == 0 && i != 0) {
                byte[] newBytes = new byte[loopArray.size()];
                for (int k2 = 0; k2 < loopArray.size(); ++k2) {
                    newBytes[k2] = (Byte)loopArray.get(k2);
                }
                returnArray.add(newBytes);
                loopArray.clear();
            }
            loopArray.add(byteArray[i]);
        }
        byte[] newBytes = new byte[loopArray.size()];
        for (int k3 = 0; k3 < loopArray.size(); ++k3) {
            newBytes[k3] = (Byte)loopArray.get(k3);
        }
        returnArray.add(newBytes);
        loopArray.clear();
        return returnArray;
    }
}

