/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import mcedu.EduAccessHelperServer;
import mcedu.global.localization.Localization;
import mcedu.server.EduAssignmentHelper;
import mcedu.server.EduLogActionHandler;
import mcedu.server.EduServerSettings;
import mcedu.server.EduServerSignHelper;
import mcedu.server.EduServerStatusHelper;
import net.minecraft.server.MinecraftServer;

public class EduServerThread
extends Thread {
    private static long waitTime = 5000L;
    private int counter = 0;
    MinecraftServer server;

    public EduServerThread() {
        this.setPriority(1);
        this.server = MinecraftServer.I();
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(waitTime);
                    ++this.counter;
                    EduServerStatusHelper.updateStatus();
                    if (this.counter % 4 == 0) {
                        EduServerThread.excecuteAllDataCommands();
                    }
                    if (this.counter % 12 == 0) {
                        this.handleIdlePlayers();
                    }
                    if (this.counter <= 1000) continue;
                    this.counter = 0;
                }
            }
            catch (Exception e) {
                System.out.println("Exception running EDU Thread: " + e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleIdlePlayers() {
        for (mw entity : this.server.ah().e) {
            entity.playerabilities.updateIdleState(entity.s, entity.t, entity.u, entity.z, entity.y, entity.username);
            if (entity.playerabilities.getIdleCount() < EduServerSettings.getS().settingsServerHandler.getSettingKickIdlePlayersInterval()) continue;
            boolean playerWasIdle = false;
            playerWasIdle = entity.playerabilities.isIdle;
            entity.playerabilities.isIdle = true;
            boolean isOp = EduAccessHelperServer.isPlayerOp(entity.username);
            if (EduServerSettings.getS().settingsServerHandler.getSettingKickIdlePlayers()) {
                if (!isOp) {
                    entity.a.c(Localization.getS().tr("EduserverThread.KickedForIdling"));
                    this.server.e("Idle player kicked from the server: " + entity.username + " (student)");
                    continue;
                }
                if (!isOp || !EduServerSettings.getS().settingsServerHandler.getSettingKickIdleOps()) continue;
                entity.a.c(Localization.getS().tr("EduserverThread.KickedForIdling"));
                this.server.e("Idle player kicked from the server: " + entity.username + " (teacher)");
                continue;
            }
            if (playerWasIdle || !EduServerSettings.getS().settingsServerHandler.getSettingLogIdlePlayers()) continue;
            if (isOp) {
                this.server.e("Idle player detected in the server: " + entity.username + " (teacher)");
                continue;
            }
            this.server.e("Idle player detected in the server: " + entity.username + " (student)");
        }
    }

    private static void saveSignDataToFile() {
        EduServerSignHelper.saveSignDataToFile();
    }

    private static void pushLogActionsToFile() {
        EduLogActionHandler.getS().pushChangesToFile();
    }

    private static void saveAssignmentDataTofile() {
        EduAssignmentHelper.saveAssignmentDataToFile();
    }

    public static void excecuteAllDataCommands() {
        EduServerThread.saveSignDataToFile();
        EduServerThread.pushLogActionsToFile();
        EduServerThread.saveAssignmentDataTofile();
    }
}

