/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import java.util.HashMap;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduServerSettings;

public class EduServerSignHelper {
    private static HashMap<String, String> eduSignData = new HashMap();

    public static void loadSignDataToMap() {
        File file = new File(EduServerSettings.getS().pathMapSignLocationsFile);
        if (!file.exists()) {
            Datahandler.createFile(EduServerSettings.getS().pathMapSignLocationsFile);
        }
        eduSignData = (HashMap)Datahandler.loadDataInMapFromFile(EduServerSettings.getS().pathMapSignLocationsFile, "=", "UTF-8");
    }

    public static boolean containsLocation(int x, int y2, int z2) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_";
        for (int i = 0; i < 4; ++i) {
            if (!eduSignData.containsKey(location + i)) continue;
            return true;
        }
        return false;
    }

    public static void removeSign(int x, int y2, int z2) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_";
        for (int i = 0; i < 4; ++i) {
            eduSignData.remove(location + i);
        }
        eduSignData.remove(location + "b");
    }

    public static void saveSignDataToFile() {
        Datahandler.writeMapToFile(EduServerSettings.getS().pathMapSignLocationsFile, eduSignData, "=", "UTF-8");
    }

    public static void saveSignData(int x, int y2, int z2, String[] data) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_";
        for (int i = 0; i < 4; ++i) {
            eduSignData.put(location + i, data[i]);
        }
    }

    public static boolean getSignSize(int x, int y2, int z2) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_b";
        if (!eduSignData.containsKey(location)) {
            EduServerSignHelper.saveSignSize(x, y2, z2, false);
            return false;
        }
        return eduSignData.get(location).equals("true");
    }

    public static void saveSignSize(int x, int y2, int z2, boolean bigSign) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_b";
        String bigSignString = bigSign ? "true" : "false";
        eduSignData.put(location, bigSignString);
    }

    public static String[] getSignData(int x, int y2, int z2) {
        String location = Integer.toString(x) + "." + Integer.toString(y2) + "." + Integer.toString(z2) + "_";
        String[] data = new String[4];
        for (int i = 0; i < 4; ++i) {
            data[i] = !eduSignData.containsKey(location + i) ? "" : eduSignData.get(location + i);
        }
        return data;
    }
}

