/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.awt.Point;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import mcedu.global.Application;
import mcedu.global.Version;
import mcedu.global.localization.Localization;
import mcedu.global.sharedcode.settinghandlers.ServerWizardSettingsHandler;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduMapSettingsHandler;
import mcedu.server.EduMessageHandler;
import mcedu.server.EduServerFunctions;
import mcedu.server.EduServerPaths;
import mcedu.server.EduServerPropertiesHandler;
import mcedu.server.EduWorldEditSettingsHandler;

public class EduServerSettings
extends EduServerPaths {
    public String versionText;
    public int maxPlayers = 10;
    public boolean noGui = false;
    public String world_type = "";
    public ArrayList<String> freezedStudentList = new ArrayList();
    public ArrayList<String> mutedStudentList = new ArrayList();
    public ArrayList<String> studentsInBuildMode = new ArrayList();
    public static EduMessageHandler edumsghandler;
    public boolean debugWindowSize = false;
    public Point debugWindowPointPos = new Point(800, 480);
    public boolean debugPackets = false;
    public boolean worldEditFound = false;
    public boolean isCCEduInstalled;
    public EduMapSettingsHandler settingsWorldHandler;
    public ServerWizardSettingsHandler settingsServerHandler;
    public EduWorldEditSettingsHandler settingsWorldEditHandler;
    public EduServerPropertiesHandler settingsServerProperties;
    private static EduServerSettings singleton;

    private EduServerSettings() {
        String mapName = Datahandler.iniGet("../worlds/tmpworld/EduMapInfo.ini", "name_" + Localization.getS().getCurrentLanguage().getLangShort());
        String description = Datahandler.iniGet("../worlds/tmpworld/EduMapInfo.ini", "description_" + Localization.getS().getCurrentLanguage().getLangShort());
        this.initPaths(Localization.getS().getCurrentLanguage().getLangShort(), true, "tmpworld");
        if (this.settingsWorldHandler == null) {
            this.settingsWorldHandler = new EduMapSettingsHandler(new File(this.pathMapEduSettings), "false");
        }
        if (this.settingsServerHandler == null) {
            this.settingsServerHandler = new ServerWizardSettingsHandler(new File(this.pathServerWizardFile), "false");
        }
        if (this.settingsWorldEditHandler == null) {
            this.settingsWorldEditHandler = new EduWorldEditSettingsHandler(new File(this.pathWorldEditFile), "");
        }
        if (this.settingsServerProperties == null) {
            this.settingsServerProperties = new EduServerPropertiesHandler(new File(this.pathServerProperties), "true");
        }
        if (this.settingsServerHandler.getSettingOverridedSavedWorldsFolder() != null && !this.settingsServerHandler.getSettingOverridedSavedWorldsFolder().isEmpty() && new File(this.settingsServerHandler.getSettingOverridedSavedWorldsFolder()).exists() && new File(this.settingsServerHandler.getSettingOverridedSavedWorldsFolder()).isDirectory()) {
            this.pathSavedMaps = this.settingsServerHandler.getSettingOverridedSavedWorldsFolder();
        }
        if (this.settingsServerHandler.getWriteDebugLogToFile()) {
            this.initFileDebugWriting();
        }
        this.settingsWorldEditHandler.loadSettings();
        this.settingsServerProperties.loadSettings();
        this.settingsServerHandler.loadSettings();
        if (Version.getEduVersion() == 0) {
            this.maxPlayers = 3;
            this.versionText = "Free version";
        } else if (Version.getEduVersion() == 1) {
            this.maxPlayers = 10;
            this.versionText = "Premium version";
        } else {
            this.maxPlayers = 999;
            this.versionText = "Classroom";
        }
        String verCheck = Datahandler.iniGet(this.pathServerWizardFile, "version");
        if (verCheck == null || verCheck.equals("")) {
            Datahandler.iniSet(this.pathServerWizardFile, "version", Double.toString(Version.getVersion()));
            verCheck = Double.toString(Version.getVersion());
        }
        if (!Double.toString(Version.getVersion()).equals(verCheck)) {
            Datahandler.iniSet(this.pathServerWizardFile, "version", Double.toString(Version.getVersion()));
        }
    }

    public String getTitleText() {
        return Application.getUnTranslatedApplicationTitle();
    }

    private void initFileDebugWriting() {
        try {
            HashMap<String, String> paths = new HashMap<String, String>();
            Field[] field = this.getClass().getSuperclass().getDeclaredFields();
            for (int i = 0; i < field.length; ++i) {
                if (!field[i].getName().toString().startsWith("path")) continue;
                paths.put(field[i].getName().toString(), (String)field[i].get(this));
            }
            EduServerFunctions.enableDebugFileWriting(new File(this.pathDebugWritingFile), paths);
        }
        catch (Exception e) {
            System.out.println("Could not initialize debug writing: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadExternalJarClasses() {
        String overrideClassPath = Datahandler.iniGet(this.pathServerWizardFile, "external_lib_path");
        if (overrideClassPath == null || overrideClassPath.trim().equals("")) {
            overrideClassPath = this.pathExternalLibraries;
        }
        HashMap<File, String> loadableJarClasses = new HashMap<File, String>();
        EduServerFunctions.loadExternalClassesToClasspath(loadableJarClasses);
    }

    public static EduServerSettings getS() {
        if (singleton == null) {
            singleton = new EduServerSettings();
        }
        return singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

