/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import java.util.HashMap;
import mcedu.global.tools.AbstractSettingsHandler;

public class EduServerPropertiesHandler
extends AbstractSettingsHandler {
    public EduServerPropertiesHandler(File pathToSettingsFile, String missingSettingDefaultValue) {
        super(pathToSettingsFile, missingSettingDefaultValue);
    }

    @Override
    public HashMap<String, String> getDefaultSettings() {
        HashMap<String, String> defaultSettings = new HashMap<String, String>();
        defaultSettings.put("online-mode", "false");
        defaultSettings.put("difficulty", "0");
        defaultSettings.put("generator-settings", "");
        defaultSettings.put("level-type", "DEFAULT");
        defaultSettings.put("enable-command-block", "true");
        return defaultSettings;
    }

    public String getGeneratorSettings() {
        return this.getValueForSetting("generator-settings");
    }

    public String getSettingLevelType() {
        return this.getValueForSetting("level-type");
    }

    public boolean getSettingOnlineMode() {
        return this.getValueForSetting("online-mode").equals("true");
    }

    public int getSettingDifficulty() {
        int difficulty = 0;
        try {
            difficulty = Integer.parseInt(this.getValueForSetting("difficulty"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return difficulty;
    }

    public void setSettingOnlineMode(boolean state) {
        this.saveSetting("online-mode", Boolean.toString(state).toLowerCase());
    }

    public void setSettingDifficulty(int difficulty) {
        this.saveSetting("difficulty", Integer.toString(difficulty));
    }
}

