/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import mcedu.RuntimeSettings;
import mcedu.global.localization.Localization;
import mcedu.global.localization.tools.Language;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.MessageBox;

public abstract class EduServerPaths {
    private String lang;
    public String pathEduMainDirectory;
    public String pathServerWizardFile;
    public String pathMapEduSettingsFile;
    public String pathSavedMaps;
    public String pathTmpWorld;
    public String pathMapEduSettings;
    public String pathTmpWorldEduSettingsFolder;
    public String pathMapNoteLocationsFile;
    public String pathMapNoteSettingsFile;
    public String pathMapHomeBlockDataFile;
    public String pathMapSignLocationsFile;
    public String pathMapGeneralTeleportLocationsFile;
    public String pathMapTeleportLocationsFile;
    public String pathMapAllowedTeleports;
    public String pathTipFile;
    public String pathBannedCommandsFile;
    public String pathAllowedStudentCommandsFile;
    public String pathMapTexturesFile;
    public String pathServerProperties;
    public String pathWorldEditFile;
    public String pathCurrentDir;
    public String pathTeleportSettings;
    public String pathExternalLibraries = "./lib/";
    public String pathDebugWritingFile;
    public String pathMapInfoFile;
    public String pathIgnoredServerMods;
    public String pathAssignmentData;
    public String pathMapQuestionLocationsFile;
    public String pathQuizzesDatabase;
    public String pathMapLogFile;
    public String pathReservedAliases;
    public String pathHomeLocations;
    public String fileServerToolJar;

    public void initPaths(String lang, boolean isMultiplayer, String worldFolderName) {
        this.lang = lang;
        String basePath = "../";
        basePath = RuntimeSettings.isMP() ? "../" : "./";
        this.pathMapEduSettingsFile = "EduWorldSettings.ini";
        this.pathEduMainDirectory = basePath + (isMultiplayer ? "worlds/" : "saves/");
        this.pathServerWizardFile = basePath + "settings/serverwizardsettings.ini";
        this.pathReservedAliases = basePath + "settings/reserved_aliases.ini";
        this.pathHomeLocations = basePath + "settings/home_locations.ini";
        this.pathWorldEditFile = basePath + "server/config/worldedit/worldedit.properties";
        this.pathTmpWorld = this.pathEduMainDirectory + worldFolderName;
        this.pathSavedMaps = this.pathEduMainDirectory + "savedworlds";
        this.pathMapEduSettings = this.pathTmpWorld + "/" + this.pathMapEduSettingsFile;
        this.pathMapInfoFile = this.pathTmpWorld + "/" + "EduMapInfo.ini";
        this.pathBannedCommandsFile = basePath + "settings/bannedservercommands.txt";
        this.pathAllowedStudentCommandsFile = basePath + "settings/allowedstudentcommands.txt";
        this.pathTmpWorldEduSettingsFolder = this.pathTmpWorld + "/MCEdu/";
        this.pathMapTexturesFile = this.pathTmpWorldEduSettingsFolder + "resourcepack.zip";
        this.pathMapNoteLocationsFile = this.pathTmpWorldEduSettingsFolder + "infoLocations_en.ini";
        this.pathMapSignLocationsFile = this.pathTmpWorldEduSettingsFolder + "signLocations_en.ini";
        this.pathMapNoteSettingsFile = this.pathTmpWorldEduSettingsFolder + "infoSettings.ini";
        this.pathHomeLocations = this.pathTmpWorldEduSettingsFolder + "home_locations.ini";
        this.pathDebugWritingFile = basePath + "../debug/server.log";
        this.pathIgnoredServerMods = "../../launcher_res/settings/ignoredservermods.ini";
        this.pathMapLogFile = this.pathTmpWorldEduSettingsFolder + "log.csv";
        this.pathTipFile = this.pathTmpWorldEduSettingsFolder + "tips_en.txt";
        this.pathMapTeleportLocationsFile = this.pathTmpWorldEduSettingsFolder + "teleportlocations_en.ini";
        this.pathMapGeneralTeleportLocationsFile = this.pathTmpWorldEduSettingsFolder + "teleportlocations.ini";
        this.pathMapAllowedTeleports = this.pathTmpWorldEduSettingsFolder + "allowedteleports.ini";
        this.pathTeleportSettings = this.pathTmpWorldEduSettingsFolder + "teleportsettings.ini";
        this.pathAssignmentData = this.pathTmpWorldEduSettingsFolder + "assignmentdata.ini";
        this.pathServerProperties = "server.properties";
        this.fileServerToolJar = "ServerWizard.jar";
        try {
            this.pathCurrentDir = new File(".").getCanonicalPath() + "/";
        }
        catch (Exception e) {
            System.out.println("Error getting path to current directory: " + e);
        }
        this.createRequiredFiles();
        this.setupTranslations();
    }

    private void createRequiredFiles() {
        Datahandler.createFile(this.pathTeleportSettings);
        Datahandler.createFile(this.pathMapAllowedTeleports);
        Datahandler.createFile(this.pathMapGeneralTeleportLocationsFile);
        Datahandler.createFile(this.pathMapTeleportLocationsFile);
        Datahandler.createFile(this.pathTipFile);
        Datahandler.createFile(this.pathMapLogFile);
        Datahandler.createFile(this.pathMapNoteSettingsFile);
        Datahandler.createFile(this.pathMapNoteLocationsFile);
        Datahandler.createFile(this.pathMapSignLocationsFile);
        Datahandler.createFile(this.pathBannedCommandsFile);
        Datahandler.createFile(this.pathAllowedStudentCommandsFile);
        Datahandler.createFile(this.pathReservedAliases);
        Datahandler.createFile(this.pathAssignmentData);
        Datahandler.createFile(this.pathHomeLocations);
        Datahandler.createFile(this.pathMapInfoFile);
    }

    private void setupTranslations() {
        try {
            File[] files = new File(this.pathTmpWorldEduSettingsFolder).listFiles();
            if (files == null) {
                return;
            }
            File signLocations = new File(this.pathTmpWorldEduSettingsFolder + "signLocations_" + this.lang + ".ini");
            File infoLocations = new File(this.pathTmpWorldEduSettingsFolder + "infoLocations_" + this.lang + ".ini");
            File teleportLocations = new File(this.pathTmpWorldEduSettingsFolder + "teleportlocations_" + this.lang + ".ini");
            File tips = new File(this.pathTmpWorldEduSettingsFolder + "tips_" + this.lang + ".txt");
            boolean signLocationsFound = false;
            boolean infoLocationsFound = false;
            boolean teleportLocationsFound = false;
            boolean tipsFound = false;
            for (File file : files) {
                if (file.equals(signLocations)) {
                    signLocationsFound = true;
                }
                if (file.equals(infoLocations)) {
                    infoLocationsFound = true;
                }
                if (file.equals(teleportLocations)) {
                    teleportLocationsFound = true;
                }
                if (!file.equals(tips)) continue;
                tipsFound = true;
            }
            if (signLocationsFound || infoLocationsFound || teleportLocationsFound || tipsFound) {
                Language language = Localization.getS().getLanguage(this.lang);
                int response = MessageBox.confirmDialog("EduServerPaths.worldLanguage", "EduServerPaths.worldTranslatedToYourLanguage", "EduServerPaths.keepUsingEnglish", Localization.getS().tr("EduServerPaths.changeTo") + " " + language.getLangName() + " (" + language.getCountryShort() + ")");
                if (response == 1) {
                    File signLocationsEng = new File(this.pathMapSignLocationsFile);
                    File infoLocationsEng = new File(this.pathMapNoteLocationsFile);
                    File teleportLocationsEng = new File(this.pathMapTeleportLocationsFile);
                    File tipsEng = new File(this.pathTipFile);
                    this.pathMapNoteLocationsFile = this.pathTmpWorldEduSettingsFolder + "infoLocations_" + this.lang + ".ini";
                    this.pathMapSignLocationsFile = this.pathTmpWorldEduSettingsFolder + "signLocations_" + this.lang + ".ini";
                    this.pathTipFile = this.pathTmpWorldEduSettingsFolder + "tips_" + this.lang + ".txt";
                    this.pathMapTeleportLocationsFile = this.pathTmpWorldEduSettingsFolder + "teleportlocations_" + this.lang + ".ini";
                    if (!signLocations.exists()) {
                        Datahandler.copyfile(signLocationsEng.getAbsolutePath(), this.pathMapSignLocationsFile);
                    }
                    if (!infoLocations.exists()) {
                        Datahandler.copyfile(infoLocationsEng.getAbsolutePath(), this.pathMapNoteLocationsFile);
                    }
                    if (!teleportLocations.exists()) {
                        Datahandler.copyfile(teleportLocationsEng.getAbsolutePath(), this.pathMapTeleportLocationsFile);
                    }
                    if (!tips.exists()) {
                        Datahandler.copyfile(tipsEng.getAbsolutePath(), this.pathTipFile);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPathToCurrentWorld(String path) {
    }
}

