/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import dan200.computercraftedu.api.ComputerCraftEduAPI;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.LogRecord;
import javax.swing.JOptionPane;
import mcedu.Debug;
import mcedu.EduAccessHelperServer;
import mcedu.RuntimeSettings;
import mcedu.blocks.EduBlockContainer;
import mcedu.blocks.EduBlockDialogMessage;
import mcedu.blocks.EduBlockHome;
import mcedu.blocks.EduBlockTeleport;
import mcedu.blocks.EduBlocks;
import mcedu.common.EduEnums;
import mcedu.common.EduLoginData;
import mcedu.common.ServerResourcePackHandler;
import mcedu.converter.converter.Converter;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.forgemod.network.EduServerStatesMessage;
import mcedu.global.Version;
import mcedu.global.localization.Localization;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.MessageBox;
import mcedu.server.EduAssignmentHelper;
import mcedu.server.EduCmdAssignments;
import mcedu.server.EduCmdBuild;
import mcedu.server.EduCmdCCEdu;
import mcedu.server.EduCmdDialogBlock;
import mcedu.server.EduCmdGeneral;
import mcedu.server.EduCmdTeleport;
import mcedu.server.EduCmdTeleportBlock;
import mcedu.server.EduCmdUser;
import mcedu.server.EduLogActionHandler;
import mcedu.server.EduLogActionType;
import mcedu.server.EduMessageHandler;
import mcedu.server.EduPlayerAbilities;
import mcedu.server.EduServerFunctions;
import mcedu.server.EduServerSettings;
import mcedu.server.EduServerSignHelper;
import mcedu.server.EduServerStatusHelper;
import mcedu.server.EduServerTemp;
import mcedu.server.EduServerThread;
import mcedu.server.gui.servergui.EduServerGui;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EduServerHooks {
    private MinecraftServer mcServer;
    private static EduServerHooks singleton;

    private EduServerHooks() {
    }

    public void init(MinecraftServer mcServer, String[] args) {
        this.mcServer = mcServer;
        for (String string : args) {
            if (string.contains("WORLD_TYPE_NEW")) {
                EduServerSettings.getS().world_type = "WORLD_TYPE_NEW";
                continue;
            }
            if (string.contains("WORLD_TYPE_SAVED")) {
                EduServerSettings.getS().world_type = "WORLD_TYPE_SAVED";
                String worldSaveName = EduServerSettings.getS().settingsServerHandler.getSettingSavedMapName();
                EduServerGui.worldSaveName = worldSaveName == null ? "" : worldSaveName;
                continue;
            }
            if (string.contains("WORLD_TYPE_TEMPLATE")) {
                EduServerSettings.getS().world_type = "WORLD_TYPE_TEMPLATE";
                continue;
            }
            if (string.contains("WORLD_TYPE_TUTORIAL")) {
                EduServerSettings.getS().world_type = "WORLD_TYPE_TUTORIAL";
                continue;
            }
            if (string.contains("WORLD_TYPE_LASTPLAYED")) {
                EduServerSettings.getS().world_type = "WORLD_TYPE_LASTPLAYED";
                continue;
            }
            if (!string.contains("nogui")) continue;
            EduServerSettings.getS().noGui = true;
        }
        RuntimeSettings.setIsMP(true);
    }

    public boolean minecraftserver_preLoadAllWorlds() {
        if (!new File(EduServerSettings.getS().pathMapEduSettings).exists()) {
            return false;
        }
        String converted = Datahandler.iniGet(EduServerSettings.getS().pathMapEduSettings, "edu-world-format");
        if (converted != null && converted.equals("0.2")) {
            return false;
        }
        try {
            Datahandler.copyFolder(EduServerSettings.getS().pathTmpWorld + "/region", EduServerSettings.getS().pathTmpWorld + "/region_eduf1_backup");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            int result = JOptionPane.showConfirmDialog(null, "This World was created with an outdated version of Minecraft and must be converted.\nIt will no longer be playable with older versions. Do you want to proceed?", "Notice", 0);
            if (result != 0) {
                this.mcServer.r();
            }
            JOptionPane.showMessageDialog(null, "Converting can take several minutes depending on the size of the World. \nYou will be notified when the conversion is complete. Click OK to begin", "Notice", -1);
        }
        catch (HeadlessException e) {
            Debug.printDebug("No gui detected, converting world");
        }
        this.mcServer.e("Converting old edu format 1  to format 2...");
        EduServerStatusHelper.setStatus(0);
        EduServerStatusHelper.setCurrentTaskText(de.a().a("EduServerHooks.ConvertingWorld"));
        EduServerStatusHelper.manualFlag = true;
        File path = new File(EduServerSettings.getS().pathTmpWorld);
        Converter converter = new Converter(path);
        HashMap<Integer, Integer> blocks = new HashMap<Integer, Integer>();
        int j = 3720;
        for (int i = 137; i <= 146; ++i) {
            blocks.put(i, j++);
        }
        converter.convert(blocks);
        EduServerStatusHelper.setCurrentTaskText("");
        EduServerStatusHelper.manualFlag = false;
        EduServerStatusHelper.setStatus(2);
        try {
            JOptionPane.showMessageDialog(null, "Conversion complete.", "Notice", -1);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        this.mcServer.e("Conversion complete");
        Datahandler.iniSet(EduServerSettings.getS().pathMapEduSettings, "edu-world-format", "0.2");
        return false;
    }

    public boolean minecraftserver_postLoadAllWorlds() {
        String eduOldSpawnLocation = Datahandler.iniGet(EduServerSettings.getS().pathMapEduSettings, "spawn-location");
        try {
            if (eduOldSpawnLocation != null && !eduOldSpawnLocation.trim().equals("")) {
                String[] spLocSplit = eduOldSpawnLocation.split("\\.");
                this.mcServer.a(0).N().a(Integer.parseInt(spLocSplit[0]), Integer.parseInt(spLocSplit[1]) + 1, Integer.parseInt(spLocSplit[2]));
                Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathMapEduSettings, "spawn-location=");
                Debug.printDebug("Succesfully converted old edu spawn location from eduworldsettings file to Minecraft spawn location!");
                int newSpLocX = this.mcServer.a(0).N().c();
                int newSpLocY = this.mcServer.a(0).N().d();
                int newSpLocZ = this.mcServer.a(0).N().e();
                Debug.printDebug("Spawn locations are now: " + newSpLocX + "." + newSpLocY + "." + newSpLocZ);
            }
        }
        catch (Exception e) {
            Debug.printDebug("ERROR MOVING OLD EDU SPAWN LOCATION TO MC INTEGRATED FORMAT!");
            Debug.printDebug("SETTINGS FILE: " + EduServerSettings.getS().pathMapEduSettings);
            Debug.printDebug("SETTING spawn-location: " + eduOldSpawnLocation);
            e.printStackTrace();
        }
        Datahandler.iniSet(EduServerSettings.getS().pathMapEduSettings, "minecraft-version", MinecraftServer.I().B());
        Datahandler.iniSet(EduServerSettings.getS().pathMapEduSettings, "minecraftedu-version", Double.toString(Version.getVersion()));
        Datahandler.iniSet(EduServerSettings.getS().pathMapEduSettings, "minecraft-releasedate", Version.getReleaseDate());
        this.mcServer.e(de.a().a("EduServerHooks.forgeWasLoaded"));
        this.mcServer.e(de.a().a("EduServerHooks.forgeModloaderWasLoaded"));
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getName().equals("Minecraft Coder Pack") || mod.getName().equals("Forge Mod Loader") || mod.getName().equals("Minecraft Forge")) continue;
            this.mcServer.e(de.a().a("EduServerHooks.loadedForgeMod") + ": " + mod.getName());
        }
        this.mcServer.d().O().b("doDaylightCycle", String.valueOf(!EduServerSettings.getS().settingsWorldHandler.getWorldSpeedFast()));
        this.mcServer.eduSetCanSpawnAnimals(EduServerSettings.getS().settingsWorldHandler.getWorldAnimalsEnabled());
        this.mcServer.eduSetCanSpawnPeacefulmobsNPC(EduServerSettings.getS().settingsWorldHandler.getWorldAnimalsEnabled());
        if (ComputerCraftEduAPI.isInstalled()) {
            try {
                String version = ComputerCraftEduAPI.getInstalledVersion();
                if (version.contains("pr")) {
                    version = version.split("pr")[0];
                }
                if (!((double)Float.parseFloat(version) < 1.74)) {
                    EduServerSettings.getS().isCCEduInstalled = true;
                    ComputerCraftEduAPI.setTurtlesEnabled(EduServerSettings.getS().settingsWorldHandler.getCCEduEnabled());
                    ComputerCraftEduAPI.setVisualEditorEnabled(!EduServerSettings.getS().settingsWorldHandler.getForceCodeView());
                    ComputerCraftEduAPI.setSuggestionsEnabled(!EduServerSettings.getS().settingsWorldHandler.getDisableIDE());
                    ComputerCraftEduAPI.setTurtlesStopped(EduServerSettings.getS().settingsWorldHandler.getStopAllTurtles());
                    ComputerCraftEduAPI.setTurtlesCanBuild(EduServerSettings.getS().settingsWorldHandler.getTurtlesCanBuild());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!EduServerSettings.getS().noGui) {
                EduServerGui.getServerGUI.enableCCEdu(true);
            }
        } else if (!EduServerSettings.getS().noGui) {
            EduServerGui.getServerGUI.enableCCEdu(false);
        }
        return false;
    }

    public boolean minecraftserver_preServerStarted() {
        EduServerSettings.getS().settingsWorldHandler.loadSettings();
        EduServerSignHelper.loadSignDataToMap();
        EduAssignmentHelper.loadAssignmentData();
        EduAssignmentHelper.convertOldAssignment();
        EduServerFunctions.setTeacherPassword(true);
        return false;
    }

    public boolean minecraftserver_centerServerStopped() {
        EduServerThread.excecuteAllDataCommands();
        return false;
    }

    public boolean minecraftserver_postServerStartedBeforeLoadingWorld(lt server) {
        String eduMotd;
        EduServerSettings.edumsghandler = new EduMessageHandler((oi)server.aC());
        if (server.a("motd", "A Minecraft Server").equals("A Minecraft Server")) {
            server.n("MinecraftEdu Server");
        }
        if (!(eduMotd = EduServerSettings.getS().settingsWorldHandler.getMOTD()).isEmpty()) {
            server.n(eduMotd);
        }
        server.k(EduServerSettings.getS().pathTmpWorld);
        String overrideTmpWorld = Datahandler.iniGet(EduServerSettings.getS().pathServerWizardFile, "override-tmpworld");
        if (overrideTmpWorld != null && !overrideTmpWorld.trim().equals("")) {
            server.k(overrideTmpWorld);
        }
        EduEnums.MAP_HEIGHT = server.af();
        EduServerThread eduserverthread = new EduServerThread();
        return false;
    }

    public void setServerMOTD(lt server) {
        String eduMotd = EduServerSettings.getS().settingsWorldHandler.getMOTD();
        if (!eduMotd.isEmpty()) {
            server.n(eduMotd);
        }
    }

    public boolean serverconfigurationmanager_centerRespawnPlayer(mw respawnedPlayerEntity, mw oldPlayerEntity) {
        respawnedPlayerEntity.username = oldPlayerEntity.username;
        respawnedPlayerEntity.playerOriginalUsername = oldPlayerEntity.playerOriginalUsername;
        respawnedPlayerEntity.playerSkin = oldPlayerEntity.playerSkin;
        respawnedPlayerEntity.playerIsAdmin = oldPlayerEntity.playerIsAdmin;
        respawnedPlayerEntity.playerUseCustomSkinFromURL = oldPlayerEntity.playerUseCustomSkinFromURL;
        respawnedPlayerEntity.playerabilities = new EduPlayerAbilities(oldPlayerEntity.playerabilities.isFreezed, oldPlayerEntity.playerabilities.isMuted, oldPlayerEntity.playerabilities.isBuildModeAllowed, oldPlayerEntity.playerabilities.personalCreativeEnabled);
        return false;
    }

    public boolean netloginhandler_preHandleLogin(nn netloginhandler, GameProfile profile, EduLoginData edud) {
        if (edud.weirdClientLoginData) {
            netloginhandler.a("This is MinecraftEdu Server. Please connect with MinecraftEdu Client " + Version.getFormattedVersion() + " build " + Version.getBuildNumber() + ".");
            return true;
        }
        if (!edud.minecrafteduVersion.equals(Double.toString(Version.getVersion())) || !edud.minecrafteduBuild.equals(Integer.toString(Version.getBuildNumber()))) {
            netloginhandler.a("Wrong version. This server is using MinecraftEdu " + Version.getFormattedVersion() + " build " + Version.getBuildNumber() + ".");
            return true;
        }
        String serverPass = Datahandler.iniGet(EduServerSettings.getS().pathServerWizardFile, "password");
        if (serverPass == null) {
            serverPass = "";
        }
        if (edud.eduProtocolVersion != Version.getProtocolVersion()) {
            netloginhandler.a("Wrong version (" + edud.eduProtocolVersion + ")! Server is using " + Version.getFormattedVersion() + " (" + Version.getProtocolVersion() + ")");
            return true;
        }
        if (edud.playerAlias == null || edud.playerAlias.trim().equals("")) {
            netloginhandler.a("Alias name cannot be empty.");
            return true;
        }
        String[] playerlist = EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerAliasList();
        for (int i = 0; i < playerlist.length; ++i) {
            if (!playerlist[i].equalsIgnoreCase(edud.playerAlias)) continue;
            netloginhandler.a(de.a().a("netLoginHandler.nicknameTaken"));
            return true;
        }
        if (edud.isAdmin && !edud.encryptedServerPassword.equals(serverPass)) {
            netloginhandler.a("EduWrongTeacherPassword");
            return true;
        }
        if (EduServerSettings.getS().settingsServerHandler.getSettingAliasProtection()) {
            String aliasPassword = Datahandler.iniGet(EduServerSettings.getS().pathReservedAliases, edud.playerAlias.toLowerCase());
            if (aliasPassword == null) {
                aliasPassword = "";
            }
            if (EduServerSettings.getS().settingsServerHandler.getSettingRestrictNewUsersToJoin() && aliasPassword.isEmpty()) {
                netloginhandler.a(de.a().a("EduAliasProtectionNotInList"));
            }
            if (!(aliasPassword.isEmpty() || edud.encryptedAliasPassword.isEmpty() || edud.encryptedAliasPassword.equals(aliasPassword))) {
                netloginhandler.a(de.a().a("EduAliasProtectionPasswordIncorrect"));
            }
            if (!aliasPassword.isEmpty() && !edud.isAdmin && aliasPassword.equals("teacher")) {
                netloginhandler.a(de.a().a("EduAliasProtectionThisIsTeacherPassword"));
            }
            if (aliasPassword.isEmpty() && !edud.encryptedAliasPassword.isEmpty()) {
                Datahandler.iniSet(EduServerSettings.getS().pathReservedAliases, edud.playerAlias.toLowerCase(), edud.encryptedAliasPassword);
            } else if (!aliasPassword.isEmpty() || !edud.doNotPasswordProtectAlias) {
                if (aliasPassword.isEmpty()) {
                    netloginhandler.a(de.a().a("EduAliasProtectionPrompt"));
                } else if (edud.encryptedAliasPassword.isEmpty() && !edud.isAdmin) {
                    netloginhandler.a("EduAliasProtectionPromptPassword");
                }
            }
        }
        if (edud.isAdmin) {
            EduAccessHelperServer.addPlayerAsOp(profile);
        } else {
            EduAccessHelperServer.removePlayerFromOps(profile);
        }
        return false;
    }

    public boolean netloginhandler_preDoLoginCreateCharacter(mw entityplayermp, EduLoginData edulogindata) {
        entityplayermp.playerSkin = edulogindata.playerSkin;
        entityplayermp.playerIsAdmin = edulogindata.isAdmin;
        entityplayermp.playerUseCustomSkinFromURL = edulogindata.customSkinFromURL;
        entityplayermp.playerOriginalUsername = edulogindata.playerOriginalUsername;
        entityplayermp.username = edulogindata.playerAlias;
        return false;
    }

    public boolean netloginhandler_postDoLoginCreateCharacter(mw entityplayermp, nh netserverhandler) {
        ServerResourcePackHandler.sendCustomResourcePackToClient(entityplayermp, new File(EduServerSettings.getS().pathMapTexturesFile), true);
        EduNetworkUtils.sendToPlayer(new EduServerStatesMessage(true), entityplayermp);
        if (EduServerSettings.getS().settingsWorldHandler.getGameMode() == 1) {
            entityplayermp.eduGetItemInWorldManager().a(ahk.c);
            entityplayermp.a.a((ft)new gv(3, (float)ahk.c.a()));
        } else if (EduServerSettings.getS().settingsWorldHandler.getGameMode() == 0) {
            entityplayermp.eduGetItemInWorldManager().a(ahk.b);
            entityplayermp.a.a((ft)new gv(3, (float)ahk.b.a()));
        } else {
            entityplayermp.eduGetItemInWorldManager().a(ahk.EDU);
            entityplayermp.a.a((ft)new gv(3, (float)ahk.EDU.a()));
        }
        entityplayermp.sendEduServerMessage("clientLogin alias " + entityplayermp.getName());
        entityplayermp.sendEduServerMessage("clientLogin isAdmin " + EduAccessHelperServer.isPlayerOp(entityplayermp.getName()));
        entityplayermp.sendEduServerMessage("clientLogin serverLanguage " + Localization.getS().getCurrentLanguage().getLangShort());
        if (!EduAccessHelperServer.isPlayerOp(entityplayermp.getName())) {
            if (EduServerSettings.getS().freezedStudentList.contains(entityplayermp.getName()) || EduServerSettings.getS().settingsWorldHandler.getGameStudentsFreezed()) {
                entityplayermp.freezePlayer(true);
            }
            if (EduServerSettings.getS().mutedStudentList.contains(entityplayermp.getName())) {
                entityplayermp.mutePlayer(true);
            }
            if (EduServerSettings.getS().settingsWorldHandler.getGameStudentsCanFly()) {
                entityplayermp.bE.c = true;
                entityplayermp.q();
            }
        }
        entityplayermp.playerabilities.lastX = entityplayermp.s;
        entityplayermp.playerabilities.lastY = entityplayermp.t;
        entityplayermp.playerabilities.lastZ = entityplayermp.u;
        entityplayermp.playerabilities.lastPitch = entityplayermp.z;
        entityplayermp.playerabilities.lastYaw = entityplayermp.y;
        entityplayermp.playerabilities.timeStamp = System.currentTimeMillis();
        EduBlockHome.refreshHomeBlockLocationForPlayer(entityplayermp);
        if (entityplayermp.playerIsAdmin) {
            EduAssignmentHelper.removeUserFromAllAssignmentsCompleters(entityplayermp);
        }
        EduAssignmentHelper.refreshAssignmentForPlayer(entityplayermp);
        if (entityplayermp.playerIsAdmin) {
            EduAccessHelperServer.sendChatMessageToPlayer((yz)entityplayermp, "\u00a76" + de.a().a("EduHooks.welcomeTeacher"));
        } else {
            EduAccessHelperServer.sendChatMessageToPlayer((yz)entityplayermp, "\u00a76" + de.a().a("EduHooks.welcome"));
        }
        EduAccessHelperServer.sendChatMessageToPlayer((yz)entityplayermp, "\u00a76" + EduServerSettings.getS().settingsWorldHandler.getWelcomeMessage());
        this.setOtherPlayersSpectateMode((yz)entityplayermp);
        return false;
    }

    public void setOtherPlayersSpectateMode(yz entityplayer) {
        try {
            int i;
            String[] playerlist = EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerAliasList();
            ArrayList<mw> entityList = new ArrayList<mw>();
            for (i = 0; i < playerlist.length; ++i) {
                entityList.add(EduAccessHelperServer.getPlayerForUsername(playerlist[i]));
            }
            for (i = 0; i < entityList.size(); ++i) {
                if (!((mw)entityList.get((int)i)).playerabilities.spectate) continue;
                Debug.printDebug(((mw)entityList.get((int)i)).username + " is in spectate mode");
                EduServerFunctions.refreshPlayerVisibility((mw)entityList.get(i), ((mw)entityList.get((int)i)).b);
            }
        }
        catch (Exception e) {
            Debug.printDebug("Error setting other player's spectate mode");
            e.printStackTrace();
        }
    }

    public boolean netserverhandler_preHandleFlying(jd packet10flying, mw playerEntity, double lastPosX, double lastPosY, double lastPosZ) {
        double packetXCoordinatePrecise = packet10flying.c();
        double packetYCoordinatePrecise = packet10flying.d();
        double packetZCoordinatePrecise = packet10flying.e();
        mt worldserver = this.mcServer.getWorldManager(playerEntity.ap);
        if (packetXCoordinatePrecise != 0.0 && packetYCoordinatePrecise != 0.0 && packetZCoordinatePrecise != 0.0 || playerEntity.am()) {
            int xPosI = qh.c((double)packetXCoordinatePrecise);
            int zPosI = qh.c((double)packetZCoordinatePrecise);
            if (playerEntity.am() && playerEntity.m != null) {
                xPosI = qh.c((double)playerEntity.m.s);
                zPosI = qh.c((double)playerEntity.m.u);
            }
            for (int i = -64; i < EduEnums.MAP_HEIGHT; ++i) {
                if (!EduAccessHelperServer.isPlayerOp(playerEntity.getName()) && EduBlocks.areBlocksEqualByName(worldserver.a(xPosI, i, zPosI), EduBlocks.blockBorder)) {
                    EduAccessHelperServer.teleportPlayerInServer(playerEntity, lastPosX, lastPosY, lastPosZ, playerEntity.y, playerEntity.z);
                    EduAccessHelperServer.sendChatMessageToPlayer((yz)playerEntity, de.a().a("NetServerHandler.YouCantGoThere"));
                }
                if (EduBlocks.areBlocksEqualByName(worldserver.a(xPosI, i, zPosI), EduBlocks.blockDialogMessage) && (double)i < packetYCoordinatePrecise && packetYCoordinatePrecise - (double)i < 5.0) {
                    EduBlockDialogMessage.teleportPlayerToDirection(playerEntity, xPosI, i, zPosI);
                    if (EduBlockDialogMessage.getTeleportDistance(xPosI, i, zPosI) != 0) {
                        EduBlockDialogMessage.openDialogGUI(playerEntity, xPosI, i, zPosI);
                    }
                }
                if (!EduBlocks.areBlocksEqualByName(worldserver.a(xPosI, i, zPosI), EduBlocks.blockTeleport) || !((double)i < packetYCoordinatePrecise) || !(packetYCoordinatePrecise - (double)i < 5.0)) continue;
                String coordinates = Integer.toString(xPosI) + "." + Integer.toString(i) + "." + Integer.toString(zPosI);
                EduBlockTeleport.teleportPlayerIfOneAllowedLocation(playerEntity, coordinates, this.mcServer);
            }
        }
        return false;
    }

    public boolean netserverhandler_preHandleBlockDig(ji packet14blockdig, mw playerEntity) {
        return EduServerFunctions.checkIfCanDigHere(playerEntity, packet14blockdig.c(), packet14blockdig.d(), packet14blockdig.e());
    }

    public void nethandlerplayserver_handleBlockDig(MinecraftServer serverController, mw playerEntity, ji p_147345_1_) {
        mt worldserver = serverController.a(playerEntity.ap);
        playerEntity.v();
        int i = p_147345_1_.c();
        int j = p_147345_1_.d();
        int k2 = p_147345_1_.e();
        if (p_147345_1_.g() == 4) {
            playerEntity.a(false);
        } else if (p_147345_1_.g() == 3) {
            playerEntity.a(true);
        } else if (p_147345_1_.g() == 5) {
            playerEntity.bA();
        } else {
            boolean flag = false;
            if (!EduServerHooks.getS().netserverhandler_preHandleBlockDig(p_147345_1_, playerEntity)) {
                return;
            }
            int dim = playerEntity.ap;
            aji diggedBlock = EduAccessHelperServer.getServer().getWorldManager(dim).a(p_147345_1_.c(), p_147345_1_.d(), p_147345_1_.e());
            int diggedBlockMeta = EduAccessHelperServer.getServer().getWorldManager(dim).e(p_147345_1_.c(), p_147345_1_.d(), p_147345_1_.e());
            if (p_147345_1_.g() == 0) {
                flag = true;
            }
            if (p_147345_1_.g() == 1) {
                flag = true;
            }
            if (p_147345_1_.g() == 2) {
                flag = true;
            }
            if (flag) {
                double d0 = playerEntity.s - ((double)i + 0.5);
                double d1 = playerEntity.t - ((double)j + 0.5) + 1.5;
                double d2 = playerEntity.u - ((double)k2 + 0.5);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (j >= serverController.af()) {
                    return;
                }
            }
            if (p_147345_1_.g() == 0) {
                playerEntity.c.a(i, j, k2, p_147345_1_.f());
            } else if (p_147345_1_.g() == 2) {
                playerEntity.c.a(i, j, k2);
                if (worldserver.a(i, j, k2).o() != awt.a) {
                    playerEntity.a.a((ft)new gh(i, j, k2, (ahb)worldserver));
                }
            } else if (p_147345_1_.g() == 1) {
                playerEntity.c.c(i, j, k2);
                if (worldserver.a(i, j, k2).o() != awt.a) {
                    playerEntity.a.a((ft)new gh(i, j, k2, (ahb)worldserver));
                }
                EduLogActionHandler.getS().update(playerEntity.username, diggedBlock, i, j, k2, EduLogActionType.removed, 0);
            }
            if (RuntimeSettings.isMP() && EduServerHooks.getS().netserverhandler_postHandleBlockDig(p_147345_1_, playerEntity, diggedBlock, diggedBlockMeta)) {
                return;
            }
        }
    }

    public boolean netserverhandler_postHandleBlockDig(ji packet14blockdig, mw playerEntity, aji block, int origBlockMeta) {
        int i = packet14blockdig.c();
        int j = packet14blockdig.d();
        int k2 = packet14blockdig.e();
        int dim = playerEntity.ap;
        if (packet14blockdig.g() != 2 && !this.mcServer.getWorldManager(dim).c(i, j, k2)) {
            return false;
        }
        int[] plc = new int[]{i, j, k2};
        int[] plc2 = new int[3];
        plc = EduServerFunctions.determineFacingAndReturnCoordinateReversed(plc[0], plc[1], plc[2], packet14blockdig.f());
        EduBlockContainer nextStore = playerEntity.playerabilities.undoDigList.getNewUndoContainer();
        nextStore.addBlockToList(i, j, k2, block, origBlockMeta, dim);
        nextStore.addBlockToList(plc[0], plc[1], plc[2], this.mcServer.getWorldManager(dim).a(plc[0], plc[1], plc[2]), this.mcServer.getWorldManager(dim).e(plc[0], plc[1], plc[2]), dim);
        playerEntity.eduGetItemInWorldManager().a(i, j, k2);
        int amount = playerEntity.playerabilities.getDigBlocksAmount() - 1;
        plc[0] = i;
        plc[1] = j;
        plc[2] = k2;
        for (int gm = 0; gm < amount; ++gm) {
            plc = EduServerFunctions.determineFacingAndReturnCoordinateReversed(plc[0], plc[1], plc[2], packet14blockdig.f());
            plc2 = EduServerFunctions.determineFacingAndReturnCoordinateReversed(plc[0], plc[1], plc[2], packet14blockdig.f());
            nextStore.addBlockToList(plc2[0], plc2[1], plc2[2], this.mcServer.getWorldManager(dim).a(plc2[0], plc2[1], plc2[2]), this.mcServer.getWorldManager(dim).e(plc2[0], plc2[1], plc2[2]), dim);
            playerEntity.eduGetItemInWorldManager().EduSetRemoveBlock(plc[0], plc[1], plc[2]);
        }
        return false;
    }

    public boolean itemmonsterplacer_preOnItemUse(add par1ItemStack) {
        int placedID = par1ItemStack.k();
        if (!EduServerSettings.getS().settingsWorldHandler.getWorldAnimalsEnabled()) {
            for (int curAnimalID : EduEnums.ANIMALS) {
                if (curAnimalID != placedID) continue;
                return true;
            }
        }
        if (!EduServerSettings.getS().settingsWorldHandler.getWorldMonstersEnabled()) {
            for (int curMonsterID : EduEnums.MOBS) {
                if (curMonsterID != placedID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean entityminecart_preOnHit(ro damagesource, double x, double y2, double z2) {
        int xPos = qh.c((double)x);
        int yPos = qh.c((double)y2);
        int zPos = qh.c((double)z2);
        return damagesource.j() instanceof mw && EduServerFunctions.checkIfCanDigHere((mw)damagesource.j(), xPos, yPos, zPos);
    }

    public boolean entityhanging_preOnHit(ro damagesource, int x, int y2, int z2) {
        int xPos = x;
        int yPos = y2;
        int zPos = z2;
        if (damagesource.j() instanceof mw) {
            try {
                if (EduServerFunctions.checkIfCanDigHere((mw)damagesource.j(), xPos, yPos, zPos)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean entity_preHandleMount(mw player, sa entityToBeMounted) {
        if (player == null || entityToBeMounted == null || EduAccessHelperServer.isPlayerOp(player.getName())) {
            return true;
        }
        ahb world = player.o;
        return this.checkForBorderBlocksBetweenTwoPositions(world, player.s, player.t, player.u, entityToBeMounted.s, entityToBeMounted.t, entityToBeMounted.u);
    }

    public boolean preHandleEnderPearlTeleport(sv entity, EnderTeleportEvent event) {
        try {
            mw targetEntityPlayer = (mw)entity;
            if (EduAccessHelperServer.isPlayerOp(targetEntityPlayer.getName())) {
                return true;
            }
        }
        catch (Exception e) {
            Debug.printDebug("This should not be happening...");
        }
        return this.checkForBorderBlocksBetweenTwoPositions(entity.o, entity.s, entity.t, entity.u, event.targetX, event.targetY, event.targetZ);
    }

    public boolean checkForBorderBlocksBetweenTwoPositions(ahb world, double aPosX, double aPosY, double aPosZ, double bPosX, double bPosY, double bPosZ) {
        int o;
        int i;
        if (bPosX > aPosX) {
            for (i = (int)aPosX; i < (int)bPosX + 2; ++i) {
                for (o = -64; o < EduEnums.MAP_HEIGHT; ++o) {
                    if (!EduBlocks.areBlocksEqualByName(world.a(i, o, (int)aPosZ), EduBlocks.blockBorder)) continue;
                    return false;
                }
            }
        }
        if (bPosX < aPosX) {
            for (i = (int)aPosX; i > (int)bPosX - 2; --i) {
                for (o = -64; o < EduEnums.MAP_HEIGHT; ++o) {
                    if (!EduBlocks.areBlocksEqualByName(world.a(i, o, (int)aPosZ), EduBlocks.blockBorder)) continue;
                    return false;
                }
            }
        }
        if (bPosZ < aPosZ) {
            for (i = (int)aPosZ; i > (int)bPosZ - 2; --i) {
                for (o = -64; o < EduEnums.MAP_HEIGHT; ++o) {
                    if (!EduBlocks.areBlocksEqualByName(world.a((int)aPosX, o, i), EduBlocks.blockBorder)) continue;
                    return false;
                }
            }
        }
        if (bPosZ > aPosZ) {
            for (i = (int)aPosZ; i < (int)bPosZ + 2; ++i) {
                for (o = -64; o < EduEnums.MAP_HEIGHT; ++o) {
                    if (!EduBlocks.areBlocksEqualByName(world.a((int)aPosX, o, i), EduBlocks.blockBorder)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean MinecraftServer_runServerTick(mt normalDimension, long timeSinceLastTick) {
        if (this.mcServer.al() % 10050 > 0 && this.mcServer.al() % 10050 < 50 && !EduServerSettings.edumsghandler.longTimeTipDisplayed) {
            EduServerSettings.edumsghandler.sendTip();
            EduServerSettings.edumsghandler.longTimeTipDisplayed = true;
        }
        if (this.mcServer.al() % 10200 > 0 && this.mcServer.al() % 10200 < 50 && EduServerSettings.edumsghandler.longTimeTipDisplayed) {
            EduServerSettings.edumsghandler.longTimeTipDisplayed = false;
        }
        if (RuntimeSettings.isMP()) {
            if (timeSinceLastTick > 2000L) {
                EduServerStatusHelper.manualFlag = true;
                EduServerStatusHelper.setStatus(1);
            } else {
                EduServerStatusHelper.manualFlag = false;
            }
        }
        return false;
    }

    public boolean MinecraftServer_postShutdown() {
        if (EduServerTemp.getS().startServerToolAfterShutdown) {
            try {
                Datahandler.launchJarFile(new File(EduServerSettings.getS().pathCurrentDir).getParentFile(), EduServerSettings.getS().fileServerToolJar, "500", "500", null);
            }
            catch (Exception e) {
                MessageBox.error("Could not launch Servertool", "Could not launch Servertool.");
            }
        }
        return false;
    }

    public boolean CommandHandler_preExecuteCommand(ac par1ICommandSender, String par2Str) {
        if (EduServerFunctions.isCommandBanned(par2Str)) {
            EduAccessHelperServer.sendChatMessageToPlayer((yz)((mw)par1ICommandSender), "Server has banned this command: " + par2Str);
            return true;
        }
        return false;
    }

    public boolean ServerCommandManager_postRegisterCommands(bl commandManager) {
        commandManager.a((aa)new EduCmdBuild());
        commandManager.a((aa)new EduCmdDialogBlock());
        commandManager.a((aa)new EduCmdGeneral());
        commandManager.a((aa)new EduCmdTeleport());
        commandManager.a((aa)new EduCmdTeleportBlock());
        commandManager.a((aa)new EduCmdUser());
        commandManager.a((aa)new EduCmdAssignments());
        commandManager.a((aa)new EduCmdCCEdu());
        return false;
    }

    public boolean enumGameType_preConfigurePlayerCapabilitiesInGamemode(ahk enumgametype, yw par1PlayerCapabilities) {
        if (enumgametype == ahk.EDU) {
            par1PlayerCapabilities.c = false;
            par1PlayerCapabilities.d = false;
            par1PlayerCapabilities.a = true;
            if (!EduServerSettings.getS().settingsWorldHandler.getGameStudentsCanFly()) {
                par1PlayerCapabilities.b = false;
            }
            return true;
        }
        if (enumgametype == ahk.b || enumgametype == ahk.d) {
            if (!EduServerSettings.getS().settingsWorldHandler.getGameStudentsCanFly()) {
                par1PlayerCapabilities.c = false;
            }
            par1PlayerCapabilities.d = false;
            par1PlayerCapabilities.a = false;
            if (!EduServerSettings.getS().settingsWorldHandler.getGameStudentsCanFly()) {
                par1PlayerCapabilities.b = false;
            }
            return true;
        }
        return false;
    }

    public boolean handleTXTConversion() {
        try {
            File bannedIps = new File("banned-ips.txt");
            File bannedPlayers = new File("banned-players.txt");
            File ops = new File("ops.txt");
            File whitelist = new File("white-list.txt");
            if (bannedIps.exists() && bannedIps.isFile()) {
                bannedIps.delete();
            }
            if (bannedPlayers.exists() && bannedPlayers.isFile()) {
                bannedPlayers.delete();
            }
            if (ops.exists() && ops.isFile()) {
                ops.delete();
            }
            if (whitelist.exists() && whitelist.isFile()) {
                whitelist.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean guilogoutputhandler_prePublish(LogRecord log) {
        String msg = log.getMessage();
        de tr = de.a();
        if (msg.startsWith("Starting minecraft server version")) {
            msg = msg.replace("Starting minecraft server version", tr.a("minecraftServer.startingServerVersion"));
        }
        if (msg.startsWith("Loading properties")) {
            msg = msg.replace("Loading properties", tr.a("minecraftServer.loadingProperties"));
        }
        if (msg.startsWith("Default game type: ")) {
            msg = msg.replace("Default game type: ", tr.a("minecraftServer.defaultGameType"));
        }
        if (msg.startsWith("Generating keypair")) {
            msg = msg.replace("Generating keypair", tr.a("minecraftServer.GenerateKeyPair"));
        }
        if (msg.startsWith("Starting Minecraft server on ")) {
            msg = msg.replace("Starting Minecraft server on ", tr.a("minecraftServer.startingServerOn"));
        }
        if (msg.startsWith("Preparing level \"")) {
            msg = msg.replace("Preparing level \"", tr.a("minecraftServer.preparingLevel"));
        }
        if (msg.startsWith("Preparing start region for level")) {
            msg = msg.replace("Preparing start region for level", tr.a("minecraftServer.preparingRegion"));
        }
        if (msg.startsWith("Done (")) {
            msg = msg.replace("Done (", tr.a("minecraftServer.done"));
        }
        if (msg.contains(")! For help, type \"help\" or \"?\"")) {
            msg = msg.replace(")! For help, type \"help\" or \"?\"", tr.a("minecraftServer.help"));
        }
        if (msg.contains("Turned on world auto-saving")) {
            msg = msg.replace("Turned on world auto-saving", tr.a("minecraftServer.AutoSavingOn"));
        }
        if (msg.contains("issued server command: ")) {
            msg = msg.replace("issued server command: ", tr.a("netServerHandler.issued"));
        }
        if (msg.contains("Banned player ip")) {
            msg = msg.replace("Banned player ip", tr.a("minecraftServer.IPBanned"));
        }
        if (msg.contains("Banned IP address")) {
            msg = msg.replace("Banned IP address", tr.a("minecraftServer.IPBanned"));
        }
        if (msg.contains("Started debug profiling")) {
            msg = msg.replace("Started debug profiling", tr.a("minecraftServer.debugStart"));
        }
        if (msg.contains("Stopped debug profiling after")) {
            msg = msg.replace("Stopped debug profiling after", tr.a("minecraftServer.debugStop"));
        }
        if (msg.contains("seconds")) {
            msg = msg.replace("seconds", tr.a("minecraftServer.debugStop2"));
        }
        if (msg.contains("De-opped")) {
            msg = msg.replace("De-opped", tr.a("minecraftServer.deOpped"));
        }
        if (msg.contains("kicked ")) {
            msg = msg.replace("kicked ", tr.a("minecraftServer.kicked"));
        }
        if (msg.contains("from the game")) {
            msg = msg.replace("from the game", tr.a("minecraftServer.kicked2"));
        }
        if (msg.contains("moved wrongly!")) {
            msg = msg.replace("moved wrongly!", tr.a("minecraftServer.wrongMovement"));
        }
        if (msg.contains("Given")) {
            msg = msg.replace("Given", tr.a("minecraftServer.givenItem"));
        }
        if (msg.contains("Set own game mode")) {
            msg = msg.replace("Set own game mode", tr.a("minecraftServer.setOwnGameMode") + " ");
        }
        if (msg.contains("logged in with entity id ")) {
            msg = msg.replace("logged in with entity id ", tr.a("minecraftServer.loggedIn"));
        }
        if (msg.contains(" to")) {
            msg = msg.replace(" to", " " + tr.a("minecraftServer.removeTo"));
        }
        if (msg.contains("**** FAILED TO BIND TO PORT!")) {
            msg = msg.replace("**** FAILED TO BIND TO PORT!", tr.a("minecraftServer.failedToBindPort"));
        }
        if (msg.startsWith("The exception was:")) {
            msg = msg.replace("The exception was:", tr.a("minecraftServer.exceptionWas"));
        }
        if (msg.contains("Address already in use:")) {
            msg = msg.replace("Address already in use:", tr.a("minecraftServer.serverErrorOccured"));
        }
        if (msg.contains("Perhaps a server is already running on that port?")) {
            msg = msg.replace("Perhaps a server is already running on that port?", tr.a("minecraftServer.serverAlreadyRunning"));
        }
        if (msg.contains("An unknown error occurred while attempting perform this command")) {
            msg = msg.replace("An unknown error occurred while attempting perform this command", tr.a("minecraftServer.serverErrorOccured"));
        }
        if (msg.contains("lost connection")) {
            msg = msg.replace("lost connection", tr.a("minecraftServer.connectionLost"));
        }
        if (msg.contains("disconnect.quitting")) {
            msg = msg.replace("disconnect.quitting", tr.a("disconnect.quitting"));
        }
        if (msg.contains("disconnect.spam")) {
            msg = msg.replace("disconnect.spam", tr.a("disconnect.spam"));
        }
        if (msg.contains("gameMode.minecraftedu")) {
            msg = msg.replace("gameMode.minecraftedu", tr.a("serverGui.enableCreative"));
        }
        if (msg.contains("disconnect.genericReason")) {
            msg = msg.replace("disconnect.genericReason", tr.a("disconnect.genericReason"));
        }
        if (msg.contains("Unbanned player")) {
            msg = msg.replace("Unbanned player", tr.a("minecraftServer.Unban"));
        }
        if (msg.contains("Turned off world auto-saving")) {
            msg = msg.replace("Turned off world auto-saving", tr.a("minecraftServer.AutoSavingOff"));
        }
        if (msg.contains("Saved the world")) {
            msg = msg.replace("Saved the world", tr.a("minecraftServer.Saved"));
        }
        if (msg.contains("Unbanned IP address")) {
            msg = msg.replace("Unbanned IP address", tr.a("minecraftServer.IPUnbanned"));
        }
        if (msg.startsWith("Can't keep up! Did the system time change, or is the server overloaded?")) {
            msg = msg.replace("Can't keep up! Did the system time change, or is the server overloaded?", tr.a("minecraftServer.CantKeepUp"));
        }
        if (msg.contains("Date:")) {
            msg = msg.replace("Date:", tr.a("minecraftServer.Date"));
        }
        if (msg.startsWith("This server is using MinecraftEdu")) {
            msg = msg.replace("This server is using MinecraftEdu", tr.a("minecraftServer.ServerInfo"));
        }
        if (msg.equals("SERVER_LOADED")) {
            msg = msg.replace("SERVER_LOADED", tr.a("minecraftServer.ServerLoaded"));
        }
        if (msg.contains("Jan")) {
            msg = msg.replace("Jan", tr.a("minecraftMonths.Jan"));
        }
        if (msg.contains("Feb")) {
            msg = msg.replace("Feb", tr.a("minecraftMonths.Feb"));
        }
        if (msg.contains("Mar")) {
            msg = msg.replace("Mar", tr.a("minecraftMonths.Mar"));
        }
        if (msg.contains("Apr")) {
            msg = msg.replace("Apr", tr.a("minecraftMonths.Apr"));
        }
        if (msg.contains("May")) {
            msg = msg.replace("May", tr.a("minecraftMonths.May"));
        }
        if (msg.contains("Jun")) {
            msg = msg.replace("Jun", tr.a("minecraftMonths.Jun"));
        }
        if (msg.contains("Jul")) {
            msg = msg.replace("Jul", tr.a("minecraftMonths.Jul"));
        }
        if (msg.contains("Aug")) {
            msg = msg.replace("Aug", tr.a("minecraftMonths.Aug"));
        }
        if (msg.contains("Sep")) {
            msg = msg.replace("Sep", tr.a("minecraftMonths.Sep"));
        }
        if (msg.contains("Oct")) {
            msg = msg.replace("Oct", tr.a("minecraftMonths.Oct"));
        }
        if (msg.contains("Nov")) {
            msg = msg.replace("Nov", tr.a("minecraftMonths.Nov"));
        }
        if (msg.contains("Dec")) {
            msg = msg.replace("Dec", tr.a("minecraftMonths.Dec"));
        }
        log.setMessage(msg);
        return false;
    }

    public boolean preHandleSwingItem(mw player) {
        return false;
    }

    public static EduServerHooks getS() {
        if (singleton == null) {
            singleton = new EduServerHooks();
        }
        return singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

