/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JOptionPane;
import mcedu.EduAccessHelperServer;
import mcedu.RuntimeSettings;
import mcedu.blocks.EduBlockContainer;
import mcedu.blocks.EduBlockStore;
import mcedu.blocks.EduBlocks;
import mcedu.common.EduCommandEnums;
import mcedu.common.EduEnums;
import mcedu.global.Version;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.Debug;
import mcedu.global.tools.MessageBox;
import mcedu.server.EduServerSettings;
import mcedu.server.EduServerSignHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeVersion;
import org.apache.commons.io.output.TeeOutputStream;

public class EduServerFunctions {
    public static void setCorrectPersonalCreativeForTeachers() {
        ArrayList playerList = (ArrayList)EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerEntityList();
        if (playerList.size() < 1) {
            return;
        }
        for (mw player : playerList) {
            if (!EduAccessHelperServer.isPlayerOp(player.getName()) || !player.playerabilities.personalCreativeEnabled) continue;
            ((lt)EduAccessHelperServer.getServer()).a("/" + EduCommandEnums.ORIG_CMD_GAMEMODE + " " + ahk.c + " " + player.getName(), (ac)EduAccessHelperServer.getServer());
        }
    }

    public static void setFlyModeForStudent(mw player, boolean value) {
        player.bE.c = value;
        player.q();
    }

    public static void setFlyModeForAllStudents(boolean value) {
        ArrayList playerList = (ArrayList)EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerEntityList();
        if (playerList.size() < 1) {
            return;
        }
        for (mw player : playerList) {
            if (EduAccessHelperServer.isPlayerOp(player.getName()) || player.eduGetItemInWorldManager().b() == ahk.c) continue;
            player.bE.c = value;
            if (value) {
                EduAccessHelperServer.sendChatMessageToPlayer((yz)player, "\u00a72" + de.a().a("eduCommandHandler.studentFlyingEnabled"));
            } else {
                player.bE.b = false;
                EduAccessHelperServer.sendChatMessageToPlayer((yz)player, "\u00a7c" + de.a().a("eduCommandHandler.studentFlyingDisabled"));
            }
            player.q();
        }
    }

    public static boolean isCommandAllowedForStudents(String command) {
        ArrayList allowedCommands = (ArrayList)Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathAllowedStudentCommandsFile);
        for (Object cmd : allowedCommands) {
            String line = cmd.toString();
            if (!command.startsWith(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCommandBanned(String command) {
        ArrayList bannedCommands = (ArrayList)Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathBannedCommandsFile);
        for (Object cmd : bannedCommands) {
            String line = cmd.toString();
            if (!command.startsWith(line)) continue;
            return true;
        }
        return false;
    }

    public static void giveItemToUser(mw player, add item) {
        boolean inventoryFull = false;
        for (int i = 0; i < player.bm.a.length; ++i) {
            if (player.bm.a[i] == null) {
                inventoryFull = false;
                break;
            }
            inventoryFull = true;
        }
        de tr = de.a();
        String translatedItem = tr.a(item.a() + ".name");
        EduAccessHelperServer.sendChatMessageToPlayer((yz)player, tr.a("EduServerFunctions.youWereGiven") + " " + "\u00a72" + translatedItem + " (" + item.b + ")");
        if (!inventoryFull) {
            player.bm.a(item);
        } else {
            player.a(item, false);
        }
    }

    public static void loadExternalClassesToClasspath(HashMap<File, String> files) {
        String className = "";
        boolean loadOK = false;
        for (Map.Entry<File, String> entry : files.entrySet()) {
            loadOK = false;
            File file = entry.getKey();
            className = entry.getValue();
            try {
                Class.forName(className);
                loadOK = true;
            }
            catch (Exception e) {
                try {
                    if (!file.exists()) {
                        throw new IOException("File does not exist: " + file.getAbsolutePath());
                    }
                    if (!EduServerFunctions.addURLToClasspath(file.toURI().toURL())) {
                        throw new Exception("Could not load class!");
                    }
                    System.out.println("Loaded class " + entry.getKey().getAbsolutePath() + " manually.");
                }
                catch (Exception ex) {
                    System.out.println("Error loading class " + entry.getKey().getAbsolutePath() + " to classpath. Error: " + ex.getMessage());
                }
            }
            if (!loadOK) continue;
            System.out.println("Class " + entry.getValue() + " has already been loaded to classpath succesfully. Sweet!");
        }
    }

    private static boolean addURLToClasspath(URL file) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, file);
        return true;
    }

    public static void changeGamemodeForEveryone(MinecraftServer minecraftServer, ahk enumgametype) {
        minecraftServer.a(enumgametype);
        if (EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerEntityList().size() < 1) {
            return;
        }
        List players = EduAccessHelperServer.getServerConfigurationManager().eduGetPlayerEntityList();
        for (Object player : players) {
            mw sourcePlayer = (mw)player;
            sourcePlayer.eduGetItemInWorldManager().a(enumgametype);
            sourcePlayer.a.a((ft)new gv(3, (float)enumgametype.a()));
            sourcePlayer.playerabilities.prevGameMode = enumgametype;
        }
    }

    public static void changeGamemodeForUserWhenFreezed(mw player, boolean state) {
        if (state) {
            player.playerabilities.prevGameMode = player.eduGetItemInWorldManager().b();
            player.eduGetItemInWorldManager().a(ahk.EDU);
            player.a.a((ft)new gv(3, (float)ahk.EDU.a()));
        } else {
            player.eduGetItemInWorldManager().a(player.playerabilities.prevGameMode);
            player.a.a((ft)new gv(3, (float)player.playerabilities.prevGameMode.a()));
        }
    }

    public static boolean checkIfCanDigHere(mw player, int x, int y2, int z2) {
        if (EduAccessHelperServer.isPlayerOp(player.getName())) {
            return true;
        }
        if (RuntimeSettings.isMP() && player.playerabilities.isFreezed || EduServerSettings.getS().settingsWorldHandler.getGameStudentsFreezed()) {
            EduServerFunctions.sendBlockBackToPlayer(player, x, y2, z2);
            return false;
        }
        mt worldserver = player.b.getWorldManager(player.ap);
        aji block = worldserver.a(x, y2, z2);
        for (String disAllowed : EduEnums.EDU_ADMIN_BLOCKS) {
            if (!block.a().equals(disAllowed)) continue;
            EduServerFunctions.sendBlockBackToPlayer(player, x, y2, z2);
            return false;
        }
        boolean canDig = true;
        aji highestBlock = ajn.a;
        for (int i = -64; i < EduEnums.MAP_HEIGHT; ++i) {
            if (EduBlocks.areBlocksEqualByName(worldserver.a(x, i, z2), EduBlocks.blockBorder)) {
                EduServerFunctions.sendBlockBackToPlayer(player, x, y2, z2);
                return false;
            }
            if (i > y2) continue;
            if (EduBlocks.areBlocksEqualByName(worldserver.a(x, i, z2), EduBlocks.blockBuildAllow)) {
                highestBlock = EduBlocks.blockBuildAllow;
                continue;
            }
            if (!EduBlocks.areBlocksEqualByName(worldserver.a(x, i, z2), EduBlocks.blockBuildDisallow)) continue;
            highestBlock = EduBlocks.blockBuildDisallow;
        }
        if (RuntimeSettings.isMP() && EduServerSettings.getS().settingsWorldHandler.getWorldStudentBuildDisabled()) {
            if (EduBlocks.areBlocksEqualByName(highestBlock, EduBlocks.blockBuildAllow)) {
                return true;
            }
            EduServerFunctions.sendBlockBackToPlayer(player, x, y2, z2);
            return false;
        }
        if (EduBlocks.areBlocksEqualByName(highestBlock, EduBlocks.blockBuildDisallow)) {
            EduServerFunctions.sendBlockBackToPlayer(player, x, y2, z2);
            return false;
        }
        return true;
    }

    public static boolean checkIfCanPlaceHere(mw player, int x, int y2, int z2) {
        int cal;
        if (EduAccessHelperServer.isPlayerOp(player.getName())) {
            return true;
        }
        if (player.playerabilities.isFreezed || EduServerSettings.getS().settingsWorldHandler.getGameStudentsFreezed()) {
            return false;
        }
        mt worldserver = player.b.getWorldManager(player.ap);
        boolean stopFor = false;
        aji block = ajn.a;
        for (cal = y2; cal > -64; --cal) {
            if (EduBlocks.isBlockEqualToAny(worldserver.a(x, cal, z2), EduBlocks.blockBuildAllow, EduBlocks.blockBuildDisallow, EduBlocks.blockBorder)) {
                block = worldserver.a(x, cal, z2);
                stopFor = true;
            }
            if (stopFor) break;
        }
        for (cal = y2; cal < EduEnums.MAP_HEIGHT; ++cal) {
            if (EduBlocks.areBlocksEqualByName(worldserver.a(x, cal, z2), EduBlocks.blockBorder)) {
                block = worldserver.a(x, cal, z2);
                stopFor = true;
            }
            if (stopFor) break;
        }
        if (EduBlocks.isBlockEqualToAny(worldserver.a(x, y2, z2), ajn.as, ajn.an)) {
            return false;
        }
        if (EduBlocks.isBlockEqualToAny(block, EduBlocks.blockBuildDisallow, EduBlocks.blockBorder)) {
            return false;
        }
        if (EduBlocks.areBlocksEqualByName(block, EduBlocks.blockBuildAllow)) {
            return true;
        }
        if (RuntimeSettings.isMP() && EduServerSettings.getS().settingsWorldHandler.getWorldStudentBuildDisabled() && EduBlocks.areBlocksEqualByName(block, EduBlocks.blockBuildAllow)) {
            return true;
        }
        return !RuntimeSettings.isMP() || !EduServerSettings.getS().settingsWorldHandler.getWorldStudentBuildDisabled();
    }

    private static void sendBlockBackToPlayer(mw player, int x, int y2, int z2) {
        mt worldserver = player.b.getWorldManager(player.ap);
        boolean isSign = false;
        if (EduBlocks.isBlockEqualToAny(player.o.a(x, y2, z2), ajn.an, ajn.as)) {
            isSign = true;
        }
        String cannotBuildMsg = de.a().a("NetServerHandler.CannotDig");
        player.a.a((ft)new gh(x, y2, z2, (ahb)worldserver));
        EduAccessHelperServer.sendChatMessageToPlayer((yz)player, cannotBuildMsg);
        if (isSign) {
            ii signPacket = new ii(x, y2, z2, EduServerSignHelper.getSignData(x, y2, z2));
            signPacket.bigSign = EduServerSignHelper.getSignSize(x, y2, z2);
            player.a.a((ft)signPacket);
            Debug.addDebugMessage(Debug.TYPE_SIGN, "Sending sign data back to player from position " + x + "." + y2 + "." + z2 + " and sign was big: " + EduServerSignHelper.getSignData(x, y2, z2));
        }
    }

    public static void openURL(String url) {
        if (url == null) {
            return;
        }
        if (!Desktop.isDesktopSupported()) {
            MessageBox.error("Desktop is not supported. Cannot open URL.", "You can open your browser and manually go to address here: " + url);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            MessageBox.error("Desktop browse is not supported. Cannot open URL.", "You can open your browser and manually go to address here: " + url);
            return;
        }
        try {
            URI uri = new URI(url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            MessageBox.error("Cannot open browser. Error: " + e, "You can open your browser and manually go to address here: " + url);
        }
    }

    public static boolean startExternalJarProgram(String directory, String fileName) {
        Boolean close = true;
        try {
            File fileDirectory = new File(directory + "/" + fileName);
            if (!fileDirectory.exists()) {
                MessageBox.error("Program to be started does not exist.", "Program: " + directory + "/" + fileName);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String javaStart = "java";
            if (System.getProperty("os.name").startsWith("Windows")) {
                javaStart = "\"" + System.getProperty("java.home") + "\\bin\\javaw\"";
            }
            String cmd = javaStart + " -Xmx300M -Xms300M -jar " + fileName;
            Process proc = Runtime.getRuntime().exec(cmd, null, new File(directory));
        }
        catch (Exception e) {
            MessageBox.notice("Error", "Could not start external program. Error message: " + e);
            close = false;
        }
        return close != false;
    }

    public static boolean refreshPlayerVisibility(mw entityplayermp, MinecraftServer minecraftServer) {
        int i;
        if (entityplayermp.playerabilities.spectate) {
            EduAccessHelperServer.getServerConfigurationManager().a((ft)new hq(new int[]{entityplayermp.y()}));
            return true;
        }
        oi serverconfigurationmanager = EduAccessHelperServer.getServerConfigurationManager();
        String[] playerlist = serverconfigurationmanager.eduGetPlayerAliasList();
        ArrayList<mw> entityList = new ArrayList<mw>();
        for (i = 0; i < playerlist.length; ++i) {
            entityList.add(EduAccessHelperServer.getPlayerForUsername(playerlist[i]));
        }
        for (i = 0; i < entityList.size(); ++i) {
            if (((mw)entityList.get(i)).getName().equalsIgnoreCase(entityplayermp.getName())) continue;
            EduAccessHelperServer.getServerConfigurationManager().sendPacketToPlayer(((mw)entityList.get(i)).getName(), (ft)new gb((yz)entityplayermp));
        }
        return false;
    }

    public static EduBlockContainer getAreaOfBlocks(yz playerEntity, EduBlockStore blFirst, EduBlockStore blSecond) {
        int x1 = blFirst.x;
        int y1 = blFirst.y;
        int z1 = blFirst.z;
        int x2 = blSecond.x;
        int y2 = blSecond.y;
        int z2 = blSecond.z;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int hz = z2 - z1;
        int zdir = 1;
        int ydir = 1;
        int xdir = 1;
        if (hz < 0) {
            zdir = -1;
        }
        if (hy < 0) {
            ydir = -1;
        }
        if (hx < 0) {
            xdir = -1;
        }
        int dim = playerEntity.ap;
        EduBlockContainer returnContainer = new EduBlockContainer();
        returnContainer.addBlockToList(new EduBlockStore(blFirst.x, blFirst.y, blFirst.z, ajn.a, 0, dim));
        returnContainer.addBlockToList(new EduBlockStore(blSecond.x, blSecond.y, blSecond.z, ajn.a, 0, dim));
        for (int z3 = z1; z3 != z2 + zdir; z3 += zdir) {
            for (int y3 = y1; y3 != y2 + ydir; y3 += ydir) {
                for (int x = x1; x != x2 + xdir; x += xdir) {
                    returnContainer.addBlockToList(x, y3, z3, blSecond.block, blSecond.meta, dim);
                }
            }
        }
        return returnContainer;
    }

    public static boolean teleport_CheckIfInvalidTeleportLine(String line, boolean checkAlsoValueIndex) {
        if (line == null || line.equals("")) {
            return true;
        }
        try {
            String[] testArray = line.split("\\=");
            if (testArray.length < 2) {
                return true;
            }
            if (testArray[0] == null || testArray[0].equals("")) {
                return true;
            }
            if (checkAlsoValueIndex && (testArray[1] == null || testArray[1].equals(""))) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
        return false;
    }

    public static int[] determineFacingAndReturnCoordinate(int x, int y2, int z2, int face) {
        int[] returnInt = new int[3];
        if (face == 0) {
            --y2;
        }
        if (face == 1) {
            ++y2;
        }
        if (face == 2) {
            --z2;
        }
        if (face == 3) {
            ++z2;
        }
        if (face == 4) {
            --x;
        }
        if (face == 5) {
            // empty if block
        }
        returnInt[0] = ++x;
        returnInt[1] = y2;
        returnInt[2] = z2;
        return returnInt;
    }

    public static int[] determineFacingAndReturnCoordinateReversed(int x, int y2, int z2, int face) {
        int[] returnInt = new int[3];
        if (face == 0) {
            ++y2;
        }
        if (face == 1) {
            --y2;
        }
        if (face == 2) {
            ++z2;
        }
        if (face == 3) {
            --z2;
        }
        if (face == 4) {
            ++x;
        }
        if (face == 5) {
            // empty if block
        }
        returnInt[0] = --x;
        returnInt[1] = y2;
        returnInt[2] = z2;
        return returnInt;
    }

    public static void setTeacherPassword(boolean firstStart) {
        boolean passwordOK = false;
        String newPassword = "";
        boolean iniEmpty = false;
        de tr = de.a();
        Scanner scanner = new Scanner(System.in);
        int curPWLength = 0;
        String curPassword = EduServerSettings.getS().settingsServerHandler.getTeacherPasswordFirstCharacter();
        try {
            curPWLength = Integer.parseInt(EduServerSettings.getS().settingsServerHandler.getTeacherPasswordLength());
        }
        catch (Exception e) {
            iniEmpty = true;
        }
        if (curPassword == null) {
            iniEmpty = true;
        }
        if (EduServerSettings.getS().settingsServerHandler.getTeacherPasswordLength() == null || EduServerSettings.getS().settingsServerHandler.getTeacherPasswordLength().isEmpty()) {
            iniEmpty = true;
        }
        if (!iniEmpty) {
            for (int i = 1; i < curPWLength; ++i) {
                curPassword = curPassword + "*";
            }
        }
        if (firstStart && !iniEmpty) {
            return;
        }
        while (!passwordOK) {
            if (!iniEmpty) {
                newPassword = MessageBox.inputPassword(tr.a("eduSettings.changePassword"), tr.a("eduSettings.currentPassword") + curPassword + tr.a("eduSettings.newPassword"), false);
            } else if (EduServerSettings.getS().noGui) {
                System.out.println(tr.a("eduSettings.passwordNotSetYet"));
                newPassword = scanner.nextLine();
            } else {
                newPassword = MessageBox.inputPassword(tr.a("eduSettings.setTeacherPassword"), tr.a("eduSettings.passwordNotSetYet"), true);
            }
            if ((newPassword == null || newPassword.equals("")) && !firstStart) break;
            if (newPassword == null && firstStart) {
                MessageBox.notice(tr.a("eduSettings.passwordMustBeSet"), tr.a("eduSettings.passwordRequired"));
                continue;
            }
            if (newPassword.length() > 3 && newPassword.length() < 15 && !newPassword.trim().equals("")) {
                passwordOK = true;
                continue;
            }
            if (EduServerSettings.getS().noGui) {
                System.out.println(tr.a("eduSettings.passwordProblem"));
                continue;
            }
            MessageBox.notice(tr.a("eduSettings.passwordNotSet"), tr.a("eduSettings.passwordProblem"));
        }
        if (passwordOK) {
            EduServerSettings.getS().settingsServerHandler.setSettingNewTeacherPassword(newPassword);
            if (EduServerSettings.getS().noGui) {
                System.out.println(tr.a("eduSettings.PasswordSuccesfully"));
            } else {
                MessageBox.notice(tr.a("eduSettings.passwordChanged"), tr.a("eduSettings.PasswordSuccesfully"));
            }
        }
    }

    public static void printDebug() {
        int calc = 0;
        int max = Thread.currentThread().getStackTrace().length;
        boolean skipFirst = true;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (calc == 0) {
                System.out.println("Debug stacktrace ends!");
            }
            if (calc == 0 || calc == 1) {
                ++calc;
                continue;
            }
            System.out.println(ste);
            if (calc == max - 1) {
                System.out.println("Debug stacktrace begins ^");
            }
            ++calc;
        }
    }

    public static void printDebugMessageBox(String message) {
        JOptionPane.showMessageDialog(null, message, "", 1);
    }

    public static boolean enableDebugFileWriting(File debugFileLocation, HashMap<String, String> paths) {
        try {
            if (!debugFileLocation.exists()) {
                debugFileLocation.getParentFile().mkdirs();
                debugFileLocation.createNewFile();
            } else {
                debugFileLocation.delete();
                debugFileLocation.getParentFile().mkdirs();
                debugFileLocation.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(debugFileLocation);
            TeeOutputStream out = new TeeOutputStream(System.out, fos);
            PrintStream printstream = new PrintStream(out);
            System.setOut(printstream);
            SimpleDateFormat dateformat = new SimpleDateFormat("dd. MMMM. yyyy HH:mm");
            Date date = new Date();
            System.out.println("Debug logging for Minecraft Server started at: " + dateformat.format(date));
            System.out.println("Server.log path: " + debugFileLocation);
            System.out.println("###############################################");
            System.out.println("MinecraftEdu version: " + Version.getFormattedVersion() + " build " + Version.getBuildNumber() + " " + (Version.isClassroom() ? "Classroom" : "Premium"));
            System.out.println("Forge version: " + ForgeVersion.getVersion());
            System.out.println("PATHS:");
            for (Map.Entry<String, String> entry : paths.entrySet()) {
                System.out.println(entry.getKey() + " " + entry.getValue());
            }
            System.out.println("###############################################");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

