/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import mcedu.blocks.EduBlockContainer;
import mcedu.blocks.EduBlockStore;
import mcedu.server.EduServerSettings;
import mcedu.server.EduServerUndoList;
import net.minecraft.server.MinecraftServer;

public class EduPlayerAbilities {
    private int placeBlocksAmount = 1;
    private int digBlocksAmount = 1;
    public EduServerUndoList undoPlaceList = new EduServerUndoList();
    public EduServerUndoList undoDigList = new EduServerUndoList();
    public EduServerUndoList undoFillList = new EduServerUndoList();
    public boolean spectate = false;
    public boolean isInFreeFly = false;
    public boolean newBuildModeActivated = false;
    public boolean isFreezed;
    public boolean isMuted;
    public boolean isBuildModeAllowed;
    public boolean fillEnabled = false;
    public EduBlockContainer fillBlockLocations = new EduBlockContainer();
    public ahk prevGameMode;
    public boolean personalCreativeEnabled;
    public double lastX;
    public double lastY;
    public double lastZ;
    public float lastPitch;
    public float lastYaw;
    public long timeStamp;
    private int idleCount = 0;
    public boolean isIdle = false;

    private String tr(String stringToTranslate) {
        return de.a().a(stringToTranslate);
    }

    public EduPlayerAbilities(boolean isFreezed, boolean isMuted, boolean isBuildModeAllowed, boolean personalCreativeEnabled) {
        this.isFreezed = isFreezed;
        this.isMuted = isMuted;
        this.isBuildModeAllowed = isBuildModeAllowed;
        this.personalCreativeEnabled = personalCreativeEnabled;
    }

    public EduBlockContainer getFillContainer() {
        return this.fillBlockLocations;
    }

    public void addBlockStoreToFillList(EduBlockStore edublockstore) {
        this.fillBlockLocations.addBlockToList(edublockstore);
    }

    public void clearFillList() {
        if (!this.fillBlockLocations.getBlockList().isEmpty()) {
            this.fillBlockLocations.getBlockList().clear();
        }
    }

    public int getPlaceBlocksAmount() {
        return this.placeBlocksAmount;
    }

    public String setPlaceBlocksAmount(int amount) {
        boolean error = false;
        if (amount < 1 || amount > 45) {
            amount = 1;
            error = true;
        }
        this.placeBlocksAmount = amount;
        if (error) {
            return this.tr("EduPlayerAbilities.placeAmountError");
        }
        return this.tr("EduPlayerAbilities.placeAmountSet") + " " + amount;
    }

    public int getDigBlocksAmount() {
        return this.digBlocksAmount;
    }

    public String setDigBlocksAmount(int amount) {
        boolean error = false;
        if (amount < 1 || amount > 45) {
            amount = 1;
            error = true;
        }
        this.digBlocksAmount = amount;
        if (error) {
            return this.tr("EduPlayerAbilities.digAmountError");
        }
        return this.tr("EduPlayerAbilities.digAmountSet") + " " + amount;
    }

    public void updateIdleState(double currentX, double currentY, double currentZ, float currentPitch, float currentYaw, String username) {
        if (Math.abs(Math.abs(this.lastPitch) - Math.abs(currentPitch)) < 5.0f && Math.abs(Math.abs(this.lastYaw) - Math.abs(currentYaw)) < 5.0f && Math.abs(Math.abs(this.lastX) - Math.abs(currentX)) < 1.0 && Math.abs(Math.abs(this.lastY) - Math.abs(currentY)) < 1.0 && Math.abs(Math.abs(this.lastZ) - Math.abs(currentZ)) < 1.0 && System.currentTimeMillis() - this.timeStamp > 60000L) {
            ++this.idleCount;
        } else {
            this.idleCount = 0;
            if (this.isIdle && EduServerSettings.getS().settingsServerHandler.getSettingLogIdlePlayers()) {
                MinecraftServer.I().e("Player " + username + " is no longer idle.");
            }
            this.isIdle = false;
        }
        this.lastX = currentX;
        this.lastY = currentY;
        this.lastZ = currentZ;
        this.lastPitch = currentPitch;
        this.lastYaw = currentYaw;
    }

    public int getIdleCount() {
        return this.idleCount;
    }
}

