/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import mcedu.Debug;
import mcedu.common.EduEnums;
import mcedu.global.tools.AbstractSettingsHandler;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduServerSettings;

public class EduMapSettingsHandler
extends AbstractSettingsHandler {
    public EduMapSettingsHandler(File pathToSettingsFile, String missingSettingDefaultValue) {
        super(pathToSettingsFile, missingSettingDefaultValue);
    }

    @Override
    public void init() {
        if (!this.pathToSettingsFile.exists()) {
            Datahandler.createFile(this.pathToSettingsFile.getAbsolutePath());
            Datahandler.iniSet(this.pathToSettingsFile.getAbsolutePath(), "edu-world-format", "0.2");
        }
    }

    @Override
    public HashMap<String, String> getDefaultSettings() {
        HashMap<String, String> defSettings = new HashMap<String, String>();
        defSettings.put("description", " ");
        defSettings.put("fire-and-tnt", "false");
        defSettings.put("desertification", "false");
        defSettings.put("disable-night", "false");
        defSettings.put("disable-weather", "false");
        defSettings.put("tropification", "false");
        defSettings.put("disable-student-build", "false");
        defSettings.put("spawn-monsters", "false");
        defSettings.put("spawn-animals", "false");
        defSettings.put("spawn-villagers", "false");
        defSettings.put("welcome", "");
        defSettings.put("motd", "");
        defSettings.put("gamemode", "gamemode_edu");
        defSettings.put("difficulty", "difficulty_normal");
        defSettings.put("students-freezed", "false");
        defSettings.put("students-muted", "false");
        defSettings.put("students-can-teleport-to-spawn", "false");
        defSettings.put("students-can-teleport-to-surface", "false");
        defSettings.put("allow-other-dimensions", "false");
        defSettings.put("pvp", "false");
        defSettings.put("generate-structures", "true");
        defSettings.put("students-can-fly", "false");
        defSettings.put("always-show-xpbar", "false");
        defSettings.put("ccedu-enabled", "true");
        defSettings.put("force-code-view", "false");
        defSettings.put("disable-ide", "false");
        defSettings.put("stop-all-turtles", "false");
        defSettings.put("turtles-can-build", "true");
        return defSettings;
    }

    @Override
    public HashMap<String, String> getSettingComments() {
        HashMap<String, String> defSettings = new HashMap<String, String>();
        defSettings.put("description", "Saved world description for this world. Will be shown in the Server Launcher when you view this saved world.");
        defSettings.put("fire-and-tnt", "Is it allowed to use fire and tnt in this world? Default: false");
        defSettings.put("desertification", "Is desertification enabled in this world? This means that sand spreads to neighbour blocks. Experimental setting and should not be enabled. Default: false");
        defSettings.put("disable-night", "Is night disabled in this world? Default: false");
        defSettings.put("disable-weather", "Are weather changes disabled in this world? Default: false");
        defSettings.put("tropification", "Is tropification enabled in this world? This means that blocks under trees start turning into grass. Experimental setting and should not be enabled. Default: false");
        defSettings.put("disable-student-build", "Are students not allowed to build in this world? Default: false");
        defSettings.put("spawn-monsters", "Are monsters enabled and can spawn in this world? Default: false");
        defSettings.put("spawn-animals", "Are animals enabled and can spawn in this world? Default: false");
        defSettings.put("spawn-villagers", "Are villagers enabled and can spawn in this world? Default: false");
        defSettings.put("welcome", "Welcome message shown for players as a chat message when they join the world. Default: empty");
        defSettings.put("motd", "Message of the day for this world. Will be shown in the MinecraftEdu Client's server list for this server. Default: empty");
        defSettings.put("gamemode", "Default gamemode for players. Can be gamemode_edu, gamemode_creative or gamemode_survival. Default: gamemode_edu");
        defSettings.put("difficulty", "World's difficulty. Can be difficulty_peaceful, difficulty_easy, difficulty_normal or difficulty_hard. Default: difficulty_normal");
        defSettings.put("students-freezed", "Are all students freezed? Default: false");
        defSettings.put("students-muted", "Are all students muted (cannot send chat messages)? Default: false");
        defSettings.put("students-can-teleport-to-spawn", "Can students use the 'teleport back to spawn location' button in student menu? Default: false");
        defSettings.put("students-can-teleport-to-surface", "Can students use the 'teleport back to surface' button in student menu? Default: false");
        defSettings.put("allow-other-dimensions", "Can players traverse to other dimensions? Default: false");
        defSettings.put("pvp", "Is PVP (player versus player) enabled? Default: false");
        defSettings.put("generate-structures", "Can structures and buildings be generated in new areas? Default: true");
        defSettings.put("students-can-fly", "Can students fly even without being in creative mode? Default: false");
        defSettings.put("always-show-xpbar", "Should we always show xp (experience) bar even when in minecraftedu and creative gamemodes? Default: false");
        return defSettings;
    }

    @Override
    public String getFormattedComment(String comment) {
        return "# " + comment;
    }

    @Override
    public String getCommentStartFormat() {
        return "# ";
    }

    @Override
    public String getFileComment() {
        return this.getFormattedComment("MinecraftEdu settings for this world. Most of these can be changed from the MinecraftEdu Server settings menu.");
    }

    public boolean getWorldSpeedFast() {
        return Boolean.parseBoolean(this.getValueForSetting("disable-night"));
    }

    public boolean getWorldWeatherDisabled() {
        return Boolean.parseBoolean(this.getValueForSetting("disable-weather"));
    }

    public boolean getWorldFireAndTntDisabled() {
        return Boolean.parseBoolean(this.getValueForSetting("fire-and-tnt"));
    }

    public boolean getWorldDesertificationEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("desertification"));
    }

    public boolean getWorldTropificationEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("tropification"));
    }

    public boolean getWorldStudentBuildDisabled() {
        return Boolean.parseBoolean(this.getValueForSetting("disable-student-build"));
    }

    public boolean getWorldMonstersEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("spawn-monsters"));
    }

    public boolean getWorldAnimalsEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("spawn-animals"));
    }

    public boolean getWorldVillagersEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("spawn-villagers"));
    }

    public boolean getSettingGenerateStructures() {
        return Boolean.parseBoolean(this.getValueForSetting("generate-structures"));
    }

    public void setWorldSpeedFast(boolean val) {
        this.saveSetting("disable-night", Boolean.toString(val).toLowerCase());
    }

    public void setWorldWeatherDisabled(boolean val) {
        this.saveSetting("disable-weather", Boolean.toString(val).toLowerCase());
    }

    public void setWorldWorldFireAndTntDisabled(boolean val) {
        this.saveSetting("fire-and-tnt", Boolean.toString(val).toLowerCase());
    }

    public void setWorldDesertificationEnabled(boolean val) {
        this.saveSetting("desertification", Boolean.toString(val).toLowerCase());
    }

    public void setWorldTropificationEnabled(boolean val) {
        this.saveSetting("tropification", Boolean.toString(val).toLowerCase());
    }

    public void setWorldStudentBuildDisabled(boolean val) {
        this.saveSetting("disable-student-build", Boolean.toString(val).toLowerCase());
    }

    public void setWorldMonstersEnabled(boolean val) {
        this.saveSetting("spawn-monsters", Boolean.toString(val).toLowerCase());
    }

    public void setWorldAnimalsEnabled(boolean val) {
        this.saveSetting("spawn-animals", Boolean.toString(val).toLowerCase());
    }

    public void setWorldVillagersEnabled(boolean val) {
        this.saveSetting("spawn-villagers", Boolean.toString(val).toLowerCase());
    }

    public void setSettingGenerateStructures(boolean state) {
        this.saveSetting("generate-structures", Boolean.toString(state).toLowerCase());
    }

    public int getGameMode() {
        String setting = this.getValueForSetting("gamemode");
        for (Map.Entry<Integer, String> entry : EduEnums.gameModes.entrySet()) {
            if (!setting.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        Debug.printDebug("Trying to pull invalid gamemode from eduworldsettings file: " + setting);
        return 3;
    }

    public int getDifficulty() {
        String setting = this.getValueForSetting("difficulty");
        for (Map.Entry<Integer, String> entry : EduEnums.difficulties.entrySet()) {
            if (!setting.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        Debug.printDebug("Trying to pull invalid difficulty from eduworldsettings file: " + setting);
        return 2;
    }

    public boolean getGameStudentsFreezed() {
        return Boolean.parseBoolean(this.getValueForSetting("students-freezed"));
    }

    public boolean getGameStudentsMuted() {
        return Boolean.parseBoolean(this.getValueForSetting("students-muted"));
    }

    public boolean getGameStudentsCanTeleportToSpawn() {
        return Boolean.parseBoolean(this.getValueForSetting("students-can-teleport-to-spawn"));
    }

    public boolean getGameStudentsCanTeleportToSurface() {
        return Boolean.parseBoolean(this.getValueForSetting("students-can-teleport-to-surface"));
    }

    public boolean getGameAllowOtherDimensions() {
        return Boolean.parseBoolean(this.getValueForSetting("allow-other-dimensions"));
    }

    public boolean getGamePVPEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("pvp"));
    }

    public String getWelcomeMessage() {
        return this.getValueForSetting("welcome");
    }

    public String getMOTD() {
        return this.getValueForSetting("motd");
    }

    public boolean getGameAlwaysShowXPBar() {
        return Boolean.parseBoolean(this.getValueForSetting("always-show-xpbar"));
    }

    public boolean getGameStudentsCanFly() {
        return Boolean.parseBoolean(this.getValueForSetting("students-can-fly"));
    }

    public void setGameMode(int val) {
        if (!EduEnums.gameModes.containsKey(val)) {
            System.out.println("Error: User tried to set invalid value for gamemode: " + val);
            return;
        }
        this.saveSetting("gamemode", EduEnums.gameModes.get(val));
    }

    public void setDifficulty(int val) {
        if (!EduEnums.difficulties.containsKey(val)) {
            System.out.println("Error: User tried to set invalid value for difficulty: " + val);
            return;
        }
        this.saveSetting("difficulty", EduEnums.difficulties.get(val));
    }

    public void setGameStudentsFreezed(boolean val) {
        this.saveSetting("students-freezed", Boolean.toString(val).toLowerCase());
    }

    public void setGameStudentsMuted(boolean val) {
        this.saveSetting("students-muted", Boolean.toString(val).toLowerCase());
    }

    public void setGameStudentsCanTeleportToSpawn(boolean val) {
        this.saveSetting("students-can-teleport-to-spawn", Boolean.toString(val).toLowerCase());
    }

    public void setGameStudentsCanTeleportToSurface(boolean val) {
        this.saveSetting("students-can-teleport-to-surface", Boolean.toString(val).toLowerCase());
    }

    public void setGameAllowOtherDimensions(boolean val) {
        this.saveSetting("allow-other-dimensions", Boolean.toString(val).toLowerCase());
    }

    public void setGamePVPEnabled(boolean val) {
        this.saveSetting("pvp", Boolean.toString(val).toLowerCase());
    }

    public void setWelcomeMessage(String message) {
        this.saveSetting("welcome", message);
    }

    public void setMOTD(String message) {
        this.saveSetting("motd", message);
    }

    public void setGameStudentsCanFly(boolean val) {
        this.saveSetting("students-can-fly", Boolean.toString(val).toLowerCase());
    }

    public boolean getCCEduEnabled() {
        return Boolean.parseBoolean(this.getValueForSetting("ccedu-enabled"));
    }

    public boolean getForceCodeView() {
        return Boolean.parseBoolean(this.getValueForSetting("force-code-view"));
    }

    public boolean getDisableIDE() {
        return Boolean.parseBoolean(this.getValueForSetting("disable-ide"));
    }

    public boolean getStopAllTurtles() {
        return Boolean.parseBoolean(this.getValueForSetting("stop-all-turtles"));
    }

    public boolean getTurtlesCanBuild() {
        return Boolean.parseBoolean(this.getValueForSetting("turtles-can-build"));
    }

    public void setCCEduEnabled(boolean val) {
        this.saveSetting("ccedu-enabled", Boolean.toString(val).toLowerCase());
    }

    public void setForceCodeView(boolean val) {
        this.saveSetting("force-code-view", Boolean.toString(val).toLowerCase());
    }

    public void setDisableIDE(boolean val) {
        this.saveSetting("disable-ide", Boolean.toString(val).toLowerCase());
    }

    public void setStopAllTurtles(boolean val) {
        this.saveSetting("stop-all-turtles", Boolean.toString(val).toLowerCase());
    }

    public void setTurtlesCanBuild(boolean val) {
        this.saveSetting("turtles-can-build", Boolean.toString(val).toLowerCase());
    }

    public String getOldSingleAssignmentTitle() {
        String setting = this.getValueForSetting("assignment-title");
        return setting.isEmpty() || setting.equals(this.getMissingSettingDefaultValue()) ? "" : setting;
    }

    public String getOldSingleAssignmentDescription() {
        String setting = this.getValueForSetting("assignment-description");
        return setting.isEmpty() || setting.equals(this.getMissingSettingDefaultValue()) ? "" : setting;
    }

    public void removeOldSingleLineAssignment() {
        Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathMapEduSettings, "assignment-title=");
        Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathMapEduSettings, "assignment-description=");
    }
}

