/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.io.File;
import java.util.List;
import mcedu.EduAccessHelperServer;
import mcedu.blocks.EduBlockTeleport;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.forgemod.network.EduRandomServerMessage;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduCommandBase;
import mcedu.server.EduExceptionParameterOutOfRange;
import mcedu.server.EduServerFunctions;
import mcedu.server.EduServerSettings;

public class EduCmdTeleportBlock
extends EduCommandBase {
    de tr = de.a();

    public String c() {
        return "eduteleportblock";
    }

    @Override
    public void handleEduCommand() throws EduExceptionParameterOutOfRange {
        String par0 = this.getArgStr(0);
        if (par0.equals("teleportmetostation")) {
            this.cmd_teleportPlayerToStation(this.getCallerEntity(), this.getArgInt(1), this.getArgInt(2), this.getArgInt(3), this.getArgIntDef(4, 0));
        } else if (par0.equals("openteleportgui")) {
            this.cmd_openTeleportGuiForPlayer(this.getCallerEntity(), this.getArgInt(1), this.getArgInt(2), this.getArgInt(3));
        } else if (par0.equals("openteleportguisdettings")) {
            this.cmd_openTeleportSettingsGuiForPlayer(this.getCallerEntity(), this.getArgInt(1), this.getArgInt(2), this.getArgInt(3));
        } else if (par0.equals("sendmeteleportpacket")) {
            this.cmd_sendTeleportStationsToPlayer(this.getCallerEntity(), this.getArgStrDef(1, "false").equals("true"));
        } else if (par0.equals("addtoallowedteleports")) {
            this.cmd_addAllowedTeleport(this.getArgStr(1), this.getArgStr(2));
        } else if (par0.equals("removefromallowedteleports")) {
            this.cmd_removeFromAllowedTeleports(this.getArgStr(1), this.getArgStr(2));
        } else if (par0.equals("changeteleportsettings")) {
            this.cmd_changeTeleportSettings(this.getCallerEntity(), this.getArgStr(1), this.getArgInt(2), this.getArgInt(3), this.getArgInt(4), this.getArgIntDef(5, 9999));
        } else {
            throw new cd("Passed EDU teleport block command was not found.", new Object[0]);
        }
    }

    @Override
    public void handleEduCommand(mw player) throws EduExceptionParameterOutOfRange {
    }

    @Override
    public void handleEduCommand(mw player, boolean value) throws EduExceptionParameterOutOfRange {
    }

    private void cmd_openTeleportGuiForPlayer(mw player, int x, int y2, int z2) {
        EduBlockTeleport.openTeleportGui((yz)player, false, x, y2, z2);
    }

    private void cmd_openTeleportSettingsGuiForPlayer(mw player, int x, int y2, int z2) {
        EduBlockTeleport.createTeleportSettingsFile();
        EduBlockTeleport.openTeleportSettingsGui(player, x, y2, z2);
    }

    private void cmd_teleportPlayerToStation(mw player, int x, int y2, int z2, int dimension) {
        String location = Integer.toString(x) + "." + Integer.toString(y2 -= 2) + "." + Integer.toString(z2);
        boolean teleportFound = false;
        List temp = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapTeleportLocationsFile);
        String tmpString = "";
        for (int i = 0; i < temp.size(); ++i) {
            tmpString = temp.get(i).toString();
            if (!tmpString.toLowerCase().startsWith(location)) continue;
            teleportFound = true;
        }
        if (teleportFound) {
            EduBlockTeleport.teleportPlayerToDirection(player, x, y2, z2);
        } else {
            EduAccessHelperServer.sendChatMessageToPlayer((yz)player, "\u00a7cError: Could not find teleport station at given location.");
        }
    }

    private void cmd_sendTeleportStationsToPlayer(mw player, boolean openTeleportStationsTabForUser) {
        String[] temp;
        if (!new File(EduServerSettings.getS().pathMapTeleportLocationsFile).exists()) {
            Datahandler.createFile(EduServerSettings.getS().pathMapTeleportLocationsFile);
        }
        List teleportLocationsGeneral = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapGeneralTeleportLocationsFile);
        String rows = "";
        for (int u2 = 0; u2 < teleportLocationsGeneral.size(); ++u2) {
            if (EduServerFunctions.teleport_CheckIfInvalidTeleportLine(teleportLocationsGeneral.get(u2).toString(), true)) continue;
            rows = rows + teleportLocationsGeneral.get(u2) + "||";
        }
        String[] general = rows.split("\\|\\|");
        String[] generalCoordinates = new String[1000];
        for (int u3 = 0; u3 < general.length; ++u3) {
            temp = general[u3].split("\\=");
            generalCoordinates[u3] = temp[0];
        }
        List teleportLocationslocal = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapTeleportLocationsFile);
        String rows2 = "";
        for (int u4 = 0; u4 < teleportLocationslocal.size(); ++u4) {
            if (EduServerFunctions.teleport_CheckIfInvalidTeleportLine(teleportLocationslocal.get(u4).toString(), true)) continue;
            rows2 = rows2 + teleportLocationslocal.get(u4) + "||";
        }
        String[] local = rows2.split("\\|\\|");
        String[] localCoordinates = new String[1000];
        for (int u5 = 0; u5 < local.length; ++u5) {
            temp = local[u5].split("\\=");
            localCoordinates[u5] = temp[0];
        }
        for (int x = 0; x < generalCoordinates.length && generalCoordinates[x] != null; ++x) {
            boolean found = false;
            for (int y2 = 0; y2 < localCoordinates.length; ++y2) {
                if (!generalCoordinates[x].equals(localCoordinates[y2])) continue;
                found = true;
            }
            if (found) continue;
            Datahandler.iniSet(EduServerSettings.getS().pathMapTeleportLocationsFile, generalCoordinates[x], de.a().a("EduBlockTeleport.Station") + ".1");
        }
        String finalrows = "";
        String location = "test";
        teleportLocationslocal = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapTeleportLocationsFile);
        for (int u6 = 0; u6 < teleportLocationslocal.size(); ++u6) {
            if (EduServerFunctions.teleport_CheckIfInvalidTeleportLine(teleportLocationslocal.get(u6).toString(), true)) continue;
            finalrows = finalrows + teleportLocationslocal.get(u6) + "||";
        }
        EduRandomServerMessage message = new EduRandomServerMessage();
        message.allTeleportLocations = finalrows;
        message.currentLocationCoordinates = location;
        message.currentLocationName = location;
        message.isEduTeleportLocations = false;
        message.refreshTeleportTabGui = openTeleportStationsTabForUser;
        EduNetworkUtils.sendToPlayer(message, player);
    }

    private void cmd_addAllowedTeleport(String sourceTeleportLocation, String teleportLocationToBeAddedAsAllowed) {
        EduBlockTeleport.addVisibilityToTeleport(sourceTeleportLocation, teleportLocationToBeAddedAsAllowed);
    }

    private void cmd_removeFromAllowedTeleports(String sourceTeleportLocation, String teleportLocationToBeRemovedFromAllowed) {
        EduBlockTeleport.removeVisibilityFromTeleport(sourceTeleportLocation, teleportLocationToBeRemovedFromAllowed);
    }

    private void cmd_changeTeleportSettings(mw player, String setting, int x, int y2, int z2, int optionalParam) {
        EduBlockTeleport.createTeleportSettingsFile();
        if (setting.equalsIgnoreCase("teleportdirection") && optionalParam != 9999) {
            EduBlockTeleport.setTeleportDirection(player, x, y2, z2, optionalParam);
            EduBlockTeleport.teleportPlayerToDirection(player, x, y2, z2);
        } else if (setting.equalsIgnoreCase("senddistance") && optionalParam != 9999) {
            EduBlockTeleport.setTeleportDistance(x, y2, z2, optionalParam);
            EduAccessHelperServer.sendChatMessageToPlayer((yz)player, this.tr.a("MinecraftEdu.EduCmdTeleportBlock.AddChatMessageDistance") + " " + optionalParam + ".");
        } else if (setting.equalsIgnoreCase("studentscanuse")) {
            EduBlockTeleport.setStudentCanUse(x, y2, z2);
        }
        this.cmd_openTeleportSettingsGuiForPlayer(player, x, y2, z2);
    }
}

