/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import mcedu.blocks.EduBlockContainer;
import mcedu.blocks.EduBlockStore;
import mcedu.server.EduCommandBase;
import mcedu.server.EduExceptionParameterOutOfRange;
import net.minecraft.server.MinecraftServer;

public class EduCmdBuild
extends EduCommandBase {
    public String c() {
        return "edubuild";
    }

    @Override
    public void handleEduCommand() throws EduExceptionParameterOutOfRange {
        String par0 = this.getArgStr(0);
        if (par0.equals("place")) {
            this.cmd_setPlayerPlaceAmount(this.getCallerEntity(), this.getArgInt(1));
        } else if (par0.equals("digamount")) {
            this.cmd_setPlayerDigAmount(this.getCallerEntity(), this.getArgInt(1));
        } else if (par0.equals("newbuildmodeactivated")) {
            this.cmd_setBuildModeStateForPlayer(this.getCallerEntity(), this.getArgStr(1).equals("true"));
        } else if (par0.equals("buildfill")) {
            this.cmd_setFillModeStateForPlayer(this.getCallerEntity(), this.getArgStr(1).equals("true"), this.getArgStr(2).equals("true"));
        } else if (par0.equals("undoplace")) {
            this.cmd_undoPlayerBlockPlace(this.getMcServer(), this.getCallerEntity(), this.getArgIntDef(1, 1));
        } else if (par0.equals("undodig")) {
            this.cmd_undoPlayerBlockDig(this.getMcServer(), this.getCallerEntity(), this.getArgIntDef(1, 1));
        } else if (par0.equals("undofill")) {
            this.cmd_undoPlayerFill(this.getMcServer(), this.getCallerEntity(), this.getArgIntDef(1, 1));
        } else {
            throw new cd("Passed EDU build command was not found.", new Object[0]);
        }
    }

    @Override
    public void handleEduCommand(mw player) throws EduExceptionParameterOutOfRange {
        String par0 = this.getArgStr(0);
        if (par0.equals("place")) {
            this.cmd_setPlayerPlaceAmount(player, this.getArgInt(1));
        } else if (par0.equals("digamount")) {
            this.cmd_setPlayerDigAmount(player, this.getArgInt(1));
        } else if (par0.equals("newbuildmodeactivated")) {
            this.cmd_setBuildModeStateForPlayer(player, this.getArgStr(1).equals("true"));
        } else if (par0.equals("buildfill")) {
            this.cmd_setFillModeStateForPlayer(player, this.getArgStr(1).equals("true"), this.getArgStr(2).equals("true"));
        } else if (par0.equals("undoplace")) {
            this.cmd_undoPlayerBlockPlace(this.getMcServer(), player, this.getArgIntDef(1, 1));
        } else if (par0.equals("undodig")) {
            this.cmd_undoPlayerBlockDig(this.getMcServer(), player, this.getArgIntDef(1, 1));
        } else if (par0.equals("undofill")) {
            this.cmd_undoPlayerFill(this.getMcServer(), player, this.getArgIntDef(1, 1));
        } else {
            throw new cd("Passed EDU build command was not found.", new Object[0]);
        }
    }

    @Override
    public void handleEduCommand(mw player, boolean value) throws EduExceptionParameterOutOfRange {
    }

    private void cmd_setPlayerPlaceAmount(mw player, int amount) {
        this.sendMsgToCaller(player.playerabilities.setPlaceBlocksAmount(amount));
    }

    private void cmd_setPlayerDigAmount(mw player, int amount) {
        this.sendMsgToCaller(player.playerabilities.setDigBlocksAmount(amount));
    }

    private void cmd_setBuildModeStateForPlayer(mw player, boolean state) {
        player.playerabilities.newBuildModeActivated = state;
    }

    private void cmd_setFillModeStateForPlayer(mw player, boolean state, boolean notifyUser) {
        if (state) {
            player.playerabilities.fillEnabled = true;
            player.sendEduServerMessage("clientBuildfill true");
            if (notifyUser) {
                this.sendMsgToCaller("\u00a72" + this.tr("EduCommandHandler.fillEnabled"));
            }
        } else {
            player.playerabilities.fillEnabled = false;
            player.playerabilities.fillBlockLocations.getBlockList().clear();
            player.sendEduServerMessage("clientBuildfill false");
            if (notifyUser) {
                this.sendMsgToCaller("\u00a7c" + this.tr("EduCommandHandler.fillDisabled"));
            }
        }
    }

    private void cmd_undoPlayerBlockPlace(MinecraftServer minecraftServer, mw player, int undoableBlockAmount) {
        for (int kk = 0; kk < undoableBlockAmount; ++kk) {
            if (this.getCallerEntity().playerabilities.undoPlaceList.getUndoListSize() == 0) {
                this.sendMsgToCaller("\u00a7c" + this.tr("EduCommandHandler.undoPlaceListEmpty"));
                return;
            }
            EduBlockContainer curBlock = this.getCallerEntity().playerabilities.undoPlaceList.getLastContainerFromUndoListAndRemove();
            for (int i = 0; i < curBlock.getBlockList().size(); ++i) {
                EduBlockStore loopBlock = curBlock.getBlockList().get(i);
                minecraftServer.getWorldManager(loopBlock.dimension).d(loopBlock.x, loopBlock.y, loopBlock.z, loopBlock.block, loopBlock.meta, 2);
            }
        }
        this.sendMsgToCaller("\u00a72" + this.tr("EduCommandHandler.undoPlaceCompleted") + " " + this.getCallerEntity().playerabilities.undoPlaceList.getUndoListSize() + " " + this.tr("EduCommandHandler.undoesLeft"));
    }

    private void cmd_undoPlayerBlockDig(MinecraftServer minecraftServer, mw player, int undoableBlockAmount) {
        for (int kk = 0; kk < undoableBlockAmount; ++kk) {
            if (this.getCallerEntity().playerabilities.undoDigList.getUndoListSize() == 0) {
                this.sendMsgToCaller("\u00a7c" + this.tr("EduCommandHandler.undoDigListEmpty"));
                return;
            }
            EduBlockContainer curBlock = this.getCallerEntity().playerabilities.undoDigList.getLastContainerFromUndoListAndRemove();
            for (int i = 0; i < curBlock.getBlockList().size(); ++i) {
                EduBlockStore loopBlock = curBlock.getBlockList().get(i);
                minecraftServer.getWorldManager(loopBlock.dimension).d(loopBlock.x, loopBlock.y, loopBlock.z, loopBlock.block, loopBlock.meta, 2);
            }
        }
        this.sendMsgToCaller("\u00a72" + this.tr("EduCommandHandler.undoDigCompleted") + " " + this.getCallerEntity().playerabilities.undoDigList.getUndoListSize() + " " + this.tr("EduCommandHandler.undoesLeft"));
    }

    private void cmd_undoPlayerFill(MinecraftServer minecraftServer, mw player, int undoableBlockAmount) {
        for (int kk = 0; kk < undoableBlockAmount; ++kk) {
            if (this.getCallerEntity().playerabilities.undoFillList.getUndoListSize() == 0) {
                this.sendMsgToCaller("\u00a7c" + this.tr("EduCommandHandler.undoFillListEmpty"));
                return;
            }
            EduBlockContainer curBlock = this.getCallerEntity().playerabilities.undoFillList.getLastContainerFromUndoListAndRemove();
            for (int i = 0; i < curBlock.getBlockList().size(); ++i) {
                EduBlockStore loopBlock = curBlock.getBlockList().get(i);
                minecraftServer.getWorldManager(loopBlock.dimension).d(loopBlock.x, loopBlock.y, loopBlock.z, loopBlock.block, loopBlock.meta, 2);
            }
        }
        this.sendMsgToCaller("\u00a72" + this.tr("EduCommandHandler.undoFillCompleted") + " " + this.getCallerEntity().playerabilities.undoFillList.getUndoListSize() + " " + this.tr("EduCommandHandler.undoesLeft"));
    }
}

