/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.util.ArrayList;
import mcedu.EduAccessHelperServer;
import mcedu.forgemod.network.EduAssignmentUtilMessage;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.server.EduAssignment;
import mcedu.server.EduAssignmentHelper;
import mcedu.server.EduCommandBase;
import mcedu.server.EduExceptionParameterOutOfRange;

public class EduCmdAssignments
extends EduCommandBase {
    public String c() {
        return "eduassignments";
    }

    @Override
    public void handleEduCommand() throws EduExceptionParameterOutOfRange {
        String par0 = this.getArgStr(0);
        if (par0.equals("openadminguiassignments")) {
            this.cmd_openAdminGuiAssignments(this.getCallerEntity(), this.getMcServer().ah());
        } else if (par0.equals("openadminguieditorviewassignment")) {
            this.cmd_openAdminGuiViewOrEditAssignments(this.getCallerEntity(), this.getMcServer().ah(), this.getArgStr(1));
        } else if (par0.equals("removeassignment")) {
            this.cmd_removeAssignment(this.getCallerEntity(), this.getMcServer().ah(), this.getArgStr(1));
        } else if (par0.equals("modifyassignment")) {
            this.cmd_modifyAssignment(this.getCallerEntity(), this.getMcServer().ah(), this.getArgStr(1), this.getArgStr(2), this.getArgStr(3));
        } else if (par0.equals("addassignment")) {
            this.cmd_addAssignment(this.getCallerEntity(), this.getMcServer().ah(), this.getArgStr(1), this.getArgStr(2));
        } else if (par0.equals("toggleassignmentcompleted")) {
            this.cmd_toggleAssignmentCompleted(this.getCallerEntity(), this.getMcServer().ah(), this.getArgStr(1));
        } else if (par0.equals("getassignmentcompleteamount")) {
            this.cmd_getAssignmentCompleteAmount(this.getCallerEntity(), this.getMcServer().ah());
        } else {
            throw new cd("This EDU user command was not found.", new Object[0]);
        }
    }

    @Override
    public void handleEduCommand(mw player) throws EduExceptionParameterOutOfRange {
    }

    @Override
    public void handleEduCommand(mw player, boolean value) throws EduExceptionParameterOutOfRange {
    }

    private void cmd_openAdminGuiAssignments(mw player, oi serverConfigurationManager) {
        ArrayList<EduAssignment> assignments = EduAssignmentHelper.getAllAssignments();
        String assignmentData = "";
        String teachers = "";
        int studentAmount = 0;
        for (int i = 0; i < EduAccessHelperServer.getServerConfigurationManager().e.size(); ++i) {
            if (!((mw)EduAccessHelperServer.getServerConfigurationManager().e.get((int)i)).playerIsAdmin) {
                ++studentAmount;
                continue;
            }
            teachers = teachers + ((mw)EduAccessHelperServer.getServerConfigurationManager().e.get((int)i)).username + ",";
        }
        if (teachers.isEmpty()) {
            teachers = ",";
        }
        assignmentData = String.valueOf(studentAmount) + "<te>" + teachers;
        if (assignments != null) {
            for (EduAssignment assignment : assignments) {
                assignmentData = assignmentData + "<|>" + assignment.title + "<id>" + assignment.id + "<de>" + assignment.description + "<co>" + assignment.getCompletersAsString();
            }
        }
        EduNetworkUtils.sendToPlayer(new EduAssignmentUtilMessage("MCEDU|assignmentlist", assignmentData.getBytes()), player);
    }

    private void cmd_openAdminGuiViewOrEditAssignments(mw player, oi serverConfigurationManager, String assignmentId) {
        ArrayList<EduAssignment> assignments = EduAssignmentHelper.getAllAssignments();
        String assignmentData = "";
        for (EduAssignment assignment : assignments) {
            if (assignment.id != Integer.parseInt(assignmentId)) continue;
            assignmentData = "<br>" + assignment.title + "<de>" + assignment.description + "<id>" + assignment.id;
            EduNetworkUtils.sendToPlayer(new EduAssignmentUtilMessage("MCEDU|assignmentdesc", assignmentData.getBytes()), player);
        }
    }

    private void cmd_removeAssignment(mw player, oi serverConfigurationManager, String assignmentId) {
        EduAssignmentHelper.removeAssignment(Integer.valueOf(assignmentId));
        this.cmd_openAdminGuiAssignments(player, serverConfigurationManager);
    }

    private void cmd_modifyAssignment(mw player, oi serverConfigurationManager, String assignmentId, String assignmentTitle, String assignmentDescription) {
        EduAssignmentHelper.modifyAssignment(Integer.parseInt(assignmentId), assignmentTitle, assignmentDescription);
    }

    private void cmd_addAssignment(mw player, oi serverConfigurationManager, String assignmentTitle, String assignmentDescription) {
        EduAssignmentHelper.addAssignment(assignmentTitle, assignmentDescription, "", true);
    }

    private void cmd_toggleAssignmentCompleted(mw player, oi serverConfigurationManager, String id) {
        if (!player.playerIsAdmin) {
            if (EduAssignmentHelper.isUserCompleted(player.username, Integer.valueOf(id))) {
                EduAssignmentHelper.removeCompleter(Integer.valueOf(id), player.username);
            } else {
                EduAssignmentHelper.addCompleter(Integer.valueOf(id), player.username);
            }
        }
        EduAssignmentHelper.refreshAssignmentForPlayer(player);
        this.cmd_openAdminGuiAssignments(player, serverConfigurationManager);
    }

    private void cmd_getAssignmentCompleteAmount(mw player, oi serverConfigurationManager) {
        if (!player.playerIsAdmin) {
            String assignmentData = String.valueOf(EduAssignmentHelper.getCompletedAssignmentAmount(player));
            assignmentData = assignmentData + "/" + String.valueOf(EduAssignmentHelper.getAllAssignments().size());
            EduNetworkUtils.sendToPlayer(new EduAssignmentUtilMessage("MCEDU|asscompamount", assignmentData.getBytes()), player);
        }
    }
}

