/*
 * Decompiled with CFR 0.152.
 */
package mcedu.server;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import mcedu.EduAccessHelperServer;
import mcedu.forgemod.network.EduAssignmentUtilMessage;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.global.tools.CustomTextArea;
import mcedu.global.tools.CustomTextfield;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.MessageBox;
import mcedu.server.EduAssignment;
import mcedu.server.EduServerSettings;

public class EduAssignmentHelper {
    public static ArrayList<EduAssignment> assignments = new ArrayList();
    public static EduAssignment selectedAssignment;
    public static final int ADD = 0;
    public static final int MODIFY = 1;

    public static void loadAssignmentData() {
        try {
            ArrayList rawData = (ArrayList)Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathAssignmentData);
            if (rawData == null || rawData.size() == 0) {
                return;
            }
            String currentTitle = "";
            String currentDescription = "";
            String currentCompleters = "";
            int lastId = Character.getNumericValue(((String)rawData.get(rawData.size() - 1)).charAt(0));
            for (int i = 0; i < lastId + 1; ++i) {
                currentTitle = Datahandler.iniGet(EduServerSettings.getS().pathAssignmentData, String.valueOf(i) + "_title");
                currentDescription = Datahandler.iniGet(EduServerSettings.getS().pathAssignmentData, String.valueOf(i) + "_description");
                currentCompleters = Datahandler.iniGet(EduServerSettings.getS().pathAssignmentData, String.valueOf(i) + "_completors");
                EduAssignmentHelper.addAssignment(currentTitle, currentDescription, currentCompleters, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<EduAssignment> getAllAssignments() {
        return assignments;
    }

    public static void saveAssignmentDataToFile() {
        Datahandler.removeAllLinesFromFile(EduServerSettings.getS().pathAssignmentData);
        for (EduAssignment assignment : assignments) {
            Datahandler.iniSet(EduServerSettings.getS().pathAssignmentData, assignment.id + "_title", assignment.title);
            Datahandler.iniSet(EduServerSettings.getS().pathAssignmentData, assignment.id + "_description", assignment.description);
            Datahandler.iniSet(EduServerSettings.getS().pathAssignmentData, assignment.id + "_completors", assignment.getCompletersAsString() == null ? "" : assignment.getCompletersAsString());
            Datahandler.iniSet(EduServerSettings.getS().pathAssignmentData, assignment.id + "_displayid", String.valueOf(assignment.displayId));
        }
    }

    public static void addAssignment(String title, String description, String completers, boolean refresh) {
        assignments.add(new EduAssignment(assignments.size(), assignments.size(), title, description, completers));
        if (refresh) {
            EduAssignmentHelper.refreshAssignmentsForEveryOne();
        }
    }

    public static void removeAssignment(int id) {
        for (int i = 0; i < assignments.size(); ++i) {
            if (EduAssignmentHelper.assignments.get((int)i).id != id) continue;
            assignments.remove(i);
        }
        EduAssignmentHelper.updateAssignmentIds();
        EduAssignmentHelper.refreshAssignmentsForEveryOne();
    }

    public static void modifyAssignment(int id, String title, String description) {
        for (int i = 0; i < assignments.size(); ++i) {
            if (EduAssignmentHelper.assignments.get((int)i).id != id) continue;
            EduAssignmentHelper.assignments.get((int)i).title = title;
            EduAssignmentHelper.assignments.get((int)i).description = description;
        }
    }

    public static void addCompleter(int id, String completer) {
        for (int i = 0; i < assignments.size(); ++i) {
            if (EduAssignmentHelper.assignments.get((int)i).id != id) continue;
            EduAssignmentHelper.assignments.get((int)i).completersList.add(completer);
        }
    }

    public static void removeCompleter(int id, String completer) {
        for (int i = 0; i < assignments.size(); ++i) {
            if (EduAssignmentHelper.assignments.get((int)i).id != id) continue;
            for (int j = 0; j < EduAssignmentHelper.assignments.get((int)i).completersList.size(); ++j) {
                if (!EduAssignmentHelper.assignments.get((int)i).completersList.get(j).equals(completer)) continue;
                EduAssignmentHelper.assignments.get((int)i).completersList.remove(j);
            }
        }
    }

    public static void updateAssignmentIds() {
        for (int i = 0; i < assignments.size(); ++i) {
            EduAssignmentHelper.assignments.get((int)i).id = i;
        }
    }

    public static boolean isUserCompleted(String username, int id) {
        for (int i = 0; i < assignments.size(); ++i) {
            if (EduAssignmentHelper.assignments.get((int)i).id != id) continue;
            for (int j = 0; j < EduAssignmentHelper.assignments.get((int)i).completersList.size(); ++j) {
                if (!EduAssignmentHelper.assignments.get((int)i).completersList.get(j).equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeUserFromAllAssignmentsCompleters(mw player) {
        for (EduAssignment assignment : assignments) {
            EduAssignmentHelper.removeCompleter(assignment.id, player.username);
        }
    }

    public static int getCompletedAssignmentAmount(mw player) {
        int amount = 0;
        for (EduAssignment assignment : assignments) {
            if (!EduAssignmentHelper.isUserCompleted(player.username, assignment.id)) continue;
            ++amount;
        }
        return amount;
    }

    public static void refreshAssignmentsForEveryOne() {
        EduNetworkUtils.sendToAllPlayers(new EduAssignmentUtilMessage("MCEDU|assrefresh", new String("").getBytes()));
    }

    public static void refreshAssignmentForPlayer(mw player) {
        EduNetworkUtils.sendToPlayer(new EduAssignmentUtilMessage("MCEDU|assrefresh", new String("").getBytes()), player);
    }

    public static void convertOldAssignment() {
        String oldAssignmentTitle = EduServerSettings.getS().settingsWorldHandler.getOldSingleAssignmentTitle();
        String oldAssignmentDesc = EduServerSettings.getS().settingsWorldHandler.getOldSingleAssignmentDescription();
        if (!oldAssignmentTitle.isEmpty()) {
            ArrayList<String> returnArrayList = new ArrayList<String>();
            String helpTemp = "";
            while (oldAssignmentDesc.length() > 35) {
                helpTemp = oldAssignmentDesc.substring(0, 35);
                returnArrayList.add(helpTemp.substring(0, helpTemp.lastIndexOf(" ")));
                oldAssignmentDesc = oldAssignmentDesc.substring(helpTemp.lastIndexOf(" ") + 1);
                if (helpTemp.lastIndexOf(" ") != -1) continue;
            }
            returnArrayList.add(oldAssignmentDesc);
            oldAssignmentDesc = "";
            for (String temp : returnArrayList) {
                oldAssignmentDesc = oldAssignmentDesc + temp + "<br>";
            }
            EduAssignmentHelper.addAssignment(oldAssignmentTitle, oldAssignmentDesc, "", false);
            EduServerSettings.getS().settingsWorldHandler.removeOldSingleLineAssignment();
        }
    }

    public static String addLineBreaksToServerSetAssignmentDescription(String description) {
        ArrayList<String> returnArrayList = new ArrayList<String>();
        String helpTemp = "";
        while (description.length() > 35) {
            helpTemp = description.substring(0, 35);
            returnArrayList.add(helpTemp.substring(0, helpTemp.lastIndexOf(" ")));
            description = description.substring(helpTemp.lastIndexOf(" ") + 1);
            if (helpTemp.lastIndexOf(" ") != -1) continue;
        }
        returnArrayList.add(description);
        description = "";
        for (String temp : returnArrayList) {
            description = description + temp + "<br>";
        }
        return description;
    }

    public static String getCompleterAmount(int id) {
        List players = EduAccessHelperServer.getServerConfigurationManager().e;
        int amount = 0;
        for (int i = 0; i < players.size(); ++i) {
            if (!EduAssignmentHelper.assignments.get((int)id).completersList.contains(((mw)players.get((int)i)).username)) continue;
            ++amount;
        }
        return String.valueOf(amount);
    }

    public static String getStudentAmountOnServer() {
        List players = EduAccessHelperServer.getServerConfigurationManager().e;
        int amount = 0;
        for (int i = 0; i < players.size(); ++i) {
            if (((mw)players.get((int)i)).playerIsAdmin) continue;
            ++amount;
        }
        return String.valueOf(amount);
    }

    public static void handleServerAddAssignment() {
        JPanel panel = EduAssignmentHelper.createJPanel(0);
        int result = JOptionPane.showConfirmDialog(null, panel, de.a().a("EduAssignmentHelper.AddNewAssignment"), 2, -1);
        if (result == 0) {
            try {
                if (!((JTextField)panel.getComponent(1)).getText().isEmpty() && !((JTextArea)panel.getComponent(3)).getText().isEmpty()) {
                    EduAssignmentHelper.addAssignment(((JTextField)panel.getComponent(1)).getText(), EduAssignmentHelper.addLineBreaksToServerSetAssignmentDescription(((JTextArea)panel.getComponent(3)).getText()), "", false);
                } else {
                    MessageBox.notice("Error", "Please fill all info");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void handleServerModifyAssignment() {
        JPanel panel = EduAssignmentHelper.createJPanel(1);
        int result = JOptionPane.showConfirmDialog(null, panel, de.a().a("EduAssignmentHelper.ModifyAssignment"), 2, -1);
        if (result == 0) {
            if (!((JTextField)panel.getComponent(1)).getText().isEmpty() && !((JTextArea)panel.getComponent(3)).getText().isEmpty()) {
                EduAssignmentHelper.modifyAssignment(EduAssignmentHelper.selectedAssignment.id, ((JTextField)panel.getComponent(1)).getText(), EduAssignmentHelper.addLineBreaksToServerSetAssignmentDescription(((JTextArea)panel.getComponent(3)).getText()));
            } else {
                MessageBox.notice("Notice", "EduAssignmentHelper.PleaseFillAllInfo");
            }
        }
    }

    public static JPanel createJPanel(int type) {
        CustomTextfield title = new CustomTextfield(39);
        title.setMinimumSize(new Dimension(280, 24));
        title.setMaximumSize(new Dimension(280, 24));
        title.setAlignmentX(0.0f);
        CustomTextArea description = new CustomTextArea(140);
        description.setMinimumSize(new Dimension(280, 100));
        description.setMaximumSize(new Dimension(280, 100));
        description.setLineWrap(true);
        description.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        UIManager UI = new UIManager();
        UIManager.put("OptionPane.background", new ColorUIResource(178, 196, 211));
        UIManager.put("Panel.background", new ColorUIResource(178, 196, 211));
        UIManager.put("Button.background", new ColorUIResource(178, 196, 211));
        panel.setBackground(new Color(178, 196, 211));
        panel.setPreferredSize(new Dimension(300, 170));
        panel.add(new JLabel("Title"));
        panel.add(title);
        panel.add(new JLabel("Description"));
        panel.add(description);
        if (type == 1) {
            title.setText(EduAssignmentHelper.selectedAssignment.title);
            description.setText(EduAssignmentHelper.selectedAssignment.description.replace("<br>", ""));
        }
        return panel;
    }
}

