/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.tools;

import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import mcedu.global.localization.Localization;
import mcedu.global.swing.SwingHelper;
import mcedu.global.tools.Debug;

public abstract class MessageBox {
    public static void notice(String title, String message) {
        try {
            JOptionPane.showMessageDialog(null, Localization.getS().tr(message), Localization.getS().tr(title), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void notice(String title, String message, String additionalText) {
        try {
            JOptionPane.showMessageDialog(null, Localization.getS().tr(message) + " " + additionalText, Localization.getS().tr(title), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String input(String title, String description) {
        try {
            return JOptionPane.showInputDialog(null, Localization.getS().tr(description), Localization.getS().tr(title), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String inputPassword(String title, String description, boolean showCancelButton) {
        try {
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, 3));
            JPasswordField password = new JPasswordField(15);
            jpanel.add(new JLabel(Localization.getS().tr(description)));
            jpanel.add(password);
            if (showCancelButton) {
                int action = JOptionPane.showConfirmDialog(null, jpanel, Localization.getS().tr(title), -1);
            } else {
                int action = JOptionPane.showConfirmDialog(null, jpanel, Localization.getS().tr(title), 2);
            }
            return new String(password.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Deprecated
    public static void error(String message, String optionalDetailedErrorMessage) {
        try {
            MessageBox.error(null, message, optionalDetailedErrorMessage, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void error(String errorCode, String message, String optionalDetailedErrorMessage) {
        try {
            MessageBox.error(errorCode, message, optionalDetailedErrorMessage, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void error(String errorCode, String errorMessage, String optionalDetailedErrorMessage, Exception exception) {
        try {
            String errorMsg = "";
            errorMsg = "<b>" + MessageBox.tr("ThereWasError") + "<br><br>";
            if (errorCode != null && errorCode.equals("")) {
                errorMsg = errorMsg + "<b>" + MessageBox.tr("ErrorCode") + "</b>: " + errorCode + "<br>";
            }
            if (errorMessage != null && !errorMessage.equals("")) {
                errorMsg = errorMsg + "<b>" + MessageBox.tr("ErrorMessage") + "</b>: " + errorMessage + "<br>";
            }
            if (optionalDetailedErrorMessage != null && !optionalDetailedErrorMessage.equals("")) {
                errorMsg = errorMsg + "<b>" + MessageBox.tr("DetailedError") + "</b>: " + optionalDetailedErrorMessage + "<br>";
            }
            if (exception != null) {
                errorMsg = errorMsg + "<b>Exception</b>: " + exception.toString();
                errorMsg = errorMsg + "<br><b>Exception Message</b>: " + exception.getMessage();
            }
            errorMsg = errorMsg + "<br><br><b>" + MessageBox.tr("ErrorLocation") + "</b><br>" + Debug.getStackCall("<br>");
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new BoxLayout(jpanel, 3));
            JEditorPane pane = new JEditorPane();
            SwingHelper.changeComponentSize(pane, 500, 300);
            pane.setContentType("text/html");
            pane.setText(errorMsg);
            pane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(pane);
            SwingHelper.changeComponentSize(scrollPane, 500, 300);
            jpanel.add(scrollPane);
            JOptionPane.showMessageDialog(null, jpanel, "Error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void criticalError(String message, String optionalDetailedErrorMessage) {
        String errorMsg = "";
        String errorCode = "1";
        errorMsg = optionalDetailedErrorMessage.equals("") ? "Critical error occurred. Shutting down application.\nError code: " + errorCode + "\n" + "Error message" + ": " + message : "Critical error occurred. Shutting down application.\nError code: " + errorCode + "\n" + "Error message" + ": " + message + ".\n" + "Detailed error message" + ": " + optionalDetailedErrorMessage;
        try {
            JOptionPane.showMessageDialog(null, errorMsg, MessageBox.tr("Error"), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static int confirmDialog(String title, String content) {
        try {
            Object[] options = new Object[]{MessageBox.tr("Yes"), MessageBox.tr("No")};
            JFrame frame = new JFrame();
            frame.requestFocus();
            frame.setAlwaysOnTop(true);
            int result = 100;
            result = JOptionPane.showOptionDialog(frame, "<html>" + Localization.getS().tr(content) + "</html>", Localization.getS().tr(title), -1, 2, null, options, options[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int confirmDialog(String title, String content, String yesButtonText, String noButtonText) {
        try {
            Object[] options = new Object[]{MessageBox.tr(yesButtonText), MessageBox.tr(noButtonText)};
            JFrame frame = new JFrame();
            frame.requestFocus();
            frame.setAlwaysOnTop(true);
            int result = 100;
            result = JOptionPane.showOptionDialog(frame, "<html>" + Localization.getS().tr(content) + "</html>", Localization.getS().tr(title), -1, 2, null, options, options[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int confirmDialog(String title, String content, String yesButtonText, String noButtonText, String cancelButtonText) {
        try {
            Object[] options = new Object[]{MessageBox.tr(yesButtonText), MessageBox.tr(noButtonText), MessageBox.tr(cancelButtonText)};
            JFrame frame = new JFrame();
            frame.requestFocus();
            frame.setAlwaysOnTop(true);
            int result = 100;
            result = JOptionPane.showOptionDialog(frame, Localization.getS().tr(content), Localization.getS().tr(title), -1, 2, null, options, options[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static String tr(String str) {
        return Localization.getS().tr(str);
    }
}

