/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.tools;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import mcedu.global.Application;
import mcedu.global.tools.MessageBox;

public class LockFile {
    private static File lockFile;
    private static FileChannel channel;
    private static FileLock lock;

    public static void createLockFile(File pathToLockFile) {
        if (lockFile != null) {
            System.out.println("You have already generated lock file: " + lockFile.getAbsolutePath());
            return;
        }
        lockFile = pathToLockFile;
        try {
            if (lockFile.exists()) {
                lockFile.delete();
            }
            if ((lock = (channel = new RandomAccessFile(lockFile, "rw").getChannel()).tryLock()) == null) {
                channel.close();
                MessageBox.error("001", "You tried to start another " + Application.getApplicationName() + ", but only one instance can run simultaneously.", "");
                System.exit(0);
            }
            ShutdownHook shutdownHook = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unlockFile() {
        try {
            if (lock != null) {
                lock.release();
                channel.close();
                lockFile.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            LockFile.unlockFile();
        }
    }
}

