/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.tools;

import java.util.HashSet;

public class Debug {
    public static String TYPE_SIGN = "sign";
    private static boolean debuggingEnabled = true;
    private static HashSet<String> enabledDebugMessageTypes = new HashSet();

    public static void addDebugMessage(String type, String message) {
        if (!debuggingEnabled) {
            return;
        }
        if (!enabledDebugMessageTypes.contains(type.toLowerCase())) {
            return;
        }
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        System.out.println("Debug message type: " + type + " and msg: " + message + " ( " + stackTraces[2] + " )");
    }

    public static String getStackCall(String delimiter) {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String returnString = "";
        for (int i = 0; i < stackTraces.length; ++i) {
            if (i <= 2) continue;
            returnString = returnString + stackTraces[i].toString() + delimiter;
        }
        return returnString;
    }

    public static void printDebug(Object message) {
        try {
            System.out.println(message + Debug.getStackCall("\n"));
        }
        catch (Exception e) {
            System.out.println("Error printing debug message: " + message);
            e.printStackTrace();
        }
    }

    public static void printStackTrace() {
        System.out.println(Debug.getStackCall("\n"));
    }
}

