/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.tools;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import mcedu.global.localization.Localization;
import mcedu.global.process.JavaProcess;
import mcedu.global.process.JavaProcessLauncher;
import mcedu.global.threads.ThreadOpenURL;
import mcedu.global.tools.DownloadMonitorInterface;
import mcedu.global.tools.GetOS;
import mcedu.global.tools.MessageBox;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class Datahandler {
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final String lineBreak = System.getProperty("line.separator");
    public static ArrayList<File> zipFileList = new ArrayList();

    public static String getResourceAsString(String pathToResource, String encoding) throws FileNotFoundException, Exception {
        int bufferUsed;
        InputStream in = Class.forName(Datahandler.class.getName()).getClass().getResourceAsStream(pathToResource);
        if (in == null) {
            throw new FileNotFoundException("Resource not found, was null.");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bufferUsed = in.read(buffer)) > 0) {
            bout.write(buffer, 0, bufferUsed);
        }
        in.close();
        return new String(bout.toByteArray(), "UTF-8");
    }

    public static double calculateClassResourceSize(String pathToResource) {
        try {
            int bufferUsed;
            InputStream in = Class.forName(Datahandler.class.getName()).getClass().getResourceAsStream(pathToResource);
            if (in == null) {
                throw new FileNotFoundException("Resource not found, was null.");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int calculatedSize = 0;
            while ((bufferUsed = in.read(buffer)) > 0) {
                bout.write(buffer, 0, bufferUsed);
                calculatedSize += 1024;
            }
            in.close();
            return calculatedSize / 1024 / 1024;
        }
        catch (Exception e) {
            System.out.println("Error calculating resource size: " + pathToResource);
            e.printStackTrace();
            return 0.0;
        }
    }

    public static void validateFolderName(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException(Localization.getS().tr("validateFolderCannotBeEmpty"));
        }
        if (folderName.startsWith(" ") || folderName.startsWith(".") || folderName.endsWith(" ") || folderName.endsWith(".")) {
            throw new IOException(Localization.getS().tr("validateFolderCannotStartOrEndWith"));
        }
        if (folderName.startsWith(".")) {
            throw new IOException(Localization.getS().tr("validateFolderCannotStartWithDot"));
        }
        if (folderName.length() > 32) {
            throw new IOException(Localization.getS().tr("validateFolderTooLong"));
        }
        if (!folderName.matches("^[a-zA-Z0-9 ._-]+$")) {
            throw new IOException(Localization.getS().tr("validateFolderContainsInvalidCharacters"));
        }
    }

    public static void launchJarFile(File pathToFolder, String jarFileToLaunch, String xmxRam, String xmsRam, String[] arguments) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-Xmx" + xmxRam + "M");
        commands.add("-jar");
        commands.add(jarFileToLaunch);
        if (arguments != null) {
            commands.addAll(Arrays.asList(arguments));
        }
        String[] ar = commands.toArray(new String[commands.size()]);
        Datahandler.launchExternalProgram(pathToFolder, ar);
    }

    public static void launchExternalProgram(File pathToLaunchFolder, String[] arguments) throws Exception {
        ArrayList processParams = new ArrayList();
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(null, new String[0]);
        processLauncher.directory(pathToLaunchFolder);
        for (String arg : arguments) {
            processLauncher.addCommands(arg);
        }
        JavaProcess process = processLauncher.start();
    }

    public static void openFolder(String pathToFolder) {
        File file = new File(pathToFolder);
        if (!file.exists()) {
            MessageBox.notice("Could not find folder to open.", "<html>Could not find folder to open.<br>Folder should be here: " + pathToFolder + "</html>");
            return;
        }
        if (GetOS.getOS() == 2) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", pathToFolder});
                return;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        } else if (GetOS.getOS() == 0) {
            String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", pathToFolder);
            try {
                Runtime.getRuntime().exec(s1);
                return;
            }
            catch (IOException ioexception1) {
                ioexception1.printStackTrace();
            }
        }
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, file.toURI());
            return;
        }
        catch (Throwable throwable) {
            try {
                Desktop.getDesktop().open(new File(pathToFolder));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageBox.notice("Could not open folder", "Could not open folder: " + pathToFolder);
                return;
            }
        }
    }

    public static void openURL(String url) {
        ThreadOpenURL threadOpenUrl = new ThreadOpenURL(url);
        threadOpenUrl.setPriority(10);
        threadOpenUrl.start();
    }

    public static void downloadFileFromURL(URL sourceFileURL, File destinationFile, DownloadMonitorInterface downloadMonitor) throws MalformedURLException, FileNotFoundException, IOException, Exception {
        if (destinationFile.isDirectory()) {
            IOException ex = new IOException("Destination file cannot be directory.");
            if (downloadMonitor != null) {
                downloadMonitor.downloadFinishedWithErrors(null);
            }
            throw ex;
        }
        File pathToFile = new File(destinationFile.getParent());
        if (!pathToFile.exists()) {
            pathToFile.mkdirs();
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int oneChar;
            URLConnection urlC = sourceFileURL.openConnection();
            int urlFileSize = urlC.getContentLength();
            is = sourceFileURL.openStream();
            System.out.flush();
            fos = new FileOutputStream(destinationFile.getAbsolutePath());
            int bufferSize = 512;
            byte[] data = new byte[bufferSize];
            int count = 0;
            if (downloadMonitor != null) {
                downloadMonitor.downloadStarted(sourceFileURL, destinationFile, destinationFile.getName(), urlFileSize);
            }
            while ((oneChar = is.read(data)) != -1) {
                fos.write(data, 0, oneChar);
                if (downloadMonitor != null && count % 750 == 0) {
                    downloadMonitor.updateDownloadState(urlFileSize, (double)count * (double)bufferSize, (double)urlFileSize - (double)(count * bufferSize), count * bufferSize * 100 / urlFileSize);
                }
                ++count;
            }
        }
        catch (Exception e) {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (downloadMonitor != null) {
                downloadMonitor.downloadFinishedWithErrors(e);
            }
            throw e;
        }
        if (is != null) {
            is.close();
        }
        if (fos != null) {
            fos.close();
        }
        if (downloadMonitor != null) {
            downloadMonitor.downloadFinishedWithoutErrors();
        }
    }

    public static void downloadFileFromURL(URL sourceFileURL, File destinationFile) throws MalformedURLException, FileNotFoundException, IOException, Exception {
        Datahandler.downloadFileFromURL(sourceFileURL, destinationFile, null);
    }

    public static String byteCountInHumanReadableFormat(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static boolean writeByteArrayToFile(String pathToFile, byte[] bytesToWrite) {
        try {
            File file = new File(pathToFile);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytesToWrite);
            fos.close();
        }
        catch (Exception e) {
            System.out.println("Error writing byte array to file: " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String calculateFileMd5Checksum(File pathToFile) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(pathToFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            while (count != -1) {
                count = ((InputStream)is).read(buffer);
                md.update(buffer);
            }
            ((InputStream)is).close();
            String result = "";
            byte[] b = md.digest();
            for (int i = 0; i < b.length; ++i) {
                result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] bytes = null;
        try {
            int offset;
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                System.out.println("File was too large for getting byte array of it: " + file.getAbsolutePath());
                ((InputStream)is).close();
                return null;
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                ((InputStream)is).close();
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
        }
        catch (Exception e) {
            System.out.println("Error getting file as byte array: " + e);
            e.printStackTrace();
        }
        return bytes;
    }

    public static byte[] getResourceAsByteArray(String resource) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c;
            InputStream bais = Datahandler.class.getResourceAsStream("//" + resource);
            while ((c = bais.read()) != -1) {
                baos.write(c);
            }
            bais.close();
            baos.close();
        }
        catch (Exception e) {
            System.out.println("Error getting image as byte array: " + e);
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static String iniGet(String pathToFile, String setting) {
        Properties ini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(pathToFile);
            ini.load(fis);
            fis.close();
            return ini.getProperty(setting);
        }
        catch (IOException ioerror) {
            System.out.println(ioerror);
            return "";
        }
    }

    public static void iniSet(String pathToFile, String setting, String settingValue) {
        Datahandler.iniSet(pathToFile, setting, settingValue, "=");
    }

    public static void iniSet(String pathToFile, String setting, String settingValue, String separator) {
        Datahandler.createFile(pathToFile);
        settingValue = StringEscapeUtils.escapeJava(settingValue);
        List data = Datahandler.readLinesFromFileToList(pathToFile);
        if (data != null) {
            String line = "";
            for (int i = 0; i < data.size(); ++i) {
                line = (String)data.get(i);
                if (line == null || line.equals("") || line.startsWith("#") || !line.startsWith(setting + separator)) continue;
                data.set(i, setting + separator + settingValue);
                Datahandler.writeLinesFromListToFile(pathToFile, data);
                return;
            }
        }
        data.add(setting + "=" + settingValue);
        Datahandler.writeLinesFromListToFile(pathToFile, data);
    }

    public static String iniGetAlternative(String pathToFile, String setting) {
        String returnString = "";
        String line = "";
        String[] split = new String[2];
        List listSettings = Datahandler.readLinesFromFileToList(pathToFile);
        for (Object lineob : listSettings) {
            line = lineob.toString();
            try {
                split = line.split("=");
                if (!split[0].equals(setting)) continue;
                returnString = line.replace(split[0] + "=", "");
            }
            catch (Exception e) {}
        }
        return StringEscapeUtils.unescapeJava(returnString);
    }

    public static void removeLineFromFile(String pathToFile, String lineToBeRemoved) {
        try {
            File inFile = new File(pathToFile);
            if (!inFile.isFile()) {
                System.out.println("Parameter is not an existing file");
                return;
            }
            File tempFile = new File(inFile.getAbsolutePath() + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(pathToFile));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals(lineToBeRemoved)) continue;
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!inFile.delete()) {
                System.out.println("Could not delete file.");
                return;
            }
            if (!tempFile.renameTo(inFile)) {
                System.out.println("Could not rename file.");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void removeLineFromFileThatStartsWith(String pathToFile, String lineStartToRemove) {
        try {
            File inFile = new File(pathToFile);
            if (!inFile.isFile()) {
                System.out.println("Parameter is not an existing file");
                return;
            }
            File tempFile = new File(inFile.getAbsolutePath() + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(pathToFile));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(lineStartToRemove)) continue;
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!inFile.delete()) {
                System.out.println("Could not delete file.");
                return;
            }
            if (!tempFile.renameTo(inFile)) {
                System.out.println("Could not rename file.");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void removeAllLinesFromFile(String pathToFile) {
        try {
            File inFile = new File(pathToFile);
            if (!inFile.isFile()) {
                System.out.println("Parameter is not an existing file");
                return;
            }
            File tempFile = new File(inFile.getAbsolutePath() + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(pathToFile));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            Object line = null;
            pw.close();
            br.close();
            if (!inFile.delete()) {
                System.out.println("Could not delete file.");
                return;
            }
            if (!tempFile.renameTo(inFile)) {
                System.out.println("Could not rename file.");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Map<String, String> loadDataInMapFromFile(String fileName, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            FileInputStream in = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String nextLine = "";
            String[] splitData = new String[2];
            while (nextLine != null) {
                nextLine = br.readLine();
                if (nextLine == null) continue;
                try {
                    splitData = nextLine.split(separator);
                    if (splitData.length < 2) {
                        map.put(splitData[0], "");
                        continue;
                    }
                    map.put(splitData[0], splitData[1].replace("<|EQUALS|>", "="));
                }
                catch (Exception e) {}
            }
            in.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> loadDataInMapFromFile(String fileName, String separator, String characterEncoding) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            FileInputStream in = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, characterEncoding));
            String nextLine = "";
            String[] splitData = new String[2];
            while (nextLine != null) {
                nextLine = br.readLine();
                if (nextLine == null) continue;
                try {
                    splitData = nextLine.split(separator);
                    if (splitData.length < 2) {
                        map.put(splitData[0], "");
                        continue;
                    }
                    map.put(splitData[0], splitData[1].replace("<|EQUALS|>", "="));
                }
                catch (Exception e) {}
            }
            in.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> loadDataInMapFromFile(String fileName, String separator, String characterEncoding, String ignoredCommentStartFormat) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            FileInputStream in = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, characterEncoding));
            String nextLine = "";
            String[] splitData = new String[2];
            while (nextLine != null) {
                nextLine = br.readLine();
                if (nextLine == null || nextLine.startsWith(ignoredCommentStartFormat)) continue;
                try {
                    splitData = nextLine.split(separator);
                    if (splitData.length < 2) {
                        map.put(splitData[0], "");
                        continue;
                    }
                    map.put(splitData[0], splitData[1]);
                }
                catch (Exception e) {}
            }
            in.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void writeMapToFile(String filename, HashMap<String, String> data, String separator) {
        try {
            File f = new File(filename);
            f.createNewFile();
            FileWriter fw = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fw);
            String newline = System.getProperty("line.separator");
            for (String key : data.keySet()) {
                if (key == null || key.isEmpty()) continue;
                out.write(key + separator + data.get(key).replace("=", "<|EQUALS|>") + newline);
            }
            out.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeMapToFile(String filename, HashMap<String, String> data, String separator, String encoding) {
        try {
            File f = new File(filename);
            f.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f.getPath()), encoding);
            BufferedWriter out = new BufferedWriter(writer);
            String newline = System.getProperty("line.separator");
            for (String key : data.keySet()) {
                if (key == null || key.isEmpty()) continue;
                out.write(key + separator + data.get(key).replace("=", "<|EQUALS|>") + newline);
            }
            out.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeMapToFileWithComments(String filename, HashMap<String, String> data, String separator, HashMap<String, String> formattedComments, String formattedFileTitleContent) {
        try {
            File f = new File(filename);
            f.createNewFile();
            FileWriter fw = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fw);
            String newline = System.getProperty("line.separator");
            if (formattedFileTitleContent != null && !formattedFileTitleContent.isEmpty()) {
                out.write(formattedFileTitleContent + newline + newline);
            }
            for (String key : data.keySet()) {
                if (key == null || key.isEmpty()) continue;
                if (formattedComments.containsKey(key)) {
                    out.write(formattedComments.get(key) + newline);
                }
                out.write(key + separator + data.get(key) + newline + newline);
            }
            out.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List readLinesFromFileToList(String fileName) {
        List<Object> list = new ArrayList();
        try {
            File file = new File(fileName);
            Datahandler.createFile(fileName);
            list = FileUtils.readLines(file, "UTF-8");
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return list;
    }

    public static void writeLinesFromListToFile(String fileName, List list) {
        try {
            File file = new File(fileName);
            FileUtils.writeLines(file, "UTF-8", list);
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static boolean copyfile(String sourceFilePath, String targetFilePath) {
        try {
            int len;
            File f1 = new File(sourceFilePath);
            File f2 = new File(targetFilePath);
            if (!f1.exists()) {
                throw new FileNotFoundException("Copyable source file could not be found: " + f1.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void appendLineToFile(String pathToFile, String lineToWrite) {
        try {
            List list = Datahandler.readLinesFromFileToList(pathToFile);
            list.add(lineToWrite);
            Datahandler.writeLinesFromListToFile(pathToFile, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendToFile(String fileName, String textToWrite) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(textToWrite);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendLinesFromListToFile(List<String> listOfLines, String pathToFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(pathToFile, true));
            for (String line : listOfLines) {
                out.write(line);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean copyFolder(String sourceFolderPath, String targetFolderPath) {
        try {
            FileUtils.copyDirectory(new File(sourceFolderPath), new File(targetFolderPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void createFolder(String pathToFolder) {
        try {
            FileUtils.forceMkdir(new File(pathToFolder));
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static boolean createFile(String pathToFile) {
        try {
            File file = new File(pathToFile);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Could not create file: " + pathToFile);
            e.printStackTrace();
        }
        return false;
    }

    public static boolean removeFolder(String pathToFolder) {
        try {
            File folder = new File(pathToFolder);
            FileUtils.deleteDirectory(folder);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void loadExternalClassesToClasspath(HashMap<File, String> files) {
        String className = "";
        boolean loadOK = false;
        for (Map.Entry<File, String> entry : files.entrySet()) {
            loadOK = false;
            File file = entry.getKey();
            className = entry.getValue();
            try {
                Class.forName(className);
                loadOK = true;
            }
            catch (Exception e) {
                try {
                    if (!file.exists()) {
                        throw new IOException("File does not exist: " + file.getAbsolutePath());
                    }
                    if (!Datahandler.addURLToClasspath(file.toURI().toURL())) {
                        throw new Exception("Could not load class!");
                    }
                    System.out.println("Loaded class " + entry.getKey().getAbsolutePath() + " manually.");
                }
                catch (Exception ex) {
                    System.out.println("Error loading class " + entry.getKey().getAbsolutePath() + " to classpath. Error: " + ex.getMessage());
                }
            }
            if (!loadOK) continue;
            System.out.println("Class " + entry.getValue() + " has already been loaded to classpath succesfully. Sweet!");
        }
    }

    private static boolean addURLToClasspath(URL file) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, file);
        return true;
    }

    public static long getFolderSize(String pathToFile) {
        File[] files;
        File folder = new File(pathToFile);
        ArrayList<File> allfilesList = new ArrayList<File>();
        for (File f : files = folder.listFiles()) {
            File[] tmpFiles;
            if (!f.isDirectory()) {
                allfilesList.add(f);
                continue;
            }
            for (File fi : tmpFiles = f.listFiles()) {
                File[] tmpFiles2;
                if (!fi.isDirectory()) {
                    allfilesList.add(fi);
                    continue;
                }
                for (File fil : tmpFiles2 = fi.listFiles()) {
                    if (fil.isDirectory()) continue;
                    allfilesList.add(fil);
                }
            }
        }
        long size = 0L;
        for (File file : allfilesList) {
            if (file == null) continue;
            size += file.length();
        }
        return size;
    }

    public static boolean convertImage(String srcPath, String imageFormat, String dstPath) {
        try {
            String convertDest = dstPath.substring(0, dstPath.lastIndexOf("."));
            convertDest = convertDest + "." + imageFormat;
            File convertDestFile = new File(convertDest);
            if (!convertDestFile.exists()) {
                convertDestFile.mkdirs();
                convertDestFile.createNewFile();
            }
            ImageIO.write((RenderedImage)ImageIO.read(new File(srcPath)), imageFormat, new File(convertDest));
            return true;
        }
        catch (IOException e) {
            System.out.println("CATCH");
            e.printStackTrace();
            return false;
        }
    }

    public static void compressFolderToArchive(File pathToSourceFolder, File targetArchive, List<String> excludedFiles) throws Exception {
        if (!targetArchive.exists()) {
            targetArchive.getParentFile().mkdirs();
        }
        ArrayList<File> allfilesList = new ArrayList<File>();
        File[] files = pathToSourceFolder.listFiles();
        boolean addFileToList = true;
        for (File f : files) {
            File[] tmpFiles;
            if (!f.isDirectory()) {
                if (!Datahandler.checkIfFileExistsInList(f.getAbsolutePath(), excludedFiles)) {
                    allfilesList.add(f);
                    continue;
                }
                addFileToList = true;
                continue;
            }
            if (Datahandler.checkIfFileExistsInList(f.getAbsolutePath(), excludedFiles)) continue;
            for (File fi : tmpFiles = f.listFiles()) {
                File[] tmpFiles2;
                if (!fi.isDirectory()) {
                    if (!Datahandler.checkIfFileExistsInList(fi.getAbsolutePath(), excludedFiles)) {
                        allfilesList.add(fi);
                        continue;
                    }
                    addFileToList = true;
                    continue;
                }
                for (File fil : tmpFiles2 = fi.listFiles()) {
                    if (fil.isDirectory()) continue;
                    if (!Datahandler.checkIfFileExistsInList(fil.getAbsolutePath(), excludedFiles)) {
                        allfilesList.add(fil);
                        continue;
                    }
                    addFileToList = true;
                }
            }
        }
        File[] allfiles = allfilesList.toArray(files);
        long size = 0L;
        for (File file : allfiles) {
            if (file == null) continue;
            size += file.length();
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetArchive)));
        BufferedInputStream in = null;
        byte[] buffer = new byte[1024];
        for (File file : allfiles) {
            int count;
            if (file == null || file.length() <= 0L || file == targetArchive) continue;
            in = new BufferedInputStream(new FileInputStream(file), (int)file.length());
            out.putNextEntry(new ZipEntry(Datahandler.removeSrcPathFromFile(file.getAbsolutePath(), pathToSourceFolder.getAbsolutePath())));
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            out.closeEntry();
        }
        in.close();
        out.flush();
        out.close();
    }

    public static void compressFolderToArchive(File pathToSourceFolder, File targetArchive) throws Exception {
        if (!targetArchive.exists()) {
            targetArchive.getParentFile().mkdirs();
        }
        Datahandler.listFilesForFolder(pathToSourceFolder, true);
        long size = 0L;
        for (File file : zipFileList) {
            if (file == null) continue;
            size += file.length();
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetArchive)));
        BufferedInputStream in = null;
        byte[] buffer = new byte[1024];
        for (File file : zipFileList) {
            int count;
            if (file == null || file.length() <= 0L || file == targetArchive) continue;
            in = new BufferedInputStream(new FileInputStream(file), (int)file.length());
            out.putNextEntry(new ZipEntry(Datahandler.removeSrcPathFromFile(file.getAbsolutePath(), pathToSourceFolder.getAbsolutePath())));
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            out.closeEntry();
        }
        in.close();
        out.flush();
        out.close();
    }

    public static void listFilesForFolder(File folder, boolean clearList) {
        if (clearList) {
            zipFileList.clear();
        }
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                Datahandler.listFilesForFolder(fileEntry, false);
                continue;
            }
            zipFileList.add(fileEntry);
        }
    }

    private static String removeSrcPathFromFile(String fullPathToFile, String removablePath) {
        String replace2 = removablePath.replace("/", "\\");
        String replace3 = removablePath.replace("\\", "/");
        return fullPathToFile.replace(new File(removablePath).getAbsolutePath() + File.separator, "").replace(removablePath, "").replace(replace2, "").replace(replace3, "").replace("\\", "/");
    }

    public static String getContentFromWebpage(String urlAddress) throws MalformedURLException, IOException {
        String returnLines = "";
        byte[] b = new byte[1];
        URL u = new URL(urlAddress);
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        InputStreamReader isr = new InputStreamReader(con.getInputStream());
        BufferedReader bf = new BufferedReader(isr);
        String line = "";
        while ((line = bf.readLine()) != null) {
            returnLines = returnLines + line;
        }
        con.disconnect();
        bf.close();
        isr.close();
        return returnLines == null ? "" : returnLines;
    }

    public static boolean unzipFile(File fSourceZip, File destinationFolder) throws IOException {
        if (!destinationFolder.exists()) {
            System.out.println("Destination folder does not exist: " + destinationFolder);
            throw new IOException("Destination folder does not exist!");
        }
        String zipPath = fSourceZip.getParent();
        ZipFile zipFile = new ZipFile(fSourceZip);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            int b;
            ZipEntry entry = e.nextElement();
            File destinationFilePath = new File(destinationFolder.getAbsolutePath(), entry.getName());
            destinationFilePath.getParentFile().mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(destinationFilePath);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            while ((b = bis.read(buffer, 0, 1024)) != -1) {
                bos.write(buffer, 0, b);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
        zipFile.close();
        return true;
    }

    public static boolean checkIfFileExistsInList(String filename, List<String> list) {
        for (String listFileName : list) {
            if (!listFileName.equalsIgnoreCase(filename)) continue;
            return true;
        }
        return false;
    }

    public static String addDelimitersForLongString(String text, int maxLineLength, String delimiter) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String[] words = text.split("");
        String returnString = "";
        int i = 0;
        for (String letter : words) {
            if (i == maxLineLength) {
                i = 0;
                returnString = returnString + delimiter;
            }
            returnString = returnString + letter;
            ++i;
        }
        return returnString;
    }

    public static boolean checkReadWritePermissionToFolder(File folder) {
        return folder.canRead() && folder.canWrite();
    }

    public static void copyStringToClipBoard(String text) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            StringSelection strSel = new StringSelection(text);
            clipboard.setContents(strSel, null);
        }
        catch (Exception e) {
            System.out.println("Could not copy text to clipboard");
        }
    }

    public static String getCurrentTimeStamp() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        String strDate = sdfDate.format(now);
        String timeZone = TimeZone.getDefault().getDisplayName();
        return strDate + " (" + timeZone + ")";
    }

    public static String getExternalIPAddress() {
        String ip = "";
        try {
            ip = Datahandler.getContentFromWebpage("http://checkip.amazonaws.com/");
        }
        catch (Exception e) {
            ip = "COULD NOT GET EXTERNAL IP";
        }
        if (ip == null || ip.isEmpty()) {
            ip = "COULD NOT GET EXTERNAL IP";
        }
        return ip;
    }
}

