/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.tools;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.Debug;

public abstract class AbstractSettingsHandler {
    private HashMap<String, String> settings = new HashMap();
    private HashMap<String, String> settingComments = new HashMap();
    public File pathToSettingsFile;
    private String missingSettingDefaultValue;
    private boolean settingsLoaded = false;
    private boolean commentsFormatted = false;

    public AbstractSettingsHandler(File pathToSettingsFile, String missingSettingDefaultValue) {
        this.pathToSettingsFile = pathToSettingsFile;
        this.missingSettingDefaultValue = missingSettingDefaultValue;
        this.init();
        this.storeComments();
        this.formatComments();
        this.loadSettings();
        this.saveSettingsToFile();
    }

    private void storeComments() {
        this.settingComments = this.getSettingComments();
    }

    private void formatComments() {
        if (this.commentsFormatted) {
            System.out.println("Tried to reformat comments. Skipping.");
            return;
        }
        HashMap<String, String> formattedComments = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.settingComments.entrySet()) {
            formattedComments.put(entry.getKey(), this.getFormattedComment(entry.getValue()).replace("=", ":"));
        }
        this.settingComments = formattedComments;
        this.commentsFormatted = true;
    }

    public String getMissingSettingDefaultValue() {
        return this.missingSettingDefaultValue;
    }

    public void loadSettings() {
        HashMap<String, String> missingSettings;
        if (!this.pathToSettingsFile.exists()) {
            System.out.println("Creating missing settings file: " + this.pathToSettingsFile);
            Datahandler.createFile(this.pathToSettingsFile.getAbsolutePath());
        }
        if ((missingSettings = this.getMissingSettings()).size() > 0) {
            for (Map.Entry<String, String> entry : missingSettings.entrySet()) {
                System.out.println("Appended setting: " + entry.getKey() + "=" + entry.getValue() + " to file: " + this.pathToSettingsFile.getAbsolutePath());
            }
        }
        this.settings = this.getCommentStartFormat() != null ? (HashMap)Datahandler.loadDataInMapFromFile(this.pathToSettingsFile.getAbsolutePath(), "=", "UTF-8", "#") : (HashMap)Datahandler.loadDataInMapFromFile(this.pathToSettingsFile.getAbsolutePath(), "=", "UTF-8");
        this.settings.putAll(missingSettings);
        this.settingsLoaded = true;
    }

    private HashMap<String, String> getMissingSettings() {
        HashMap<String, String> missingSettings = new HashMap<String, String>();
        HashMap<String, String> defSettings = this.getDefaultSettings();
        for (int j = 0; j < defSettings.size(); ++j) {
            for (String key : defSettings.keySet()) {
                try {
                    if (Datahandler.iniGet(this.pathToSettingsFile.getAbsolutePath(), key) != null) continue;
                    missingSettings.put(key, defSettings.get(key));
                }
                catch (Exception e) {
                    this.printError("Problem getting default setting: " + e.getMessage(), false);
                }
            }
        }
        return missingSettings;
    }

    public boolean hasSettingsBeenLoaded() {
        return this.settingsLoaded;
    }

    protected boolean saveSetting(String setting, String value) {
        if (!this.hasSettingsBeenLoaded()) {
            this.printError("Load settings before trying to save! Did try to save: " + setting + "=" + value, true);
            return false;
        }
        if (!this.settings.containsKey(setting)) {
            this.printError("Trying to set setting which does not exist: " + setting + " with value: " + value, false);
            return false;
        }
        this.settings.put(setting, value);
        this.saveSettingsToFile();
        this.loadSettings();
        return true;
    }

    private void saveSettingsToFile() {
        if (this.settingComments.size() > 0) {
            Datahandler.writeMapToFileWithComments(this.pathToSettingsFile.getAbsolutePath(), this.settings, "=", this.settingComments, this.getFileComment());
        } else {
            Datahandler.writeMapToFile(this.pathToSettingsFile.getAbsolutePath(), this.settings, "=");
        }
    }

    protected File getSettingsFile() {
        return this.pathToSettingsFile;
    }

    protected String getValueForSetting(String setting) {
        if (!this.hasSettingsBeenLoaded()) {
            this.printError("Load settings before trying to get value! Did try to get: " + setting, true);
            return this.missingSettingDefaultValue;
        }
        if (!this.settings.containsKey(setting)) {
            this.printError("Setting was missing: " + setting, false);
            return this.missingSettingDefaultValue;
        }
        if (this.settings.get(setting) == null) {
            return "";
        }
        return this.settings.get(setting);
    }

    protected boolean getValueForSettingAsBoolean(String setting, boolean defaultValue) {
        if (!this.hasSettingsBeenLoaded()) {
            this.printError("Load settings before trying to get value! Did try to get: " + setting, true);
            return defaultValue;
        }
        if (!this.settings.containsKey(setting)) {
            this.printError("Setting was missing: " + setting, false);
            return defaultValue;
        }
        if (this.settings.get(setting) == null) {
            return defaultValue;
        }
        try {
            boolean returnSetting = Boolean.parseBoolean(this.settings.get(setting));
            return returnSetting;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected int getValueForSettingAsInt(String setting, int defaultValue) {
        if (!this.hasSettingsBeenLoaded()) {
            this.printError("Load settings before trying to get value! Did try to get: " + setting, true);
            return defaultValue;
        }
        if (!this.settings.containsKey(setting)) {
            this.printError("Setting was missing: " + setting, false);
            return defaultValue;
        }
        if (this.settings.get(setting) == null) {
            return defaultValue;
        }
        try {
            int returnSetting = Integer.parseInt(this.settings.get(setting));
            return returnSetting;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void printError(String error, boolean printStackTrace) {
        System.out.println("Error in handling settings for file: " + this.pathToSettingsFile.getAbsolutePath() + ". Error description: " + error);
        if (printStackTrace) {
            Debug.printStackTrace();
        }
    }

    public String getFormattedComment(String comment) {
        return "# " + comment;
    }

    public String getCommentStartFormat() {
        return null;
    }

    public String getFileComment() {
        return null;
    }

    public HashMap<String, String> getSettingComments() {
        return new HashMap<String, String>();
    }

    public abstract HashMap<String, String> getDefaultSettings();

    public void init() {
    }
}

