/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.threads;

import java.awt.Desktop;
import java.net.URI;
import mcedu.global.tools.MessageBox;

public class ThreadOpenURL
extends Thread {
    private String url;

    public ThreadOpenURL(String url) {
        this.url = url;
    }

    @Override
    public void run() {
        if (!Desktop.isDesktopSupported()) {
            this.showError("Desktop is not supported. Cannot open URL.", "You can open your browser and manually go to address here: " + this.url);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            this.showError("Desktop browse is not supported. Cannot open URL.", "You can open your browser and manually go to address here: " + this.url);
            return;
        }
        try {
            URI uri = new URI(this.url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            this.showError("Cannot open browser. Error: " + e, "You can open your browser and manually go to address here: " + this.url);
        }
    }

    private void showError(String title, String content) {
        MessageBox.notice(title, content);
    }
}

