/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ToolTipManager;
import mcedu.global.localization.Localization;
import mcedu.global.localization.tools.Language;
import mcedu.global.swing.JFrameTemplate;

public class SwingHelper {
    public static void setTooltipDelayTime(int initialDelayTime, int missDelay) {
        ToolTipManager.sharedInstance().setInitialDelay(initialDelayTime);
        ToolTipManager.sharedInstance().setDismissDelay(missDelay);
    }

    public static void changeComponentSize(JComponent component, int width, int height) {
        component.setPreferredSize(new Dimension(width, height));
        component.setMinimumSize(new Dimension(width, height));
        component.setMaximumSize(new Dimension(width, height));
    }

    public static void addSupportedLanguagesToJmenu(JMenu menu, final JFrameTemplate guibase) {
        for (Language lang : Localization.getS().getAvailableLanguages()) {
            final int languageNumber = menu.getItemCount();
            JMenuItem menuItem = new JMenuItem();
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    guibase.languageChanged(languageNumber);
                }
            });
            menuItem.setName(lang.getLangName());
            menuItem.setText(lang.getLangName() + " (" + lang.getCountryShort() + ")");
            menuItem.setIcon(lang.getFlagImage());
            menu.add(menuItem);
        }
    }
}

