/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import mcedu.global.localization.Localization;
import mcedu.global.tools.GetOS;

public abstract class JFrameTemplate
extends JFrame
implements ActionListener {
    private Timer hidingLabelTimer = new Timer(1, this);
    private int hidingLabelCounter = 0;
    protected int hidingLabelFadeTime = 500;

    public JFrameTemplate() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void changeTheme(String themeName) {
    }

    public void hidingLabelStartAction() {
        this.hidingLabelTimer.stop();
        this.hidingLabelTimer.start();
    }

    public void hidingLabelStopAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.hidingLabelCounter == this.hidingLabelFadeTime) {
            this.hidingLabelTimer.stop();
            this.hidingLabelCounter = 0;
            this.hidingLabelStopAction();
        }
        SwingUtilities.invokeLater(new updateCount());
    }

    public void languageChanged(ActionEvent evt) {
        Localization.getS().setProgramLanguage(Localization.getS().getLanguage(evt.getActionCommand()));
    }

    public void languageChanged(int languageNumber) {
        Localization.getS().setProgramLanguage(Localization.getS().getAvailableLanguages().get(languageNumber));
    }

    public void openFrameNextToParentGUI(JFrame parentGUI) {
        this.translateComponents();
        if (GetOS.getOS() == 2) {
            this.setLocation(parentGUI.getLocation().x + parentGUI.getWidth() + 1, parentGUI.getLocation().y);
        } else {
            this.setLocation(parentGUI.getLocation().x + parentGUI.getWidth() + 8, parentGUI.getLocation().y);
        }
        super.setVisible(true);
    }

    public abstract void translateComponents();

    public class updateCount
    implements Runnable {
        @Override
        public void run() {
            JFrameTemplate.this.hidingLabelCounter += 1;
        }
    }
}

