/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.sharedcode.settinghandlers;

import java.io.File;
import java.util.HashMap;
import mcedu.global.tools.AbstractSettingsHandler;
import mcedu.global.tools.Security;

public class ServerWizardSettingsHandler
extends AbstractSettingsHandler {
    public static final String DEFAULT_SERVER_LAUNCH_PARAMETERS = "%JAVAEXEC% %PERFORMANCEPARAMS% -Xmx%RAM%M -Xms%RAM%M -jar %SERVERTYPE%_server.jar";
    public static final String DEFAULT_SERVERTYPE = "minecraftedu";
    public static String DEFAULT_SERVER_RAM = "1024";
    public static final String SERVER_TYPE_MINECRAFTEDU = "minecraftedu";
    public static final String SERVER_TYPE_MINECRAFT = "minecraft";
    public static final String SERVER_TYPE_CUSTOM = "custom";

    public ServerWizardSettingsHandler(File pathToSettingsFile, String missingSettingDefaultValue) {
        super(pathToSettingsFile, missingSettingDefaultValue);
    }

    @Override
    public HashMap<String, String> getDefaultSettings() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("language", "en_US");
        map.put("ram", DEFAULT_SERVER_RAM);
        map.put("server-ip", "");
        map.put("launch-parameters", DEFAULT_SERVER_LAUNCH_PARAMETERS);
        map.put("store-players-with-alias", "true");
        map.put("writedebuglogtofile", "true");
        map.put("server-type", "minecraftedu");
        map.put("take-backups", "true");
        map.put("level-name", "");
        map.put("overrided-saved-worlds-folder", "");
        map.put("loaded-saved-map", "false");
        map.put("saved-map-name", "");
        map.put("password", "");
        map.put("password-first-character", "");
        map.put("password-length", "");
        map.put("store-players-with-alias", "true");
        map.put("language", "en_US");
        map.put("log-idle-players", "false");
        map.put("kick-idle-players", "false");
        map.put("kick-idle-players-interval", "5");
        map.put("kick-idle-ops", "false");
        map.put("alias-protection", "false");
        map.put("restrict-new-users-to-join", "false");
        return map;
    }

    @Override
    public HashMap<String, String> getSettingComments() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("language", "Server Launcher and Server language. Set from the application, do not modify. Default: en_US");
        map.put("ram", "How much RAM memory in megabytes (MB) will be assigned for the Server. Default: 1024");
        map.put("server-ip", "If you want to show custom IP address in the server's top menu, define it here. Will not be used anywhere else. If empty, will automatically get the IP address. Default: empty");
        map.put("launch-parameters", "Parameters how Server is being launched through the Server Launcher.");
        map.put("store-players-with-alias", "If true, user data is being stored in the server using usernames. Otherwise with user aliases. Default: false");
        map.put("writedebuglogtofile", "If true, all console messages will be written in minecraftedu/debug folder. Default: true");
        map.put("server-type", "What server will be launched using the Server Launcher. Can be minecraftedu, minecraft or custom. Default: minecraftedu");
        map.put("take-backups", "Should we take backups of the worlds launched using the Server Launcher in folder servertool/worlds/backups. Default: true");
        map.put("level-name", "Used by Server Launcher to determine path to launched world. Do not modify manually.");
        map.put("overrided-saved-worlds-folder", "If you want to store your minecraftedu world saves to custom location, you can set path to that folder here. Default: empty");
        map.put("loaded-saved-map", "Used by Server Launcher to ");
        map.put("saved-map-name", "Used by Server Launcher to determine");
        map.put("password", "Server teacher password in MD5 encrypted format. If you wish to manually set this, you can use any web service to generate MD5 hash from your text and type it here.");
        map.put("password-first-character", "First character of teacher password. Only shown to user when he is changing the current teacher password.");
        map.put("password-length", "How long was the teacher password. Only shown to user when he is changing the current teacher password.");
        map.put("log-idle-players", "Should we log a entry in server log file if a player is idle. Default: false");
        map.put("kick-idle-players", "Should we kick players who are idle for certain time in the server. Default: false");
        map.put("kick-idle-players-interval", "Time (in minutes) how long user needs to be idle before he is kicked from the server. Default: 5");
        map.put("kick-idle-ops", "Should we also kick idle ops (teachers) out from the server. Default: false");
        map.put("alias-protection", "When students are joining the server, should they have the possibility to password protect their aliases. Default: false");
        map.put("restrict-new-users-to-join", "When student is joining, should we also check that the user's alias is already known in the server. Any new users could then not join the server if enabled. Links to alias-protection setting. Default: false");
        return map;
    }

    @Override
    public String getFormattedComment(String comment) {
        return "# " + comment;
    }

    @Override
    public String getCommentStartFormat() {
        return "# ";
    }

    @Override
    public String getFileComment() {
        return this.getFormattedComment("Settings for MinecraftEdu Server Launcher and MinecraftEdu Server. Most of these settings can be changed through MinecraftEdu Server Launcher settings menu or through MinecraftEdu Server.");
    }

    public String getServerRam() {
        String setting = this.getValueForSetting("ram");
        return setting == null || setting.isEmpty() ? DEFAULT_SERVER_RAM : setting;
    }

    public boolean getStorePlayersWithAlias() {
        return this.getValueForSettingAsBoolean("store-players-with-alias", true);
    }

    public boolean getWriteDebugLogToFile() {
        return this.getValueForSettingAsBoolean("writedebuglogtofile", false);
    }

    public String getServerType() {
        String setting = this.getValueForSetting("server-type");
        if (setting == null || setting.isEmpty()) {
            return "minecraftedu";
        }
        if (!(setting.equals("minecraftedu") && setting.equals(SERVER_TYPE_MINECRAFT) && setting.equals(SERVER_TYPE_CUSTOM))) {
            return "minecraftedu";
        }
        return setting;
    }

    public boolean getTakeBackups() {
        return this.getValueForSettingAsBoolean("take-backups", true);
    }

    public String getServerLaunchParameters() {
        String setting = this.getValueForSetting("launch-parameters");
        return setting == null || setting.isEmpty() ? DEFAULT_SERVER_LAUNCH_PARAMETERS : setting;
    }

    public String getLevelName() {
        return this.getValueForSetting("level-name");
    }

    public String getLevelNameFolder() {
        return this.getValueForSetting("level-name").replace("EduWorldSettings.ini", "");
    }

    public String getServerCustomIp() {
        return this.getValueForSetting("server-ip");
    }

    public String getSettingOverridedSavedWorldsFolder() {
        return this.getValueForSetting("overrided-saved-worlds-folder");
    }

    public String getTeacherPassword() {
        return this.getValueForSetting("password");
    }

    public String getTeacherPasswordFirstCharacter() {
        return this.getValueForSetting("password-first-character");
    }

    public String getTeacherPasswordLength() {
        return this.getValueForSetting("password-length");
    }

    public boolean getSettingLogIdlePlayers() {
        return this.getValueForSetting("log-idle-players").equals("true");
    }

    public boolean getSettingRestrictNewUsersToJoin() {
        return this.getValueForSetting("restrict-new-users-to-join").equals("true");
    }

    public boolean getSettingKickIdlePlayers() {
        return this.getValueForSetting("kick-idle-players").equals("true");
    }

    public int getSettingKickIdlePlayersInterval() {
        return this.getValueForSettingAsInt("kick-idle-players-interval", 5);
    }

    public boolean getSettingKickIdleOps() {
        return this.getValueForSetting("kick-idle-ops").equals("true");
    }

    public boolean getSettingAliasProtection() {
        return this.getValueForSettingAsBoolean("alias-protection", false);
    }

    public String getSettingSavedMapName() {
        return this.getValueForSetting("saved-map-name");
    }

    public String getSettingLoadedSavedMap() {
        return this.getValueForSetting("loaded-saved-map");
    }

    public void setSettingServerRam(String ram) {
        this.saveSetting("ram", ram);
    }

    public void setSettingServerCustomIp(String customIp) {
        this.saveSetting("server-ip", customIp);
    }

    public void setSettingServerType(String serverType) {
        this.saveSetting("server-type", serverType);
    }

    public void setSettingServerLaunchParameters(String serverLaunchParameters) {
        this.saveSetting("launch-parameters", serverLaunchParameters);
    }

    public void setSettingTakeBackups(boolean state) {
        this.saveSetting("take-backups", Boolean.toString(state).toLowerCase());
    }

    public void setSettingLevelName(String pathToMapSettingsFile) {
        this.saveSetting("level-name", pathToMapSettingsFile);
    }

    public void setSettingLoadedSavedMap(boolean state) {
        this.saveSetting("loaded-saved-map", Boolean.toString(state).toLowerCase());
    }

    public void setSettingSavedMapName(String name) {
        this.saveSetting("saved-map-name", name);
    }

    public void setSettingNewTeacherPassword(String newPlainPassword) {
        this.saveSetting("password", Security.getMd5(newPlainPassword));
        this.saveSetting("password-length", Integer.toString(newPlainPassword.length()));
        this.saveSetting("password-first-character", newPlainPassword.substring(0, 1));
    }

    public void setSettingStorePlayersWithAlias(boolean state) {
        this.saveSetting("store-players-with-alias", Boolean.toString(state).toLowerCase());
    }

    public void setSettingRestrictNewUsersToJoin(boolean state) {
        this.saveSetting("restrict-new-users-to-join", Boolean.toString(state).toLowerCase());
    }

    public void setSettingAliasProtection(boolean state) {
        this.saveSetting("alias-protection", Boolean.toString(state).toLowerCase());
    }
}

