/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.localization;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import mcedu.global.localization.tools.Language;
import mcedu.global.tools.Datahandler;

public class Localization {
    public static final String LANGUAGE_DEFAULT = "en_US";
    public static final int SAVEVALUEFORMAT_SHORT = 0;
    public static final int SAVEVALUEFORMAT_LONG = 1;
    private static boolean initialized = false;
    private static boolean started = false;
    private HashMap<String, String> localizationData = new HashMap();
    private HashMap<String, String> enLocalizationData = new HashMap();
    private ArrayList<Language> availableTranslations = new ArrayList();
    private String localizationFolderName;
    private ArrayList<Language> languageMap;
    private String pathToLanguageDatabase = "/mcedu/global/localization/tools/languages.txt";
    private String pathToFlagImages = "/mcedu/global/localization/icons/";
    private String pathGlobalTranslations = "/mcedu/global/localization/translations/global/";
    private Language currentLanguage;
    private File pathToLanguageFile;
    private String saveKey;
    private int saveValueFormat;
    private boolean saveLanguageToFile = false;
    public boolean doEduTranslate = false;
    private File pathToExternalTranslationsFolder;
    private static Localization localization;

    public void init() {
        if (initialized) {
            System.out.println("Localization was already initialized before!!");
            return;
        }
        try {
            this.languageMap = new ArrayList();
            this.addLanguagesToList();
        }
        catch (IOException e) {
            System.out.println("Problem adding languages to LanguageMap: " + e.getMessage());
            e.printStackTrace();
        }
        initialized = true;
    }

    public void start(String localizationFolderName, Language startLanguage, File overrideTranslationsFolder) {
        if (!initialized) {
            this.init();
        }
        if (started) {
            System.out.println("Localization has already been started. Returning...");
            return;
        }
        this.localizationFolderName = localizationFolderName;
        this.pathToExternalTranslationsFolder = overrideTranslationsFolder;
        this.postStart(startLanguage);
    }

    public void start(String localizationFolderName, File pathToTranslationSettingsFile, File overrideTranslationsFolder, String saveKey, int saveValueFormat) {
        if (!initialized) {
            this.init();
        }
        if (started) {
            System.out.println("Localization has already been started. Returning...");
            return;
        }
        this.saveLanguageToFile = true;
        this.pathToLanguageFile = pathToTranslationSettingsFile;
        this.localizationFolderName = localizationFolderName;
        this.saveKey = saveKey;
        this.saveValueFormat = saveValueFormat;
        this.pathToExternalTranslationsFolder = overrideTranslationsFolder;
        if (!this.pathToLanguageFile.exists()) {
            Datahandler.createFile(this.pathToLanguageFile.getAbsolutePath());
            this.setProgramLanguage(this.getDefaultLanguage());
        }
        this.postStart(this.loadLanguageFromFile());
    }

    private void postStart(Language newLanguage) {
        this.currentLanguage = newLanguage;
        this.loadLocalizationData();
        for (Language language : this.languageMap) {
            InputStream in;
            File projectExtPath = this.getProjectExternalTranslationFolder();
            if (projectExtPath.exists() ? !new File(projectExtPath.getAbsolutePath() + "/" + language.getLangShort()).exists() : (in = this.getClass().getResourceAsStream(this.getProjectLocalizationPath() + language.getLangShort())) == null) continue;
            boolean found = false;
            for (Language lang : this.availableTranslations) {
                if (!lang.getLangShort().equals(language.getLangShort())) continue;
                found = true;
            }
            if (found) continue;
            this.availableTranslations.add(language);
        }
        started = true;
    }

    private void saveCurrentLanguageToFile() {
        if (this.saveLanguageToFile) {
            Datahandler.iniSet(this.pathToLanguageFile.getAbsolutePath(), this.saveKey, this.saveValueFormat == 0 ? this.getCurrentLanguage().getLangShort() : this.getCurrentLanguage().getLangName());
        }
    }

    private Language loadLanguageFromFile() {
        if (!this.saveLanguageToFile) {
            System.out.println("Language loading from file has not been enabled, returning default language...");
            return this.getDefaultLanguage();
        }
        String lang = Datahandler.iniGet(this.pathToLanguageFile.getAbsolutePath(), this.saveKey);
        if (lang == null || lang.equals("")) {
            System.out.println("Loaded empty language from file, returning default!");
            return this.getDefaultLanguage();
        }
        Language langObj = this.getLanguage(lang);
        if (langObj == null) {
            System.out.println("Loaded unrecognized Language from file, returning default!");
            return this.getDefaultLanguage();
        }
        return langObj;
    }

    public ArrayList<Language> getAllLanguages() {
        return this.languageMap;
    }

    public Language getDefaultLanguage() {
        return this.getLanguage(LANGUAGE_DEFAULT);
    }

    public void setProgramLanguage(Language lang) {
        if (lang == null) {
            System.out.println("Trying to set null language for the program!");
        }
        this.currentLanguage = lang;
        this.saveCurrentLanguageToFile();
        this.loadLocalizationData();
    }

    public void setProgramLanguage(String lang) {
        this.setProgramLanguage(this.getLanguage(lang));
    }

    public Language getCurrentLanguage() {
        if (this.currentLanguage == null) {
            System.out.println("Current language is null, returning english...");
            return this.getLanguage(LANGUAGE_DEFAULT);
        }
        return this.currentLanguage;
    }

    public Language getLanguage(String name) {
        int i;
        boolean shortLang = name.contains("_");
        for (i = 0; !(i >= this.languageMap.size() || shortLang && this.languageMap.get(i).getLangShort().equalsIgnoreCase(name) || !shortLang && this.languageMap.get(i).getLangName().equalsIgnoreCase(name)); ++i) {
        }
        return this.languageMap.get(i);
    }

    public ArrayList<Language> getAvailableLanguages() {
        return this.availableTranslations;
    }

    private void addLanguagesToList() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Localization.class.getResourceAsStream(this.pathToLanguageDatabase), "UTF-8"));
        String currentLine = reader.readLine();
        while (currentLine != null) {
            try {
                String[] langShort = currentLine.split("=");
                String[] temp = currentLine.split("=");
                String[] langFull = temp[1].split(" \\(");
                String[] countryShort = temp[0].split("_");
                String[] countryFull = temp[1].split(" \\(");
                countryFull[1] = countryFull[1].substring(0, countryFull[1].length() - 1);
                this.languageMap.add(new Language(langFull[0], langShort[0], countryShort[1], countryFull[1], this.pathToFlagImages));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            currentLine = reader.readLine();
        }
    }

    private String getProjectLocalizationPath() {
        return "/mcedu/global/localization/translations/" + this.localizationFolderName + "/";
    }

    private File getProjectExternalTranslationFolder() {
        return new File(this.pathToExternalTranslationsFolder.getAbsolutePath() + "/" + this.localizationFolderName + "/");
    }

    private File getGlobalExternalTranslationFolder() {
        return new File(this.pathToExternalTranslationsFolder.getAbsolutePath() + "/global/");
    }

    private void loadLocalizationData() {
        String langShort = this.currentLanguage.getLangShort();
        if (langShort == null || langShort.equals("")) {
            langShort = LANGUAGE_DEFAULT;
            System.out.println("Could not fetch language from settings file. Defaulting to english (en_US).");
        }
        if (langShort.startsWith("en") && !langShort.equals("en_PT")) {
            langShort = LANGUAGE_DEFAULT;
        }
        this.localizationData.clear();
        this.enLocalizationData.clear();
        try {
            File globalExtTranslationResource = new File(this.getGlobalExternalTranslationFolder().getAbsolutePath() + "/" + langShort);
            HashMap<String, String> globalTr = globalExtTranslationResource.exists() ? (HashMap<String, String>)Datahandler.loadDataInMapFromFile(globalExtTranslationResource.getAbsolutePath(), "=") : this.loadTranslation(this.pathGlobalTranslations, langShort, "UTF-8");
            this.localizationData.putAll(globalTr);
        }
        catch (Exception e) {
            System.out.println("Error trying to load translation: " + this.pathGlobalTranslations + langShort);
            e.printStackTrace();
        }
        try {
            File globalExtTranslationResourceEn = new File(this.getGlobalExternalTranslationFolder().getAbsolutePath() + "/" + LANGUAGE_DEFAULT);
            HashMap<String, String> enGlobalTr = globalExtTranslationResourceEn.exists() ? (HashMap<String, String>)Datahandler.loadDataInMapFromFile(globalExtTranslationResourceEn.getAbsolutePath(), "=") : this.loadTranslation(this.pathGlobalTranslations, LANGUAGE_DEFAULT, "UTF-8");
            this.enLocalizationData.putAll(enGlobalTr);
        }
        catch (Exception e) {
            System.out.println("Error trying to load translation: " + this.pathGlobalTranslations + LANGUAGE_DEFAULT);
            e.printStackTrace();
        }
        try {
            HashMap<String, String> enProgramTr;
            HashMap<String, String> programTr;
            File projectExtTranslationResource = new File(this.getProjectExternalTranslationFolder().getAbsolutePath() + "/" + langShort);
            File projectExtTranslationResourceEn = new File(this.getProjectExternalTranslationFolder().getAbsolutePath() + "/" + LANGUAGE_DEFAULT);
            if (projectExtTranslationResource.exists()) {
                programTr = (HashMap<String, String>)Datahandler.loadDataInMapFromFile(projectExtTranslationResource.getAbsolutePath(), "=", "UTF-8");
                enProgramTr = (HashMap<String, String>)Datahandler.loadDataInMapFromFile(projectExtTranslationResourceEn.getAbsolutePath(), "=", "UTF-8");
            } else {
                programTr = this.loadTranslation(this.getProjectLocalizationPath(), langShort, "UTF-8");
                enProgramTr = this.loadTranslation(this.getProjectLocalizationPath(), LANGUAGE_DEFAULT, "UTF-8");
            }
            this.localizationData.putAll(programTr);
            this.enLocalizationData.putAll(enProgramTr);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Error trying to load translation: " + this.getProjectLocalizationPath() + langShort);
            e.printStackTrace();
        }
        try {
            File projectExtTranslationResourceEn = new File(this.getProjectExternalTranslationFolder().getAbsolutePath() + "/" + LANGUAGE_DEFAULT);
            HashMap<String, String> enProgramTr = projectExtTranslationResourceEn.exists() ? (HashMap<String, String>)Datahandler.loadDataInMapFromFile(projectExtTranslationResourceEn.getAbsolutePath(), "=", "UTF-8") : this.loadTranslation(this.getProjectLocalizationPath(), LANGUAGE_DEFAULT, "UTF-8");
            this.enLocalizationData.putAll(enProgramTr);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Error trying to load translation: " + this.getProjectLocalizationPath() + langShort);
            e.printStackTrace();
        }
    }

    private HashMap<String, String> loadTranslation(String pathToTranslationFolder, String langFilename, String characterEncoding) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String loadableFile = pathToTranslationFolder + langFilename;
        InputStream in = this.getClass().getResourceAsStream(loadableFile);
        if (in == null) {
            in.close();
            throw new Exception(" Translation resource was null: " + loadableFile);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in, characterEncoding));
        String line = "";
        String[] splitData = new String[2];
        while (null != (line = br.readLine())) {
            if (line.startsWith("//") || line.equals("")) continue;
            try {
                splitData = line.split("=");
                map.put(splitData[0], splitData[1]);
            }
            catch (Exception e) {}
        }
        in.close();
        br.close();
        return map;
    }

    public String getKeyForTranslation(String value) {
        for (Map.Entry<String, String> entry : this.localizationData.entrySet()) {
            if (!entry.getValue().toLowerCase().equals(value.toLowerCase())) continue;
            return entry.getKey();
        }
        return "";
    }

    public void trC(JLabel comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setText(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trC(JButton comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setText(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trC(JToggleButton comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setText(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trC(JMenu comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setText(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trC(JMenuItem comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setText(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trC(JPanel comp) {
        String curText = comp.getAccessibleContext().getAccessibleName();
        comp.setName(this.tr(curText));
        comp.getAccessibleContext().setAccessibleName(curText);
    }

    public void trTitle(JPanel comp) {
        String curText = ((TitledBorder)comp.getBorder()).getTitle();
        ((TitledBorder)comp.getBorder()).setTitle(this.tr(curText));
    }

    public void trC(JLabel comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public void trC(JButton comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public void trC(JToggleButton comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public void trC(JMenu comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public void trC(JMenuItem comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public void trC(JPanel comp, String text) {
        this.trC(comp);
        comp.setToolTipText(this.tr(text));
    }

    public String tr(String key) {
        if (this.localizationData.containsKey(key)) {
            String returnString = this.localizationData.get(key);
            return returnString;
        }
        if (!this.currentLanguage.getLangShort().equals(LANGUAGE_DEFAULT) && this.enLocalizationData.containsKey(key)) {
            String returnString = this.enLocalizationData.get(key);
            return returnString;
        }
        return key;
    }

    public String tr(String key, String lang) {
        HashMap<String, String> localizations = new HashMap<String, String>();
        try {
            HashMap<String, String> globalLocal = this.loadTranslation(this.pathGlobalTranslations, lang, "UTF-8");
            HashMap<String, String> programLocal = this.loadTranslation(this.getProjectLocalizationPath(), lang, "UTF-8");
            localizations.putAll(globalLocal);
            localizations.putAll(programLocal);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to load localization data");
        }
        if (localizations.containsKey(key)) {
            String returnString = (String)localizations.get(key);
            return returnString;
        }
        return key;
    }

    public static Localization getS() {
        if (localization == null) {
            localization = new Localization();
        }
        return localization;
    }
}

