/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.hosting;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import mcedu.global.hosting.HTTPConnectionFailedException;
import mcedu.global.tools.Datahandler;

public class HostingGoogleDocSubmitError {
    private static final String MANUAL_ERROR_START = "--- START OF MINECRAFTEDU HOSTING ERROR MESSAGE --- ";
    private static final String MANUAL_ERROR_END = " --- END OF HOSTING ERROR MESSAGE ---";

    public static void test() {
    }

    public static void submitConnectionToLoginScriptFailed(String username, String loginUrl, String errorCode) throws Exception {
        String postData = "entry_2144818467=" + username + "&entry_2041512266=Launcher.GUIMCLauncher&entry_1784899496=Launcher login http code not 200.&entry_526135757=" + loginUrl + "&entry_1893636681=" + errorCode + "&entry_1583816904=" + HostingGoogleDocSubmitError.getInternalIPs() + "&entry_49815647=" + HostingGoogleDocSubmitError.getExternalIPAddress() + "&entry_1612127108=" + HostingGoogleDocSubmitError.sendLauncherLogFile();
        HostingGoogleDocSubmitError.sendDataToGoogleDocsForm("https://docs.google.com/forms/d/1KUBTz7yxlMSkH4EwG2isnK2OEr0BIM7mKtITpPmuy9c/formResponse", postData);
    }

    public static String getLoginScriptManualSupportMessage(String username, String loginUrl, String errorCode, String googleDocsErrorCode) {
        return "--- START OF MINECRAFTEDU HOSTING ERROR MESSAGE --- [" + Datahandler.getCurrentTimeStamp() + "] User " + username + " could not login to their hosting account from Launcher because of http status code " + errorCode + ". Google Docs form http error code was: " + googleDocsErrorCode + " Hosting url where tried to connect into: " + loginUrl + "Internal ips: " + HostingGoogleDocSubmitError.getInternalIPs() + " External ip: " + HostingGoogleDocSubmitError.getExternalIPAddress() + MANUAL_ERROR_END;
    }

    public static void submitConnectionToMinecraftServerFailed(String username, String disconnectMessage, String proxyServerAddress, String serverID, String latestlog) throws Exception {
        String postData = "entry_2144818467=" + username + "&entry_2041512266=Client.GUIDisconnected&entry_1784899496=Could not connect to MinecraftEdu hosting server.&entry_821083561=" + proxyServerAddress + "&entry_1075792415=" + serverID + "&entry_109993493=" + disconnectMessage + "&entry_1583816904=" + HostingGoogleDocSubmitError.getInternalIPs() + "&entry_49815647=" + HostingGoogleDocSubmitError.getExternalIPAddress() + "&entry_1093022=" + latestlog;
        HostingGoogleDocSubmitError.sendDataToGoogleDocsForm("https://docs.google.com/forms/d/1KUBTz7yxlMSkH4EwG2isnK2OEr0BIM7mKtITpPmuy9c/formResponse", postData);
    }

    public static String getMinecraftServerConnectionFailedSupportMessage(String username, String disconnectMessage, String proxyServerAddress, String serverID, String googleDocsErrorCode) {
        return "--- START OF MINECRAFTEDU HOSTING ERROR MESSAGE --- [" + Datahandler.getCurrentTimeStamp() + "] User " + username + " could not connect to MinecraftEdu hosting server ID: " + serverID + " (proxy address: " + proxyServerAddress + "). Google Docs form http error code was: " + googleDocsErrorCode + " Disconnect message: " + disconnectMessage + "Internal ips: " + HostingGoogleDocSubmitError.getInternalIPs() + " External ip: " + HostingGoogleDocSubmitError.getExternalIPAddress() + MANUAL_ERROR_END;
    }

    private static void sendDataToGoogleDocsForm(String url, String postData) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(postData);
        wr.flush();
        wr.close();
        System.out.println("responseCode on google docs submit: " + con.getResponseCode());
        if (con.getResponseCode() != 200) {
            throw new HTTPConnectionFailedException("Google Docs form submission did not return status code 200.", con.getResponseCode());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
    }

    private static String getInternalIPs() {
        String internalIPs = "";
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (!(i instanceof Inet4Address)) continue;
                    internalIPs = internalIPs + i.getHostAddress() + ", ";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            internalIPs = "COULD NOT GET INTERNAL IPS";
            return "COULD NOT GET INTERNAL IPS";
        }
        return internalIPs;
    }

    private static String getExternalIPAddress() {
        String ip = "";
        try {
            ip = Datahandler.getContentFromWebpage("http://checkip.amazonaws.com/");
        }
        catch (Exception e) {
            ip = "COULD NOT GET EXTERNAL IP";
        }
        if (ip == null || ip.isEmpty()) {
            ip = "COULD NOT GET EXTERNAL IP";
        }
        return ip;
    }

    public static String sendLauncherLogFile() {
        File file = new File("./debug/launcher.log");
        String text = "";
        if (file.exists()) {
            List test = Datahandler.readLinesFromFileToList("./debug/launcher.log");
            for (Object line : test) {
                text = text + line.toString() + "</br>";
            }
        }
        return text;
    }
}

