/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global.hosting;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mcedu.global.Proxy;
import mcedu.global.hosting.HTTPConnectionFailedException;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.MessageBox;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HostingApiLogin {
    public static String getHostingAccessToken(String username, String hashedPassword, File urlOverrideFile) {
        try {
            String inputLine;
            String url = "http://minecraftedu.com/xml/get/MCEUserStatus";
            String urlFromFile = Datahandler.iniGet(urlOverrideFile.getAbsolutePath(), "hosting-url");
            if (urlFromFile != null && !urlFromFile.isEmpty()) {
                url = urlFromFile;
            }
            System.out.println("Hosting URL: " + url);
            URL obj = new URL(url);
            File file = new File("../launcher_res/settings/launchersettings.ini");
            if (file.exists()) {
                Proxy.setProxyFromFile(file);
            }
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            String urlParameters = "name=" + username + "&password_hashed=" + hashedPassword;
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(response.toString()));
            Document doc = builder.parse(is);
            String status = doc.getElementsByTagName("UserStatus").item(0).getAttributes().getNamedItem("status").getNodeValue();
            String apiToken = "";
            if (status.equals("ok")) {
                NodeList nodes = doc.getElementsByTagName("UserStatus").item(0).getChildNodes();
                if (nodes == null || nodes.getLength() == 0) {
                    MessageBox.error("Error", "There are not enough XML tags to parse. This should not happen.");
                    return "";
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String nodeName = node.getNodeName();
                    if (!nodeName.equals("user")) continue;
                    apiToken = node.getAttributes().getNamedItem("token").getNodeValue();
                }
                if (apiToken.equals("")) {
                    throw new Exception("Returned API Token was empty. This should not happen.");
                }
                return apiToken;
            }
            return "";
        }
        catch (Exception e) {
            System.out.println("Error refreshing hosting access token: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    public static int checkConnectionStatus(HttpURLConnection con) throws HTTPConnectionFailedException {
        int connectionStatus = 0;
        try {
            connectionStatus = con.getResponseCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connectionStatus;
    }
}

