/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global;

import mcedu.global.localization.Localization;

public abstract class Version {
    private static int eduVersion = 2;
    private static String version = "1.7.10";
    private static double versionDouble = 1.71;
    private static int buildNumber = 20;
    private static boolean isStableBuild = true;
    private static int protocolVersion = Integer.parseInt(version.replace(".", "") + 0 + Integer.toString(buildNumber));
    private static String eduWorldVersion = "0.2";
    private static String releaseDate = "01Jul15/12:57";
    private static boolean isHostingBuild = true;

    public static String getTranslatedEduVersionName() {
        if (Version.isClassroom()) {
            return Localization.getS().tr("classroom");
        }
        return Localization.getS().tr("premium");
    }

    public static String getUnTranslatedEduVersionName() {
        if (isHostingBuild) {
            return "hosting";
        }
        if (Version.isClassroom()) {
            return "classroom";
        }
        return "premium";
    }

    public static String getTranslatedBuildType() {
        if (isStableBuild) {
            return Localization.getS().tr("stable");
        }
        return Localization.getS().tr("development");
    }

    public static String getUnTranslatedBuildType() {
        if (isStableBuild) {
            return "stable";
        }
        return "development";
    }

    public static boolean isStableBuild() {
        return isStableBuild;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    public static String getMinecraftVersion() {
        return version;
    }

    public static String getEduWorldVersion() {
        return eduWorldVersion;
    }

    public static int getProtocolVersion() {
        return protocolVersion;
    }

    public static String getFormattedVersion() {
        return version;
    }

    public static String getFormattedVersion(String version) {
        String returnVer = "";
        returnVer = version.substring(0, 3) + "." + version.substring(3, version.length());
        return returnVer;
    }

    public static double getVersion() {
        return versionDouble;
    }

    public static String getReleaseDate() {
        return releaseDate;
    }

    public static int getEduVersion() {
        return eduVersion;
    }

    public static boolean isClassroom() {
        return eduVersion == 2;
    }

    public static boolean isPremium() {
        return eduVersion == 1;
    }

    public static boolean isHostingBuild() {
        return isHostingBuild;
    }
}

