/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global;

import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import mcedu.global.tools.Datahandler;
import mcedu.global.tools.SimpleAuthenticator;

public class Proxy {
    public static final String CONNECTION_TYPE_HTTP = "http";
    public static final String CONNECTION_TYPE_HTTPS = "https";
    public static final String CONNECTION_TYPE_SOCKS = "socks";
    public static final String CONNECTION_TYPE_ALL = "all";
    private static java.net.Proxy javaProxyObject;
    private static SimpleAuthenticator proxyAuthentication;

    public static void setProxy(String connectionType, String directConnectionType, String address, String port) {
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            System.out.println("Error setting proxy! Proxy port does not seem to be number: " + port);
            return;
        }
        if (connectionType.equals(CONNECTION_TYPE_HTTP) || connectionType.equals(CONNECTION_TYPE_ALL)) {
            System.setProperty("http.proxyHost", address);
            System.setProperty("http.proxyPort", port);
        }
        if (connectionType.equals(CONNECTION_TYPE_HTTPS) || connectionType.equals(CONNECTION_TYPE_ALL)) {
            System.setProperty("https.proxyHost", address);
            System.setProperty("https.proxyPort", port);
        }
        if (connectionType.equals(CONNECTION_TYPE_SOCKS) || connectionType.equals(CONNECTION_TYPE_ALL)) {
            System.setProperty("socksProxyHost", address);
            System.setProperty("socksProxyPort", port);
        }
        if (directConnectionType.equals(CONNECTION_TYPE_HTTP) || directConnectionType.equals(CONNECTION_TYPE_HTTPS)) {
            javaProxyObject = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(address, Integer.parseInt(port)));
        } else if (directConnectionType.equals(CONNECTION_TYPE_SOCKS)) {
            javaProxyObject = new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(address, Integer.parseInt(port)));
        } else {
            try {
                javaProxyObject = new java.net.Proxy(Proxy.Type.DIRECT, new InetSocketAddress(address, Integer.parseInt(port)));
            }
            catch (Exception e) {
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                System.out.println("ERROR SETTING PROXY: " + e.getMessage());
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                e.printStackTrace();
            }
            System.out.println("Setting direct proxy.");
        }
    }

    public static void setProxy(String connectionType, String directConnectionType, String address, String port, String username, String password) {
        if (connectionType.equals(CONNECTION_TYPE_SOCKS) || connectionType.equals(CONNECTION_TYPE_ALL)) {
            System.setProperty("java.net.socks.username", username);
            System.setProperty("java.net.socks.password", password);
        }
        proxyAuthentication = new SimpleAuthenticator(username, password);
        Authenticator.setDefault(proxyAuthentication);
        Proxy.setProxy(connectionType, directConnectionType, address, port);
    }

    public static boolean setProxyFromFile(File pathToProxySettingsFile) {
        if (!pathToProxySettingsFile.exists()) {
            return false;
        }
        String connectionType = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-global-connection-type");
        String directConnectionType = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-direct-connection-type");
        String address = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-address");
        String port = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-port");
        String username = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-username");
        String password = Datahandler.iniGet(pathToProxySettingsFile.getAbsolutePath(), "proxy-password");
        if (connectionType == null) {
            connectionType = CONNECTION_TYPE_HTTP;
        }
        if (directConnectionType == null) {
            directConnectionType = CONNECTION_TYPE_ALL;
        }
        if (address == null) {
            address = "";
        }
        if (port == null) {
            port = "";
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        if (port.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            System.out.println("Error setting proxy! Proxy port is not number: " + port);
            return false;
        }
        if (!address.equals("") && !port.equals("")) {
            if (!username.equals("") && !password.equals("")) {
                Proxy.setProxy(connectionType.toLowerCase(), directConnectionType.toLowerCase(), address, port, username, password);
                System.out.println("Proxy global method " + connectionType + " has been set to application with authentication!");
                System.out.println("Proxy direct method " + directConnectionType + " has been set to application with authentication!");
                System.out.println("Proxy username: " + username);
                System.out.println("Proxy password: " + password);
                System.out.println("Proxy address: " + address);
                System.out.println("Proxy port: " + port);
            } else {
                Proxy.setProxy(connectionType.toLowerCase(), directConnectionType.toLowerCase(), address, port);
                System.out.println("Proxy method " + connectionType + " has been set to application without authentication!");
                System.out.println("Proxy direct method " + directConnectionType + " has been set to application without authentication!");
            }
            return true;
        }
        System.out.println("Proxy was not set for the application.");
        return false;
    }

    public static java.net.Proxy getJavaProxyObject() {
        return javaProxyObject == null ? java.net.Proxy.NO_PROXY : javaProxyObject;
    }

    public static SimpleAuthenticator getAuthenticator() {
        return proxyAuthentication;
    }
}

