/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global;

import java.io.File;
import mcedu.global.tools.GetOS;

public class Paths {
    private static File appDataDirectory = null;

    public static File getAppDataDirectory() {
        if (appDataDirectory == null) {
            appDataDirectory = Paths.getAppDataDirectory("");
        }
        return appDataDirectory;
    }

    public static File getAppDataDirectory(String applicationName) {
        File workingDirectory;
        String userHome = System.getProperty("user.home", "");
        switch (GetOS.getOS()) {
            case 1: 
            case 3: {
                workingDirectory = new File(userHome, applicationName + '/');
                break;
            }
            case 0: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                workingDirectory = new File(folder, applicationName + '/');
                break;
            }
            case 2: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                workingDirectory = new File(userHome, applicationName + '/');
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }
}

