/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import mcedu.global.Version;
import mcedu.global.localization.Localization;
import mcedu.global.localization.tools.Language;
import mcedu.global.tools.GetOS;
import mcedu.global.tools.MessageBox;

public abstract class Application {
    private static String applicationName = "";

    public static void init() {
        Localization.getS().init();
    }

    public static void start(String appName, String iconFileName, String localizationDataName, File overrideTranslationsFolder, Language startLanguage, double minimumJavaVersion) {
        applicationName = appName;
        if (GetOS.getOS() == 2) {
            Application.initMacFunctionality(iconFileName, appName);
        }
        Localization.getS().start(localizationDataName, startLanguage, overrideTranslationsFolder);
        Application.checkJavaVersion(minimumJavaVersion);
    }

    public static void start(String appName, String iconFileName, String localizationDataName, File pathToLocalizationFile, File overrideTranslationsFolder, String saveKey, int saveValueFormat, double minimumJavaVersion) {
        applicationName = appName;
        if (GetOS.getOS() == 2) {
            Application.initMacFunctionality(iconFileName, appName);
        }
        Localization.getS().start(localizationDataName, pathToLocalizationFile, overrideTranslationsFolder, saveKey, saveValueFormat);
        Application.checkJavaVersion(minimumJavaVersion);
    }

    public static void initMacFunctionality(String localizationDataName, String appName) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        try {
            Image dockIcon = Toolkit.getDefaultToolkit().getImage(Application.class.getResource("/mcedu/global/icons/" + localizationDataName + "/icon_256.png"));
            if (dockIcon == null) {
                System.out.println("Mac Dock icon was null!");
                return;
            }
            Class<?> macAppClass = Class.forName("com.apple.eawt.Application");
            Method getApp = macAppClass.getMethod("getApplication", new Class[0]);
            Object result = getApp.invoke(null, new Object[0]);
            Method setDock = result.getClass().getMethod("setDockIconImage", Image.class);
            setDock.invoke(result, dockIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkJavaVersion(double minimumJavaVersion) {
        try {
            double javaVersion = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
            if (javaVersion < minimumJavaVersion) {
                MessageBox.notice("Old Java version", "<html>Your system java version is below " + minimumJavaVersion + ".<br>Some functionality might not work correctly with server / client / servertool.<br>Please update your Java.</html>");
            }
        }
        catch (Exception e) {
            System.out.println("Could not parse Java version!");
            e.printStackTrace();
        }
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static String getApplicationTitleWithoutVersion() {
        return Application.getApplicationName() + " (" + Version.getUnTranslatedEduVersionName() + ")";
    }

    public static String getApplicationTitle() {
        return Application.getApplicationName() + " " + Version.getFormattedVersion() + " " + Version.getTranslatedEduVersionName() + " (" + Version.getTranslatedBuildType() + " build " + Version.getBuildNumber() + ")";
    }

    public static String getUnTranslatedApplicationTitle() {
        return Application.getApplicationName() + " " + Version.getFormattedVersion() + " " + Version.getUnTranslatedEduVersionName() + " (" + Version.getUnTranslatedBuildType() + " build " + Version.getBuildNumber() + ")";
    }

    public static String getClientTitle() {
        return "MinecraftEdu " + Version.getFormattedVersion() + " " + Version.getTranslatedEduVersionName() + " (" + Version.getTranslatedBuildType() + " build " + Version.getBuildNumber() + ")";
    }
}

