/*
 * Decompiled with CFR 0.152.
 */
package mcedu.global;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import mcedu.global.Version;
import mcedu.global.exceptions.ApiExpectionMessage;
import mcedu.global.tools.Datahandler;

public class Api {
    public static final String urlApi = "http://www.minecraftedu.com/api/api.php";
    private static final String urlApiLogin = "http://www.minecraftedu.com/api/api.php?action=login";
    public static final String urlApiGetVersions = "http://www.minecraftedu.com/api/api.php?action=b_getversions";
    public static final String urlApiBugFeatureRequest = "http://www.minecraftedu.com/api/api.php?action=bugfeaturerequest";
    public static final String urlApiDownloadVersion = "http://www.minecraftedu.com/api/api.php?action=b_downloadversion";
    public static final String urlApiGetVersionFileSize = "http://www.minecraftedu.com/api/api.php?action=b_getversionfilesize";
    public static final String urlApiGetVersionMd5 = "http://www.minecraftedu.com/api/api.php?action=b_getversionmd5";
    public static final String urlApiGetModList = "http://www.minecraftedu.com/api/api.php?action=b_getmodlist";
    public static final String urlApiBuildTranslations = "http://www.minecraftedu.com/api/api.php?action=build_translations";
    public static final String urlApiDownloadTranslations = "http://www.minecraftedu.com/api/api.php?action=download_translations";
    public static final String urlApiTrackModDownload = "http://www.minecraftedu.com/api/api.php?action=track_mod_download";
    private static final String LOGIN_SUCCESFULL = "LOGIN_SUCCESS";
    private static final String LOGIN_FAILED = "LOGIN_FAILED";
    public static final String UNKNOWN_EDU_VERSION_TYPE = "UNKNOWN_VERSION_TYPE";
    private static final String API_GLOBAL_EXCEPTION_MESSAGE = "API_EXCEPTION_MESSAGE";

    public static boolean checkLogin(String username, String password, boolean passwordAlreadyHashed) throws ApiExpectionMessage {
        if (!passwordAlreadyHashed) {
            password = Api.getHashedLoginPassword(username, password);
        }
        String response = "";
        try {
            response = Version.isHostingBuild() ? Datahandler.getContentFromWebpage("http://www.minecraftedu.com/api/api.php?action=login&eduversiontype=3&hashed=true&username=" + username + "&password=" + password + "&currentversion=" + Version.getVersion() + "&currentbuild=" + Version.getBuildNumber()) : Datahandler.getContentFromWebpage("http://www.minecraftedu.com/api/api.php?action=login&eduversiontype=" + Version.getEduVersion() + "&hashed=true&username=" + username + "&password=" + password + "&currentversion=" + Version.getVersion() + "&currentbuild=" + Version.getBuildNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (response.startsWith(API_GLOBAL_EXCEPTION_MESSAGE)) {
            throw new ApiExpectionMessage(response.split("<split>")[1]);
        }
        if (response.equals(LOGIN_SUCCESFULL)) {
            return true;
        }
        if (response.equals(LOGIN_FAILED)) {
            return false;
        }
        if (response.equals(UNKNOWN_EDU_VERSION_TYPE)) {
            return false;
        }
        return false;
    }

    public static String getHashedLoginPassword(String username, String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String hassupassu = username.substring(0, 2) + password;
            md.update(hassupassu.getBytes());
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e);
            e.printStackTrace();
            return "";
        }
    }
}

