/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.File;
import mcedu.EduAccessHelperClient;
import mcedu.client.EduClientSettings;
import mcedu.client.EduClientTemp;
import mcedu.common.ServerResourcePackHandler;
import mcedu.global.tools.Datahandler;

public class EduTextureMessage
implements IMessage {
    private String channel;
    private byte[] data;

    public EduTextureMessage() {
    }

    public EduTextureMessage(String channel, byte[] data) {
        this.channel = channel;
        this.data = data;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.channel = ByteBufUtils.readUTF8String(buf);
        this.data = new byte[ByteBufUtils.readVarShort(buf)];
        buf.readBytes(this.data);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (this.data == null) {
            this.data = new byte[0];
        }
        ByteBufUtils.writeUTF8String(buf, this.channel);
        ByteBufUtils.writeVarShort(buf, this.data.length);
        buf.writeBytes(this.data);
    }

    public static class EduTextureMessageHandler
    implements IMessageHandler<EduTextureMessage, IMessage> {
        @Override
        public IMessage onMessage(EduTextureMessage message, MessageContext ctx) {
            if (EduClientSettings.getS().clientSettingsFile.getAllowServerTexturepacks()) {
                String[] split = message.channel.split(" ");
                if (split[1] == null) {
                    return null;
                }
                if (split[1].equals("start")) {
                    File file = new File(EduClientSettings.getS().pathServerTexturesFile);
                    if (file.exists()) {
                        file.delete();
                    }
                    EduClientTemp.getS().serverTexturesFile.clear();
                } else if (split[1].equals("data")) {
                    for (int i = 0; i < message.data.length; ++i) {
                        EduClientTemp.getS().serverTexturesFile.add(message.data[i]);
                    }
                } else if (split[1].equals("end")) {
                    File file = new File(EduClientSettings.getS().pathServerTexturesFile);
                    if (file.exists()) {
                        file.delete();
                    }
                    int size = EduClientTemp.getS().serverTexturesFile.size();
                    byte[] bytesToWrite = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        if (EduClientTemp.getS().serverTexturesFile.get(i) == null) continue;
                        bytesToWrite[i] = EduClientTemp.getS().serverTexturesFile.get(i);
                    }
                    if (Datahandler.writeByteArrayToFile(EduClientSettings.getS().pathServerTexturesFile, bytesToWrite)) {
                        ServerResourcePackHandler.setCurrentResourcePackInClient(ServerResourcePackHandler.TEXTURE_PACK_CUSTOM_CLIENT_NAME, EduAccessHelperClient.getMinecraft());
                    }
                    EduClientTemp.getS().serverTexturesFile.clear();
                }
            }
            return null;
        }
    }
}

