/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcedu.client.EduClientTemp;
import mcedu.forgemod.McEduForgeMod;

public class EduRandomServerMessage
implements IMessage {
    public boolean isEduTeleportLocations = false;
    public String currentLocationName = "";
    public String currentLocationCoordinates = "";
    public String allTeleportLocations = "";
    public String allowedTeleportLocations = "";
    public boolean refreshTeleportTabGui = false;
    public boolean openOptions = false;
    public boolean canStudentUse = false;

    @Override
    public void fromBytes(ByteBuf buf) {
        this.isEduTeleportLocations = buf.readBoolean();
        this.currentLocationCoordinates = ByteBufUtils.readUTF8String(buf);
        this.currentLocationName = ByteBufUtils.readUTF8String(buf);
        this.allTeleportLocations = ByteBufUtils.readUTF8String(buf);
        this.allowedTeleportLocations = ByteBufUtils.readUTF8String(buf);
        this.refreshTeleportTabGui = buf.readBoolean();
        this.openOptions = buf.readBoolean();
        this.canStudentUse = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isEduTeleportLocations);
        ByteBufUtils.writeUTF8String(buf, this.currentLocationCoordinates);
        ByteBufUtils.writeUTF8String(buf, this.currentLocationName);
        ByteBufUtils.writeUTF8String(buf, this.allTeleportLocations);
        ByteBufUtils.writeUTF8String(buf, this.allowedTeleportLocations);
        buf.writeBoolean(this.refreshTeleportTabGui);
        buf.writeBoolean(this.openOptions);
        buf.writeBoolean(this.canStudentUse);
    }

    public static class EduRandomServerMessageHandler
    implements IMessageHandler<EduRandomServerMessage, IMessage> {
        @Override
        public IMessage onMessage(EduRandomServerMessage message, MessageContext ctx) {
            if (message.isEduTeleportLocations) {
                if (message.openOptions) {
                    McEduForgeMod.proxy.displayTeleportGuiRename(message);
                } else {
                    McEduForgeMod.proxy.displayTeleportGui(message);
                }
            } else if (!message.isEduTeleportLocations) {
                EduClientTemp.getS().teleportlocations = message.allTeleportLocations;
                if (message.refreshTeleportTabGui) {
                    McEduForgeMod.proxy.displayTeleportGuiStations(message);
                }
            }
            return null;
        }
    }
}

