/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduServerSettings;

public class EduRandomClientMessage
implements IMessage {
    public boolean handleFreeFlyModePacket = false;
    public boolean freeMode = false;
    public boolean isEduTeleportLocations = false;
    public String currentLocationName = "";
    public String currentLocationCoordinates = "";
    public String allTeleportLocations = "";
    public String allowedTeleportLocations = "";
    public boolean refreshTeleportTabGui = false;
    public boolean openOptions = false;
    public boolean canStudentuse = false;

    @Override
    public void fromBytes(ByteBuf buf) {
        this.handleFreeFlyModePacket = buf.readBoolean();
        this.freeMode = buf.readBoolean();
        this.isEduTeleportLocations = buf.readBoolean();
        this.currentLocationCoordinates = ByteBufUtils.readUTF8String(buf);
        this.currentLocationName = ByteBufUtils.readUTF8String(buf);
        this.allTeleportLocations = ByteBufUtils.readUTF8String(buf);
        this.allowedTeleportLocations = ByteBufUtils.readUTF8String(buf);
        this.refreshTeleportTabGui = buf.readBoolean();
        this.openOptions = buf.readBoolean();
        this.canStudentuse = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.handleFreeFlyModePacket);
        buf.writeBoolean(this.freeMode);
        buf.writeBoolean(this.isEduTeleportLocations);
        ByteBufUtils.writeUTF8String(buf, this.currentLocationCoordinates);
        ByteBufUtils.writeUTF8String(buf, this.currentLocationName);
        ByteBufUtils.writeUTF8String(buf, this.allTeleportLocations);
        ByteBufUtils.writeUTF8String(buf, this.allowedTeleportLocations);
        buf.writeBoolean(this.refreshTeleportTabGui);
        buf.writeBoolean(this.openOptions);
        buf.writeBoolean(this.canStudentuse);
    }

    public static class EduRandomClientMessageHandler
    implements IMessageHandler<EduRandomClientMessage, IMessage> {
        @Override
        public IMessage onMessage(EduRandomClientMessage message, MessageContext ctx) {
            if (message.handleFreeFlyModePacket) {
                ctx.getServerHandler().b.playerabilities.isInFreeFly = message.freeMode;
            }
            if (message.isEduTeleportLocations) {
                Datahandler.iniSet(EduServerSettings.getS().pathMapTeleportLocationsFile, message.currentLocationCoordinates, message.currentLocationName);
            }
            return null;
        }
    }
}

