/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mcedu.EduAccessHelperServer;
import mcedu.client.EduQuizMessageGui;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduLogActionHandler;
import mcedu.server.EduLogActionType;
import mcedu.server.EduServerSettings;

public class EduQuizMessage
implements IMessage {
    public String questionID = "";
    public String questionTitle = "";
    public String questionText = "";
    public String questionNumAnswers = "";
    public String location = "";
    public String questionAnswer1 = "";
    public String questionAnswer2 = "";
    public String questionAnswer3 = "";
    public String questionAnswer4 = "";
    public String questionAnswer5 = "";

    public EduQuizMessage() {
    }

    public EduQuizMessage(String id, String title, String text, String num, String q1, String q2, String q3, String q4, String q5, String loc) {
        this.questionID = id;
        this.questionTitle = title;
        this.questionText = text;
        this.questionNumAnswers = num;
        this.questionAnswer1 = q1;
        this.questionAnswer2 = q2;
        this.questionAnswer3 = q3;
        this.questionAnswer4 = q4;
        this.questionAnswer5 = q5;
        this.location = loc;
    }

    public EduQuizMessage(String[] list, String location) {
        if (list == null || list.length == 1) {
            this.questionID = "";
            this.questionTitle = "";
            this.questionText = "";
            this.questionNumAnswers = "";
            this.questionAnswer1 = "";
            this.questionAnswer2 = "";
            this.questionAnswer3 = "";
            this.questionAnswer4 = "";
            this.questionAnswer5 = "";
        } else {
            this.questionID = list[0];
            this.questionTitle = list[1];
            this.questionText = list[2];
            this.questionNumAnswers = list[3];
            if (!this.questionNumAnswers.equals("0")) {
                ArrayList<String> questionAnswerList = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    if (i < Integer.parseInt(this.questionNumAnswers)) {
                        questionAnswerList.add(i, list[4 + i]);
                        continue;
                    }
                    questionAnswerList.add(i, "");
                }
                this.questionAnswer1 = (String)questionAnswerList.get(0);
                this.questionAnswer2 = (String)questionAnswerList.get(1);
                this.questionAnswer3 = (String)questionAnswerList.get(2);
                this.questionAnswer4 = (String)questionAnswerList.get(3);
                this.questionAnswer5 = (String)questionAnswerList.get(4);
            } else if (this.questionNumAnswers.equals("0")) {
                List questionAnswerList = new ArrayList();
                questionAnswerList = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapQuestionLocationsFile);
                String[] info = ((String)questionAnswerList.get(0)).split("=")[1].split(",");
                try {
                    this.questionAnswer1 = info[4];
                }
                catch (Exception e) {
                    System.out.println("Failed to find the answer for fill blank in file");
                    this.questionAnswer1 = "";
                    this.questionAnswer2 = "";
                    this.questionAnswer3 = "";
                    this.questionAnswer4 = "";
                    this.questionAnswer5 = "";
                }
            } else {
                this.questionAnswer1 = "";
                this.questionAnswer2 = "";
                this.questionAnswer3 = "";
                this.questionAnswer4 = "";
                this.questionAnswer5 = "";
            }
        }
        this.location = location;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.questionID = ByteBufUtils.readUTF8String(buf);
        this.questionTitle = ByteBufUtils.readUTF8String(buf);
        this.questionText = ByteBufUtils.readUTF8String(buf);
        this.questionNumAnswers = ByteBufUtils.readUTF8String(buf);
        this.questionAnswer1 = ByteBufUtils.readUTF8String(buf);
        this.questionAnswer2 = ByteBufUtils.readUTF8String(buf);
        this.questionAnswer3 = ByteBufUtils.readUTF8String(buf);
        this.questionAnswer4 = ByteBufUtils.readUTF8String(buf);
        this.questionAnswer5 = ByteBufUtils.readUTF8String(buf);
        this.location = ByteBufUtils.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String(buf, this.questionID);
        ByteBufUtils.writeUTF8String(buf, this.questionTitle);
        ByteBufUtils.writeUTF8String(buf, this.questionText);
        ByteBufUtils.writeUTF8String(buf, this.questionNumAnswers);
        ByteBufUtils.writeUTF8String(buf, this.questionAnswer1);
        ByteBufUtils.writeUTF8String(buf, this.questionAnswer2);
        ByteBufUtils.writeUTF8String(buf, this.questionAnswer3);
        ByteBufUtils.writeUTF8String(buf, this.questionAnswer4);
        ByteBufUtils.writeUTF8String(buf, this.questionAnswer5);
        ByteBufUtils.writeUTF8String(buf, this.location);
    }

    public static class EduServerQuizMessageHandler
    implements IMessageHandler<EduQuizMessage, IMessage> {
        @Override
        public IMessage onMessage(EduQuizMessage message, MessageContext ctx) {
            String quizMessage = message.questionTitle.replaceAll(",", ";c;") + "," + message.questionText.replaceAll(",", ";c;") + "," + message.questionNumAnswers.replaceAll(",", ";c;") + "," + message.questionAnswer1.replaceAll(",", ";c;") + "," + message.questionAnswer2.replaceAll(",", ";c;") + "," + message.questionAnswer3.replaceAll(",", ";c;") + "," + message.questionAnswer4.replaceAll(",", ";c;") + "," + message.questionAnswer5.replaceAll(",", ";c;") + ",";
            String[] loc = message.location.split("\\.");
            try {
                List fileList;
                if (message.questionTitle.equals("-1")) {
                    EduLogActionType answerType = Boolean.parseBoolean(message.questionAnswer1) ? EduLogActionType.quizRight : EduLogActionType.quizWrong;
                    int dim = ctx.getServerHandler().b.ap;
                    mt world = EduAccessHelperServer.getServer().getWorldManager(dim);
                    if (loc[0].equals("null")) {
                        EduLogActionHandler.getS().update(message.questionText, message.questionID + "|" + message.questionNumAnswers, loc[0], loc[1], loc[2], answerType, 0);
                    }
                    int i = Integer.parseInt(loc[0]);
                    int j = Integer.parseInt(loc[1]);
                    int k2 = Integer.parseInt(loc[2]);
                    if (answerType == EduLogActionType.quizRight) {
                        world.a(i, j, k2, 8, 2);
                        EduAccessHelperServer.sendChatMessageToPlayer((yz)ctx.getServerHandler().b, "Your answer was correct");
                    } else {
                        world.a(i, j, k2, 0, 2);
                        EduAccessHelperServer.sendChatMessageToPlayer((yz)ctx.getServerHandler().b, "Your answer was incorrect");
                    }
                    EduLogActionHandler.getS().update(message.questionText, message.questionID + "|" + message.questionNumAnswers, i, j, k2, answerType, 0);
                    return null;
                }
                if (message.location.equals("0")) {
                    message.location = "null.null.null";
                    EduNetworkUtils.sendToStudents(message);
                } else {
                    fileList = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapQuestionLocationsFile);
                    for (String o : fileList) {
                        if (o.toString().split("=").length <= 1 || !String.valueOf(o.toString().split("=")[1].split(",")[0]).equals(message.questionID)) continue;
                        if (message.questionTitle.equals(";deleted;")) {
                            Datahandler.iniSet(EduServerSettings.getS().pathMapQuestionLocationsFile, o.toString().split("=")[0], "");
                            continue;
                        }
                        Datahandler.iniSet(EduServerSettings.getS().pathMapQuestionLocationsFile, o.toString().split("=")[0], message.questionID.replaceAll(",", ";c;") + "," + quizMessage);
                    }
                    if (message.questionTitle.equals(";deleted;")) {
                        return null;
                    }
                    Datahandler.iniSet(EduServerSettings.getS().pathMapQuestionLocationsFile, message.location, message.questionID.replaceAll(",", ";c;") + "," + quizMessage);
                    Datahandler.removeLineFromFile(EduServerSettings.getS().pathMapQuestionLocationsFile, "");
                }
                new File(EduServerSettings.getS().pathQuizzesDatabase).createNewFile();
                fileList = Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathQuizzesDatabase);
                if (message.questionTitle.equals(";deleted;")) {
                    Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathQuizzesDatabase, message.questionID);
                    return null;
                }
                Datahandler.iniSet(EduServerSettings.getS().pathQuizzesDatabase, message.questionID, quizMessage);
                Datahandler.removeLineFromFile(EduServerSettings.getS().pathQuizzesDatabase, "");
            }
            catch (Exception e) {
                System.out.println("Could not store note information given from player by packet to location.");
                e.printStackTrace();
            }
            return null;
        }
    }

    public static class EduClientQuizMessageHandler
    implements IMessageHandler<EduQuizMessage, IMessage> {
        @Override
        public IMessage onMessage(EduQuizMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().showGuiScreen((Object)new EduQuizMessageGui(message.questionID, message.questionTitle, message.questionText, message.questionNumAnswers, message.questionAnswer1, message.questionAnswer2, message.questionAnswer3, message.questionAnswer4, message.questionAnswer5, message.location));
            return null;
        }
    }
}

