/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mcedu.forgemod.McEduForgeMod;
import mcedu.forgemod.network.EduNetworkUtils;
import mcedu.global.tools.Datahandler;
import mcedu.server.EduServerSettings;

public class EduDialogMessage
implements IMessage {
    public String message;
    public String location;
    public int currentPage;
    public int maxPages;
    public boolean changePage;
    public int newPageNumber;
    public boolean canStudentUse;
    public boolean addPage;

    public EduDialogMessage() {
    }

    public EduDialogMessage(String message, String location, int currentPage, int maxPages, boolean canStudentUse) {
        this.message = message;
        this.location = location;
        this.currentPage = currentPage;
        this.maxPages = maxPages;
        this.canStudentUse = canStudentUse;
    }

    public EduDialogMessage(String message, String location, int currentPage, int maxPages) {
        this.message = message;
        this.location = location;
        this.currentPage = currentPage;
        this.maxPages = maxPages;
    }

    public EduDialogMessage(String location, int newPageNumber, boolean addPage, boolean canStudentUse) {
        this.location = location;
        this.changePage = true;
        this.newPageNumber = newPageNumber;
        this.message = "";
        this.currentPage = 0;
        this.maxPages = 0;
        this.addPage = addPage;
        this.canStudentUse = canStudentUse;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.message = ByteBufUtils.readUTF8String(buf);
        this.location = ByteBufUtils.readUTF8String(buf);
        this.currentPage = buf.readInt();
        this.maxPages = buf.readInt();
        this.changePage = buf.readBoolean();
        this.newPageNumber = buf.readInt();
        this.canStudentUse = buf.readBoolean();
        this.addPage = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String(buf, this.message);
        ByteBufUtils.writeUTF8String(buf, this.location);
        buf.writeInt(this.currentPage);
        buf.writeInt(this.maxPages);
        buf.writeBoolean(this.changePage);
        buf.writeInt(this.newPageNumber);
        buf.writeBoolean(this.canStudentUse);
        buf.writeBoolean(this.addPage);
    }

    public static class EduServerDialogMessageHandler
    implements IMessageHandler<EduDialogMessage, IMessage> {
        @Override
        public IMessage onMessage(EduDialogMessage message, MessageContext ctx) {
            block12: {
                String pageAddOne = Datahandler.iniGet(EduServerSettings.getS().pathMapNoteLocationsFile, message.location + "_" + (message.newPageNumber + 1));
                if (pageAddOne != null && pageAddOne.equals("")) {
                    Datahandler.removeLineFromFileThatStartsWith(EduServerSettings.getS().pathMapNoteLocationsFile, message.location + "_" + (message.newPageNumber + 1));
                }
                if (!message.changePage) {
                    try {
                        if (message.currentPage == 0) {
                            Datahandler.iniSet(EduServerSettings.getS().pathMapNoteLocationsFile, message.location, message.message);
                            break block12;
                        }
                        Datahandler.iniSet(EduServerSettings.getS().pathMapNoteLocationsFile, message.location + "_" + message.currentPage, message.message);
                    }
                    catch (Exception e) {
                        System.out.println("Could not store note information given from player by packet to location: " + message.location);
                        e.printStackTrace();
                    }
                } else {
                    String location = message.location;
                    String data = "";
                    int pageAmount = 0;
                    if (message.newPageNumber == 0) {
                        data = Datahandler.iniGetAlternative(EduServerSettings.getS().pathMapNoteLocationsFile, location);
                    } else {
                        data = Datahandler.iniGetAlternative(EduServerSettings.getS().pathMapNoteLocationsFile, location + "_" + message.newPageNumber);
                        if (data == null) {
                            Datahandler.iniSet(EduServerSettings.getS().pathMapNoteLocationsFile, location + "_" + message.newPageNumber, "");
                        }
                    }
                    if (data == null) {
                        data = "";
                    }
                    ArrayList noteDatas = (ArrayList)Datahandler.readLinesFromFileToList(EduServerSettings.getS().pathMapNoteLocationsFile);
                    boolean pageExists = false;
                    for (int kk = 0; kk < noteDatas.size(); ++kk) {
                        if (!((String)noteDatas.get(kk)).startsWith(location)) continue;
                        ++pageAmount;
                    }
                    if (message.newPageNumber + 1 > pageAmount && !message.addPage) {
                        --pageAmount;
                    }
                    EduNetworkUtils.sendToPlayer(new EduDialogMessage(data, location, message.newPageNumber, pageAmount, message.canStudentUse), ctx.getServerHandler().b);
                }
            }
            return null;
        }
    }

    public static class EduClientDialogMessageHandler
    implements IMessageHandler<EduDialogMessage, IMessage> {
        @Override
        public IMessage onMessage(EduDialogMessage message, MessageContext ctx) {
            McEduForgeMod.proxy.displayMessageDialogGui(message);
            return null;
        }
    }
}

