/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mcedu.EduAccessHelperClient;
import mcedu.client.EduClientAssignment;
import mcedu.client.EduClientSettings;
import mcedu.forgemod.McEduForgeMod;

public class EduAssignmentUtilMessage
implements IMessage {
    private String channel;
    private byte[] data;

    public EduAssignmentUtilMessage() {
    }

    public EduAssignmentUtilMessage(String channel, byte[] data) {
        this.channel = channel;
        this.data = data;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.channel = ByteBufUtils.readUTF8String(buf);
        this.data = new byte[ByteBufUtils.readVarShort(buf)];
        buf.readBytes(this.data);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String(buf, this.channel);
        ByteBufUtils.writeVarShort(buf, this.data.length);
        buf.writeBytes(this.data);
    }

    public static class EduAssignmentUtilMessageHandler
    implements IMessageHandler<EduAssignmentUtilMessage, IMessage> {
        @Override
        public IMessage onMessage(EduAssignmentUtilMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return null;
            }
            if (message.channel.startsWith("MCEDU|assignmentlist")) {
                if (message.data != null) {
                    try {
                        ArrayList<EduClientAssignment> assignments = new ArrayList<EduClientAssignment>();
                        String assignmentList = new String(message.data);
                        String[] singleAssignments = assignmentList.split("\\<\\|\\>");
                        String[] temp = new String[]{"", ""};
                        String studentAmount = "";
                        String id = "";
                        String title = "";
                        String desc = "";
                        String completers = "";
                        String teachers = "";
                        studentAmount = singleAssignments[0].split("\\<te\\>")[0];
                        teachers = singleAssignments[0].split("\\<te\\>")[1];
                        for (int i = 1; i < singleAssignments.length; ++i) {
                            temp = singleAssignments[i].split("\\<id\\>")[1].split("\\<de\\>");
                            id = temp[0];
                            temp = singleAssignments[i].split("\\<id\\>");
                            title = temp[0];
                            temp = singleAssignments[i].split("\\<de\\>")[1].split("\\<co\\>");
                            desc = temp[0];
                            if (singleAssignments[i].endsWith("<co>")) {
                                completers = "";
                            } else {
                                temp = singleAssignments[i].split("\\<co\\>");
                                completers = temp[1];
                            }
                            assignments.add(new EduClientAssignment(Integer.valueOf(id), Integer.valueOf(id), title, desc, completers, teachers));
                        }
                        McEduForgeMod.proxy.displayGuiAssignments(assignments, Integer.parseInt(studentAmount));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    McEduForgeMod.proxy.displayGuiAssignments(Lists.newArrayList(), 0);
                }
            } else if (message.channel.startsWith("MCEDU|asscompamount")) {
                EduClientSettings.getS().clientPlayerSettings.setCompletedAssignmentAmount(new String(message.data));
            } else if (message.channel.startsWith("MCEDU|assrefresh")) {
                EduAccessHelperClient.getMinecraft().h.a("/eduassignments getassignmentcompleteamount");
            }
            return null;
        }
    }
}

