/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcedu.client.EduClientSettings;
import mcedu.server.EduAssignmentHelper;

public class EduAssignmentMessage
implements IMessage {
    private int id;
    private String assignmentTitle = "";
    private String assignmentDescription = "";

    public EduAssignmentMessage() {
    }

    public EduAssignmentMessage(int id, String title, String description) {
        this.id = id;
        this.assignmentTitle = title;
        this.assignmentDescription = description;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.assignmentTitle = ByteBufUtils.readUTF8String(buf);
        this.assignmentDescription = ByteBufUtils.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String(buf, this.assignmentTitle);
        ByteBufUtils.writeUTF8String(buf, this.assignmentDescription);
    }

    public static class EduServerAssignmentMessageHandler
    implements IMessageHandler<EduAssignmentMessage, IMessage> {
        @Override
        public IMessage onMessage(EduAssignmentMessage message, MessageContext ctx) {
            if (message.id < 0) {
                EduAssignmentHelper.addAssignment(message.assignmentTitle, message.assignmentDescription, "", true);
            } else {
                EduAssignmentHelper.modifyAssignment(message.id, message.assignmentTitle, message.assignmentDescription);
            }
            return null;
        }
    }

    public static class EduClientAssignmentMessageHandler
    implements IMessageHandler<EduAssignmentMessage, IMessage> {
        @Override
        public IMessage onMessage(EduAssignmentMessage message, MessageContext ctx) {
            if (message.assignmentTitle.equals("") && message.assignmentDescription.equals("")) {
                EduClientSettings.getS().serverSettings.setAnnouncementSet(false);
                EduClientSettings.getS().serverSettings.setAnnouncementTitleInGame("");
                EduClientSettings.getS().serverSettings.setAnnouncementTitle(message.assignmentTitle);
                EduClientSettings.getS().serverSettings.setAnnouncementDescription(message.assignmentDescription);
            } else {
                EduClientSettings.getS().serverSettings.setAnnouncementSet(true);
                EduClientSettings.getS().serverSettings.setAnnouncementTitle(message.assignmentTitle);
                EduClientSettings.getS().serverSettings.setAnnouncementDescription(message.assignmentDescription);
                int inGameGuiMaxLength = 26;
                if (message.assignmentTitle.length() > inGameGuiMaxLength) {
                    EduClientSettings.getS().serverSettings.setAnnouncementTitleInGame(message.assignmentTitle.substring(0, inGameGuiMaxLength) + "...");
                } else {
                    EduClientSettings.getS().serverSettings.setAnnouncementTitleInGame(message.assignmentTitle);
                }
            }
            return null;
        }
    }
}

