/*
 * Decompiled with CFR 0.152.
 */
package mcedu.forgemod;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import mcedu.Debug;
import mcedu.EduAccessHelperClient;
import mcedu.client.EduClientSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EduKeyBindings {
    private static final Logger logger = LogManager.getLogger();
    private static EduKeyBindings instance;
    public static bal[] eduMenuKeyBindings;
    public static bal keyBindEduGuiPersonal;
    public static bal keyBindEduGuiGeneral;
    public static bal keyBindEduGuiWorld;
    public static bal keyBindEduGuiGive;
    public static bal keyBindEduGuiAssignment;
    public static bal keyBindEduGuiUsers;
    public static bal keyBindEduGuiStations;
    public static bal keyBindEduGuiBuildTools;
    public static bal keyBindEduGuiLastAdminMenu;
    public static bal[] eduCommandKeyBindings;
    public static bal keyBindEduCommandBuildMode;
    public static bal keyBindEduCommandFillTool;
    public static bal keyBindEduCommandCreativeMode;
    public static bal keyBindEduCommandFreezeStudents;
    public static bal keyBindEduCommandStudentsCanBuild;
    public static bal keyBindEduCommandMoveSpeed;
    public static bal keyBindEduCommandLongBuild;
    private static final String EDU_KEY_BIND_CATEGORY = "edukeybinding";

    private EduKeyBindings() {
    }

    public static EduKeyBindings getS() {
        if (instance == null) {
            instance = new EduKeyBindings();
        }
        return instance;
    }

    public String getEduGuiOptionDisplayString(int par1) {
        int i = eduMenuKeyBindings[par1].i();
        return bbj.c((int)i);
    }

    public String getEduGuiKeyBindingDescription(int par1) {
        de stringtranslate = de.a();
        return stringtranslate.a(eduMenuKeyBindings[par1].g());
    }

    public boolean setEduGuiKeyBinding(int par1, int par2) {
        if (eduMenuKeyBindings[par1].i() != par2 && this.checkIsKeyAlreadyInUse(par2)) {
            return false;
        }
        eduMenuKeyBindings[par1].b(par2);
        this.saveOptions();
        return true;
    }

    public void saveOptions() {
        if (FMLClientHandler.instance().isLoading()) {
            return;
        }
        try {
            int k2;
            PrintWriter eduWriter = new PrintWriter(new FileWriter(new File(EduClientSettings.getS().pathEduKeybindings)));
            for (k2 = 0; k2 < eduMenuKeyBindings.length; ++k2) {
                eduWriter.println("key_" + eduMenuKeyBindings[k2].g() + ":" + eduMenuKeyBindings[k2].i());
            }
            for (k2 = 0; k2 < eduCommandKeyBindings.length; ++k2) {
                eduWriter.println("key_" + eduCommandKeyBindings[k2].g() + ":" + eduCommandKeyBindings[k2].i());
            }
            eduWriter.close();
        }
        catch (Exception exception) {
            logger.error("Failed to save options", (Throwable)exception);
        }
    }

    public String getEduCommandOptionDisplayString(int par1) {
        int i = eduCommandKeyBindings[par1].i();
        return bbj.c((int)i);
    }

    public String getEduCommandKeyBindingDescription(int par1) {
        de stringtranslate = de.a();
        return stringtranslate.a(eduCommandKeyBindings[par1].g());
    }

    public boolean setEduCommandKeyBinding(int par1, int par2) {
        if (eduCommandKeyBindings[par1].i() != par2 && this.checkIsKeyAlreadyInUse(par2)) {
            return false;
        }
        eduCommandKeyBindings[par1].b(par2);
        this.saveOptions();
        return true;
    }

    public void initEduKeyBinds() {
        keyBindEduGuiPersonal = new bal("key.EduGuiPersonal", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiGeneral = new bal("key.EduGuiGeneral", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiWorld = new bal("key.EduGuiWorld", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiGive = new bal("key.EduGuiGive", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiAssignment = new bal("key.EduGuiAssignment", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiUsers = new bal("key.EduGuiUsers", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiStations = new bal("key.EduGuiStations", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiBuildTools = new bal("key.EduGuiBuildTools", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduGuiLastAdminMenu = new bal("key.EduGuiLastAdminMenu", 50, EDU_KEY_BIND_CATEGORY);
        eduMenuKeyBindings = new bal[]{keyBindEduGuiAssignment, keyBindEduGuiBuildTools, keyBindEduGuiGeneral, keyBindEduGuiGive, keyBindEduGuiPersonal, keyBindEduGuiStations, keyBindEduGuiUsers, keyBindEduGuiWorld, keyBindEduGuiLastAdminMenu};
        keyBindEduCommandBuildMode = new bal("key.EduCommandBuildMode", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandFillTool = new bal("key.EduCommandFill", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandCreativeMode = new bal("key.EduCommandCreativeSelf", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandFreezeStudents = new bal("key.EduCommandFreezeStudents", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandStudentsCanBuild = new bal("key.EduCommandStudentsCanBuild", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandMoveSpeed = new bal("key.EduCommandMoveSpeed", 0, EDU_KEY_BIND_CATEGORY);
        keyBindEduCommandLongBuild = new bal("key.EduCommandLongBuild", 0, EDU_KEY_BIND_CATEGORY);
        eduCommandKeyBindings = new bal[]{keyBindEduCommandBuildMode, keyBindEduCommandStudentsCanBuild, keyBindEduCommandFillTool, keyBindEduCommandFreezeStudents, keyBindEduCommandCreativeMode, keyBindEduCommandMoveSpeed, keyBindEduCommandLongBuild};
        this.registerKeyBindings();
    }

    private void registerKeyBindings() {
        ArrayList<bal> keybindings = new ArrayList<bal>();
        keybindings.addAll(Arrays.asList(eduCommandKeyBindings));
        keybindings.addAll(Arrays.asList(eduMenuKeyBindings));
        for (bal keybind : keybindings) {
            ClientRegistry.registerKeyBinding(keybind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOptions() {
        BufferedReader eduBufferedReader = null;
        try {
            eduBufferedReader = new BufferedReader(new FileReader(new File(EduClientSettings.getS().pathEduKeybindings)));
            String eduLine = "";
            while ((eduLine = eduBufferedReader.readLine()) != null) {
                int i;
                String[] var3 = eduLine.split(":");
                for (i = 0; i < eduMenuKeyBindings.length; ++i) {
                    if (!var3[0].equals("key_" + eduMenuKeyBindings[i].g())) continue;
                    eduMenuKeyBindings[i].b(Integer.parseInt(var3[1]));
                }
                for (i = 0; i < eduCommandKeyBindings.length; ++i) {
                    if (!var3[0].equals("key_" + eduCommandKeyBindings[i].g())) continue;
                    eduCommandKeyBindings[i].b(Integer.parseInt(var3[1]));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
        finally {
            try {
                eduBufferedReader.close();
            }
            catch (Exception e) {
                System.out.println("Could not load edu keybindings from file. Maybe the file is not yet there.");
            }
            bal.b();
        }
    }

    private boolean checkIsKeyAlreadyInUse(int key) {
        int i;
        if (key == -100 || key == -99) {
            return true;
        }
        for (i = 0; i < eduCommandKeyBindings.length; ++i) {
            if (key == 0 || eduCommandKeyBindings[i].i() != key) continue;
            Debug.printDebug("KEY ALREADY IN USE!!!");
            return true;
        }
        for (i = 0; i < eduMenuKeyBindings.length; ++i) {
            if (key == 0 || eduMenuKeyBindings[i].i() != key) continue;
            Debug.printDebug("KEY ALREADY IN USE!!!");
            return true;
        }
        for (i = 0; i < EduAccessHelperClient.getMinecraft().u.as.length; ++i) {
            if (key == 0 || EduAccessHelperClient.getMinecraft().u.as[i].i() != key) continue;
            Debug.printDebug("KEY ALREADY IN USE!!!");
            return true;
        }
        return false;
    }
}

