/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.region;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import mcedu.converter.region.Region;

public class RegionCache {
    private static final int MAX_CACHE_SIZE = 256;
    private static final Map<File, Reference<Region>> cache = new HashMap<File, Reference<Region>>();

    private RegionCache() {
    }

    public static synchronized Region getRegionFile(File basePath, int chunkX, int chunkZ) {
        File regionDir = new File(basePath, "region");
        File file = new File(regionDir, "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + ".mcr");
        Reference<Region> ref = cache.get(file);
        if (ref != null && ref.get() != null) {
            return ref.get();
        }
        if (!regionDir.exists()) {
            regionDir.mkdirs();
        }
        if (cache.size() >= 256) {
            RegionCache.clear();
        }
        Region reg = new Region(file);
        cache.put(file, new SoftReference<Region>(reg));
        return reg;
    }

    public static synchronized void clear() {
        for (Reference<Region> ref : cache.values()) {
            try {
                if (ref.get() == null) continue;
                ref.get().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        cache.clear();
    }
}

